/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;

public class OServerCommandPostAuthToken
extends OServerCommandAbstract {
    private static final String[] NAMES = new String[]{"POST|token/*"};
    private static final String RESPONSE_FORMAT = "indent:-1,attribSameRow";
    private volatile OTokenHandler tokenHandler;

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private void init() {
        if (this.tokenHandler == null && this.server.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.NETWORK_HTTP_USE_TOKEN)) {
            this.tokenHandler = this.server.getTokenHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.init();
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 2, "Syntax error: token/<database>");
        iRequest.setDatabaseName(urlParts[1]);
        iRequest.getData().commandInfo = "Generate authentication token";
        Map<String, String> content = iRequest.getUrlEncodedContent();
        if (content == null) {
            ODocument result = new ODocument().field("error", (Object)"missing_auth_data");
            this.sendError(iRequest, iResponse, result);
            return false;
        }
        String signedToken = "";
        String grantType = content.get("grant_type").toLowerCase(Locale.ENGLISH);
        String username = content.get("username");
        String password = content.get("password");
        if (grantType.equals("password")) {
            String authenticatedRid = this.authenticate(username, password, iRequest.getDatabaseName());
            if (authenticatedRid == null) {
                this.sendAuthorizationRequest(iRequest, iResponse, iRequest.getDatabaseName());
            } else if (this.tokenHandler != null) {
                OSecurityUser user = null;
                try (ODatabaseDocumentInternal db = null;){
                    db = this.server.openDatabase(iRequest.getDatabaseName(), username, password);
                    user = db.getUser();
                    if (user != null) {
                        byte[] tokenBytes = this.tokenHandler.getSignedWebToken((ODatabaseDocument)db, user);
                        signedToken = new String(tokenBytes);
                    }
                }
                ODocument result = new ODocument().field("access_token", (Object)signedToken).field("expires_in", (Object)3600);
                iResponse.writeRecord((ORecord)result, RESPONSE_FORMAT, null);
            } else {
                ODocument result = new ODocument().field("error", (Object)"unsupported_grant_type");
                this.sendError(iRequest, iResponse, result);
            }
        } else {
            ODocument result = new ODocument().field("error", (Object)"unsupported_grant_type");
            this.sendError(iRequest, iResponse, result);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String authenticate(String username, String password, String iDatabaseName) throws IOException {
        String userRid = null;
        try (ODatabaseDocumentInternal db = null;){
            db = this.server.openDatabase(iDatabaseName, username, password);
            userRid = db.getUser() == null ? "<server user>" : db.getUser().getDocument().getIdentity().toString();
        }
        return userRid;
    }

    protected void sendError(OHttpRequest iRequest, OHttpResponse iResponse, ODocument error) throws IOException {
        iResponse.send(400, "Bad request", "application/json", error.toJSON(), null);
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest, OHttpResponse iResponse, String iDatabaseName) throws IOException {
        String header = null;
        String xRequestedWithHeader = iRequest.getHeader("X-Requested-With");
        if (xRequestedWithHeader == null || !xRequestedWithHeader.equals("XMLHttpRequest")) {
            header = this.server.getSecurity().getAuthenticationHeader(iDatabaseName);
            Map headers = this.server.getSecurity().getAuthenticationHeaders(iDatabaseName);
            headers.entrySet().forEach(s -> iResponse.addHeader((String)s.getKey(), (String)s.getValue()));
        }
        if (this.isJsonResponse(iResponse)) {
            this.sendJsonError(iResponse, 400, "Bad request", "text/plain", "401 Unauthorized.", header);
        } else {
            iResponse.send(401, "Unauthorized", "text/plain", "401 Unauthorized.", header);
        }
    }
}

