/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ORemoteServerAvailabilityCheck;
import com.orientechnologies.orient.server.distributed.ORemoteServerChannel;
import java.io.IOException;

public class ORemoteServerController {
    private final ORemoteServerChannel[] requestChannels;
    private int requestChannelIndex = 0;
    private final ORemoteServerChannel[] responseChannels;
    private int responseChannelIndex = 0;
    private int protocolVersion = -1;
    public static final int CURRENT_PROTOCOL_VERSION = 2;
    public static final int MIN_SUPPORTED_PROTOCOL_VERSION = 2;

    public ORemoteServerController(ORemoteServerAvailabilityCheck check, String localNodeName, String iServer, String iURL, String user, String passwd) throws IOException {
        int i;
        if (user == null) {
            throw new IllegalArgumentException("User is null");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("Password is null");
        }
        ODistributedServerLog.debug((Object)this, localNodeName, iServer, ODistributedServerLog.DIRECTION.OUT, "Creating remote channel(s) to distributed server...", new Object[0]);
        this.requestChannels = new ORemoteServerChannel[OGlobalConfiguration.DISTRIBUTED_REQUEST_CHANNELS.getValueAsInteger()];
        for (i = 0; i < this.requestChannels.length; ++i) {
            this.requestChannels[i] = new ORemoteServerChannel(check, localNodeName, iServer, iURL, user, passwd, 2);
        }
        this.protocolVersion = this.requestChannels[0].getDistributedProtocolVersion();
        this.responseChannels = new ORemoteServerChannel[OGlobalConfiguration.DISTRIBUTED_RESPONSE_CHANNELS.getValueAsInteger()];
        for (i = 0; i < this.responseChannels.length; ++i) {
            this.responseChannels[i] = new ORemoteServerChannel(check, localNodeName, iServer, iURL, user, passwd, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(ODistributedRequest req) {
        ORemoteServerChannel[] oRemoteServerChannelArray = this.requestChannels;
        synchronized (this.requestChannels) {
            ++this.requestChannelIndex;
            if (this.requestChannelIndex < 0) {
                this.requestChannelIndex = 0;
            }
            int idx = this.requestChannelIndex % this.requestChannels.length;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.requestChannels[idx].sendRequest(req);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(ODistributedResponse response) {
        ORemoteServerChannel[] oRemoteServerChannelArray = this.responseChannels;
        synchronized (this.responseChannels) {
            ++this.responseChannelIndex;
            if (this.responseChannelIndex < 0) {
                this.responseChannelIndex = 0;
            }
            int idx = this.responseChannelIndex % this.responseChannels.length;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.responseChannels[idx].sendResponse(response);
            return;
        }
    }

    public void close() {
        int i;
        for (i = 0; i < this.requestChannels.length; ++i) {
            this.requestChannels[i].close();
        }
        for (i = 0; i < this.responseChannels.length; ++i) {
            this.responseChannels[i].close();
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBinaryRequest(OBinaryRequest<?> request) {
        ORemoteServerChannel[] oRemoteServerChannelArray = this.requestChannels;
        synchronized (this.requestChannels) {
            ++this.requestChannelIndex;
            if (this.requestChannelIndex < 0) {
                this.requestChannelIndex = 0;
            }
            int idx = this.requestChannelIndex % this.requestChannels.length;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.requestChannels[idx].sendBinaryRequest(request);
            return;
        }
    }
}

