/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.orient.server.security.SwitchToDefaultParamsException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class OSelfSignedCertificate<tmpLocalHost> {
    public static final String DEFAULT_CERTIFICATE_TYPE = "X.509";
    public static final String DEFAULT_CERTIFICATE_ALGORITHM = "RSA";
    public static final int DEFAULT_CERTIFICATE_KEY_SIZE = 2048;
    public static final int DEFAULT_CERTIFICATE_VALIDITY = 365;
    public static final String DEFAULT_CERTIFICATE_OWNER = "CN=SelfSigenedOrientDBtestOnly, OU=SAP HANA Core, O=SAP SE, L=Walldorf, C=DE";
    public static final String DEFAULT_CERTIFICATE_NAME = "ssl";
    private String algorithm;
    private int key_size;
    private int validity;
    private KeyPair keyPair = null;
    private X509Certificate certificate = null;
    private String certificateName;
    private char[] certificate_pwd;
    private BigInteger certificateSN = OSelfSignedCertificate.computeRandomSerialNumber();
    private String ownerFDN;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm == null || algorithm.isEmpty() ? DEFAULT_CERTIFICATE_ALGORITHM : algorithm;
    }

    public int getKey_size() {
        return this.key_size;
    }

    public void setKey_size(int key_size) {
        this.key_size = key_size >= 128 ? key_size : 2048;
    }

    public int getValidity() {
        return this.validity;
    }

    public void setValidity(int validity) {
        this.validity = validity;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public char[] getCertificatePwd() {
        return this.certificate_pwd;
    }

    public void setCertificatePwd(char[] certificatePwd) {
        this.certificate_pwd = certificatePwd;
    }

    public BigInteger getCertificateSN() {
        return this.certificateSN;
    }

    public void setCertificateSN(long certificateSN) throws SwitchToDefaultParamsException {
        if (certificateSN <= 11L) {
            BigInteger sn;
            this.certificateSN = sn = OSelfSignedCertificate.computeRandomSerialNumber();
            throw new SwitchToDefaultParamsException("the value " + certificateSN + " culd not be used as a Certificate Serial Nuber, the value will be set to:" + sn);
        }
        this.certificateSN = BigInteger.valueOf(certificateSN);
    }

    public static BigInteger computeRandomSerialNumber() {
        SecureRandom sr = new SecureRandom();
        return BigInteger.valueOf(sr.nextLong());
    }

    public String getOwnerFDN() {
        return this.ownerFDN;
    }

    public void setOwnerFDN(String ownerFDN) {
        this.ownerFDN = ownerFDN;
    }

    public void setOwner_FDN(String CN, String OU, String O, String L, String C) {
        this.ownerFDN = "CN=" + CN + ", OU=" + OU + ", O=" + O + ", L=" + L + ", C=" + C;
    }

    public static KeyPair computeKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public void generateCertificateKeyPair() throws NoSuchAlgorithmException, SwitchToDefaultParamsException {
        try {
            this.keyPair = OSelfSignedCertificate.computeKeyPair(this.algorithm, this.key_size);
        }
        catch (NoSuchAlgorithmException e) {
            this.keyPair = OSelfSignedCertificate.computeKeyPair(DEFAULT_CERTIFICATE_ALGORITHM, 2048);
            SwitchToDefaultParamsException tmpe = new SwitchToDefaultParamsException();
            tmpe.addSuppressed(e);
            throw tmpe;
        }
    }

    public PublicKey getPublicKey() {
        if (this.keyPair == null) {
            throw new NullPointerException("generate the Key Pair");
        }
        return this.keyPair.getPublic();
    }

    public void composeSelfSignedCertificate() {
        try {
            this.certificate = OSelfSignedCertificate.generateSelfSignedCertificate(this.keyPair, this.validity, this.ownerFDN, this.certificateSN);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static X509Certificate generateSelfSignedCertificate(KeyPair keypair, int validity, String ownerFDN, BigInteger certSN) throws CertificateException, IOException {
        X509CertInfo info = new X509CertInfo();
        X500Name owner = new X500Name(ownerFDN);
        try {
            info.set("version", new CertificateVersion(2));
        }
        catch (IOException e) {
            try {
                info.set("version", new CertificateVersion(1));
            }
            catch (IOException ex) {
                info.set("version", new CertificateVersion(0));
            }
        }
        info.set("serialNumber", new CertificateSerialNumber(certSN));
        try {
            info.set("subject", new CertificateSubjectName(owner));
        }
        catch (CertificateException ignore) {
            info.set("subject", owner);
        }
        try {
            info.set("issuer", new CertificateIssuerName(owner));
        }
        catch (CertificateException ignore) {
            info.set("issuer", owner);
        }
        Calendar c = Calendar.getInstance();
        c.add(6, 0);
        Date from = c.getTime();
        c.add(6, validity);
        Date to = c.getTime();
        info.set("validity", new CertificateValidity(from, to));
        info.set("key", new CertificateX509Key(keypair.getPublic()));
        info.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha256WithRSAEncryption_oid)));
        X509CertImpl cert = new X509CertImpl(info);
        try {
            cert.sign(keypair.getPrivate(), "SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        info.set("algorithmID.algorithm", cert.get("x509.algorithm"));
        cert = new X509CertImpl(info);
        try {
            cert.sign(keypair.getPrivate(), "SHA256withRSA");
            cert.verify(keypair.getPublic());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return cert;
    }

    public X509Certificate getCertificate() throws CertificateException {
        if (this.certificate == null) {
            CertificateException cEx = new CertificateException("The Self-Signed Certificate han not been genetated! You have to invoke the composeSelfSignedCertificate() before get it.");
            throw cEx;
        }
        return this.certificate;
    }

    public static boolean checkCertificate(X509Certificate cert, PublicKey publicKey, Date date) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        cert.checkValidity(date);
        cert.verify(publicKey);
        return true;
    }

    public static boolean checkCertificate(X509Certificate cert, PublicKey publicKey) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        return OSelfSignedCertificate.checkCertificate(cert, publicKey, new Date(System.currentTimeMillis()));
    }

    public boolean checkThisCertificate() throws NoSuchAlgorithmException, CertificateException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return OSelfSignedCertificate.checkCertificate(this.certificate, this.keyPair.getPublic(), new Date(System.currentTimeMillis()));
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }
}

