/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.jwt.OJsonWebToken;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtPayload;
import com.orientechnologies.orient.core.metadata.security.jwt.OTokenHeader;
import com.orientechnologies.orient.core.metadata.security.jwt.OrientJwtHeader;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.token.OrientJwtPayload;

public class JsonWebToken
implements OJsonWebToken,
OToken {
    public final OTokenHeader header;
    public final OJwtPayload payload;
    private boolean isVerified = false;
    private boolean isValid = false;

    public JsonWebToken() {
        this((OTokenHeader)new OrientJwtHeader(), new OrientJwtPayload());
    }

    public JsonWebToken(OTokenHeader header, OJwtPayload payload) {
        this.header = header;
        this.payload = payload;
    }

    public OTokenHeader getHeader() {
        return this.header;
    }

    public OJwtPayload getPayload() {
        return this.payload;
    }

    public boolean getIsVerified() {
        return this.isVerified;
    }

    public void setIsVerified(boolean verified) {
        this.isVerified = verified;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(boolean valid) {
        this.isValid = valid;
    }

    public String getUserName() {
        return this.payload.getUserName();
    }

    public String getDatabase() {
        return this.getPayload().getDatabase();
    }

    public long getExpiry() {
        return this.getPayload().getExpiry();
    }

    public ORID getUserId() {
        return ((OrientJwtPayload)this.payload).getUserRid();
    }

    public String getDatabaseType() {
        return this.getPayload().getDatabaseType();
    }

    public OUser getUser(ODatabaseDocumentInternal db) {
        ORID userRid = ((OrientJwtPayload)this.payload).getUserRid();
        ODocument result = (ODocument)db.load(userRid, "roles:1");
        if (!result.getSchemaClass().isSubClassOf("OUser")) {
            result = null;
        }
        return new OUser(result);
    }

    public void setExpiry(long expiry) {
        this.payload.setExpiry(expiry);
    }

    public boolean isNowValid() {
        long now = System.currentTimeMillis();
        return this.getExpiry() > now && this.payload.getNotBefore() < now;
    }

    public boolean isCloseToExpire() {
        long now = System.currentTimeMillis();
        return this.getExpiry() - 120000L <= now;
    }
}

