/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandDeleteProperty
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"DELETE|property/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 4, "Syntax error: property/<database>/<class-name>/<property-name>");
        iRequest.getData().commandInfo = "Delete property";
        iRequest.getData().commandDetail = urlParts[2] + "." + urlParts[3];
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            OClass cls = db.getMetadata().getSchema().getClass(urlParts[2]);
            cls.dropProperty(urlParts[3]);
            iResponse.send(200, "OK", "text/plain", null, null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

