/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.console.ODefaultConsoleReader;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OSystemDatabase;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBConfigBuilder;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.auth.OAuthenticationInfo;
import com.orientechnologies.orient.core.metadata.security.auth.OTokenAuthInfo;
import com.orientechnologies.orient.core.security.OInvalidPasswordException;
import com.orientechnologies.orient.core.security.OParsedToken;
import com.orientechnologies.orient.core.security.OSecurityConfig;
import com.orientechnologies.orient.core.security.OSecuritySystem;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OPushManager;
import com.orientechnologies.orient.server.OServerAware;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.OServerSecurityConfig;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerSocketFactoryConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.config.ODistributedConfig;
import com.orientechnologies.orient.server.handler.OConfigurableHooksManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.OServerSocketFactory;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSessionManager;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpDb;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import com.orientechnologies.orient.server.plugin.OServerPluginManager;
import com.orientechnologies.orient.server.token.OTokenHandlerImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;

public class OServer {
    private static final String ROOT_PASSWORD_VAR = "ORIENTDB_ROOT_PASSWORD";
    private static ThreadGroup threadGroup;
    private static final Map<String, OServer> distributedServers;
    private CountDownLatch startupLatch;
    private CountDownLatch shutdownLatch;
    private final boolean shutdownEngineOnExit;
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean running = false;
    protected volatile boolean rejectRequests = true;
    protected OServerConfigurationManager serverCfg;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected Map<String, Class<? extends ONetworkProtocol>> networkProtocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected Map<String, OServerSocketFactory> networkSocketFactories = new HashMap<String, OServerSocketFactory>();
    protected List<OServerNetworkListener> networkListeners = new ArrayList<OServerNetworkListener>();
    protected List<OServerLifecycleListener> lifecycleListeners = new ArrayList<OServerLifecycleListener>();
    protected OServerPluginManager pluginManager;
    protected OConfigurableHooksManager hookManager;
    protected ODistributedServerManager distributedManager;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private String serverRootDirectory;
    private String databaseDirectory;
    private OClientConnectionManager clientConnectionManager;
    private OHttpSessionManager httpSessionManager;
    private OPushManager pushManager;
    private ClassLoader extensionClassLoader;
    private OTokenHandler tokenHandler;
    private OrientDB context;
    private OrientDBInternal databases;
    protected Date startedOn = new Date();

    public OServer() {
        this(!Orient.instance().isInsideWebContainer());
    }

    public OServer(boolean shutdownEngineOnExit) {
        boolean insideWebContainer = Orient.instance().isInsideWebContainer();
        if (insideWebContainer && shutdownEngineOnExit) {
            OLogManager.instance().warnNoDb((Object)this, "OrientDB instance is running inside of web application, it is highly unrecommended to force to shutdown OrientDB engine on server shutdown", new Object[0]);
        }
        this.shutdownEngineOnExit = shutdownEngineOnExit;
        this.serverRootDirectory = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}", (String)".");
        OLogManager.instance().installCustomFormatter();
        this.defaultSettings();
        threadGroup = new ThreadGroup("OrientDB Server");
        System.setProperty("com.sun.management.jmxremote", "true");
        Orient.instance().startup();
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean() && !Orient.instance().getProfiler().isRecording()) {
            Orient.instance().getProfiler().startRecording();
        }
        if (shutdownEngineOnExit) {
            this.shutdownHook = new OServerShutdownHook(this);
        }
    }

    public static OServer startFromFileConfig(String config) throws ClassNotFoundException, InstantiationException, IOException, IllegalAccessException {
        OServer server = new OServer(false);
        server.startup(config);
        server.activate();
        return server;
    }

    public static OServer startFromClasspathConfig(String config) throws ClassNotFoundException, InstantiationException, IOException, IllegalAccessException {
        OServer server = new OServer(false);
        server.startup(Thread.currentThread().getContextClassLoader().getResourceAsStream(config));
        server.activate();
        return server;
    }

    public static OServer startFromStreamConfig(InputStream config) throws ClassNotFoundException, InstantiationException, IOException, IllegalAccessException {
        OServer server = new OServer(false);
        server.startup(config);
        server.activate();
        return server;
    }

    public static OServer getInstance(String iServerId) {
        return distributedServers.get(iServerId);
    }

    public static OServer getInstanceByPath(String iPath) {
        for (Map.Entry<String, OServer> entry : distributedServers.entrySet()) {
            if (!iPath.startsWith(entry.getValue().getDatabaseDirectory())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void registerServerInstance(String iServerId, OServer iServer) {
        distributedServers.put(iServerId, iServer);
    }

    public static void unregisterServerInstance(String iServerId) {
        distributedServers.remove(iServerId);
    }

    public void setExtensionClassLoader(ClassLoader extensionClassLoader) {
        this.extensionClassLoader = extensionClassLoader;
    }

    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    public OSecuritySystem getSecurity() {
        return this.databases.getSecuritySystem();
    }

    public boolean isActive() {
        return this.running;
    }

    public OClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public OHttpSessionManager getHttpSessionManager() {
        return this.httpSessionManager;
    }

    public OPushManager getPushManager() {
        return this.pushManager;
    }

    public void saveConfiguration() throws IOException {
        this.serverCfg.saveConfiguration();
    }

    public void restart() throws ClassNotFoundException, InvocationTargetException, InstantiationException, NoSuchMethodException, IllegalAccessException, IOException {
        try {
            this.deinit();
        }
        finally {
            Orient.instance().startup();
            this.startup(this.serverCfg.getConfiguration());
            this.activate();
        }
    }

    public OSystemDatabase getSystemDatabase() {
        return this.databases.getSystemDatabase();
    }

    public String getServerId() {
        return this.getSystemDatabase().getServerId();
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loaded = this.tryLoadClass(this.extensionClassLoader, name);
        if (loaded == null && (loaded = this.tryLoadClass(Thread.currentThread().getContextClassLoader(), name)) == null && (loaded = this.tryLoadClass(this.getClass().getClassLoader(), name)) == null) {
            loaded = Class.forName(name);
        }
        return loaded;
    }

    private Class<?> tryLoadClass(ClassLoader classLoader, String name) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public OServer startup() throws OConfigurationException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        Orient.instance().startup();
        this.startup(new File(OSystemVariableResolver.resolveSystemVariables((String)config)));
        return this;
    }

    public OServer startup(File iConfigurationFile) throws OConfigurationException {
        try {
            this.serverCfg = new OServerConfigurationManager(iConfigurationFile);
            return this.startupFromConfiguration();
        }
        catch (IOException e) {
            String message = "Error on reading server configuration from file: " + iConfigurationFile;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new OConfigurationException(message), (Throwable)e);
        }
    }

    public OServer startup(String iConfiguration) throws IOException {
        return this.startup(new ByteArrayInputStream(iConfiguration.getBytes()));
    }

    public OServer startup(InputStream iInputStream) throws IOException {
        if (iInputStream == null) {
            throw new OConfigurationException("Configuration file is null");
        }
        this.serverCfg = new OServerConfigurationManager(iInputStream);
        return this.startupFromConfiguration();
    }

    public OServer startup(OServerConfiguration iConfiguration) throws IllegalArgumentException, SecurityException, IOException {
        this.serverCfg = new OServerConfigurationManager(iConfiguration);
        return this.startupFromConfiguration();
    }

    public OServer startupFromConfiguration() throws IOException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        Orient.instance();
        if (this.startupLatch == null) {
            this.startupLatch = new CountDownLatch(1);
        }
        if (this.shutdownLatch == null) {
            this.shutdownLatch = new CountDownLatch(1);
        }
        this.initFromConfiguration();
        this.clientConnectionManager = new OClientConnectionManager(this);
        this.httpSessionManager = new OHttpSessionManager(this);
        this.pushManager = new OPushManager();
        this.rejectRequests = false;
        if (this.contextConfiguration.getValueAsBoolean(OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP)) {
            System.out.println("Dumping environment after server startup...");
            OGlobalConfiguration.dumpConfiguration((PrintStream)System.out);
        }
        this.databaseDirectory = (String)this.contextConfiguration.getValue("server.database.path", (Object)(this.serverRootDirectory + "/databases/"));
        this.databaseDirectory = OFileUtils.getPath((String)OSystemVariableResolver.resolveSystemVariables((String)this.databaseDirectory));
        this.databaseDirectory = this.databaseDirectory.replace("//", "/");
        this.databaseDirectory = new File(this.databaseDirectory).getCanonicalPath();
        this.databaseDirectory = OFileUtils.getPath((String)this.databaseDirectory);
        if (!this.databaseDirectory.endsWith("/")) {
            this.databaseDirectory = this.databaseDirectory + "/";
        }
        OrientDBConfigBuilder builder = OrientDBConfig.builder();
        for (OServerUserConfiguration user : this.serverCfg.getUsers()) {
            builder.addGlobalUser(user.getName(), user.getPassword(), user.getResources());
        }
        OrientDBConfig config = builder.fromContext(this.contextConfiguration).setSecurityConfig((OSecurityConfig)new OServerSecurityConfig(this, this.serverCfg)).build();
        if (this.contextConfiguration.getValueAsBoolean(OGlobalConfiguration.SERVER_BACKWARD_COMPATIBILITY)) {
            this.databases = ODatabaseDocumentTxInternal.getOrCreateEmbeddedFactory((String)this.databaseDirectory, (OrientDBConfig)config);
        } else {
            OServerConfiguration configuration = this.getConfiguration();
            if (configuration.distributed != null && configuration.distributed.enabled.booleanValue()) {
                try {
                    OrientDBConfig orientDBConfig = ODistributedConfig.buildConfig(this.contextConfiguration, ODistributedConfig.fromEnv(configuration.distributed));
                    this.databases = OrientDBInternal.distributed((String)this.databaseDirectory, (OrientDBConfig)orientDBConfig);
                }
                catch (ODatabaseException ex) {
                    this.databases = OrientDBInternal.embedded((String)this.databaseDirectory, (OrientDBConfig)config);
                }
            } else {
                try {
                    this.databases = OrientDBInternal.distributed((String)this.databaseDirectory, (OrientDBConfig)config);
                }
                catch (ODatabaseException ex) {
                    this.databases = OrientDBInternal.embedded((String)this.databaseDirectory, (OrientDBConfig)config);
                }
            }
        }
        if (this.databases instanceof OServerAware) {
            ((OServerAware)this.databases).init(this);
        }
        this.context = this.databases.newOrientDB();
        OLogManager.instance().info((Object)this, "Databases directory: " + new File(this.databaseDirectory).getAbsolutePath(), new Object[0]);
        Orient.instance().getProfiler().registerHookValue("system.databases", "List of databases configured in Server", OProfiler.METRIC_TYPE.TEXT, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                StringBuilder dbs = new StringBuilder(64);
                for (String dbName : OServer.this.getAvailableStorageNames().keySet()) {
                    if (dbs.length() > 0) {
                        dbs.append(',');
                    }
                    dbs.append(dbName);
                }
                return dbs.toString();
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public OServer activate() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.lock.lock();
        try {
            void var2_13;
            boolean bl;
            this.initSystemDatabase();
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onBeforeActivate();
            }
            OServerConfiguration configuration = this.serverCfg.getConfiguration();
            this.tokenHandler = new OTokenHandlerImpl(this.databases.getSecuritySystem().getTokenSign(), this.getContextConfiguration());
            if (configuration.network != null) {
                if (configuration.network.sockets != null) {
                    for (OServerSocketFactoryConfiguration oServerSocketFactoryConfiguration : configuration.network.sockets) {
                        Class<?> fClass = this.loadClass(oServerSocketFactoryConfiguration.implementation);
                        OServerSocketFactory factory = (OServerSocketFactory)fClass.newInstance();
                        try {
                            factory.config(oServerSocketFactoryConfiguration.name, oServerSocketFactoryConfiguration.parameters);
                            this.networkSocketFactories.put(oServerSocketFactoryConfiguration.name, factory);
                        }
                        catch (OConfigurationException e) {
                            OLogManager.instance().error((Object)this, "Error creating socket factory", (Throwable)e, new Object[0]);
                        }
                    }
                }
                for (OServerNetworkProtocolConfiguration oServerNetworkProtocolConfiguration : configuration.network.protocols) {
                    this.networkProtocols.put(oServerNetworkProtocolConfiguration.name, this.loadClass(oServerNetworkProtocolConfiguration.implementation));
                }
                for (OServerNetworkListenerConfiguration oServerNetworkListenerConfiguration : configuration.network.listeners) {
                    this.networkListeners.add(new OServerNetworkListener(this, this.networkSocketFactories.get(oServerNetworkListenerConfiguration.socket), oServerNetworkListenerConfiguration.ipAddress, oServerNetworkListenerConfiguration.portRange, oServerNetworkListenerConfiguration.protocol, this.networkProtocols.get(oServerNetworkListenerConfiguration.protocol), oServerNetworkListenerConfiguration.parameters, oServerNetworkListenerConfiguration.commands));
                }
            } else {
                OLogManager.instance().warn((Object)this, "Network configuration was not found", new Object[0]);
            }
            try {
                this.loadStorages();
                this.loadUsers();
                this.loadDatabases();
            }
            catch (IOException iOException) {
                String string = "Error on reading server configuration";
                OLogManager.instance().error((Object)this, "Error on reading server configuration", (Throwable)iOException, new Object[0]);
                throw OException.wrapException((OException)((Object)new OConfigurationException("Error on reading server configuration")), (Throwable)iOException);
            }
            this.registerPlugins();
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onAfterActivate();
            }
            this.running = true;
            String string = "localhost:2480";
            boolean bl2 = false;
            for (OServerNetworkListener listener : this.getNetworkListeners()) {
                if (!listener.getProtocolType().getName().equals(ONetworkProtocolHttpDb.class.getName())) continue;
                String string2 = listener.getListeningAddress(true);
                bl = listener.getSocketFactory().isEncrypted();
            }
            String proto = bl ? "https" : "http";
            OLogManager.instance().info((Object)this, "OrientDB Studio available at $ANSI{blue %s://%s/studio/index.html}", new Object[]{proto, var2_13});
            OLogManager.instance().info((Object)this, "$ANSI{green:italic OrientDB Server is active} v" + OConstants.getVersion() + ".", new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException e) {
            this.deinit();
            throw e;
        }
        finally {
            this.lock.unlock();
            this.startupLatch.countDown();
        }
        if (this.distributedManager != null) {
            try {
                this.distributedManager.waitUntilNodeOnline();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
            this.shutdownHook = null;
        }
    }

    public boolean shutdown() {
        try {
            boolean res;
            boolean bl = res = this.deinit();
            return bl;
        }
        finally {
            this.startupLatch = null;
            if (this.shutdownLatch != null) {
                this.shutdownLatch.countDown();
                this.shutdownLatch = null;
            }
            if (this.shutdownEngineOnExit) {
                OLogManager.instance().shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deinit() {
        try {
            this.running = false;
            OLogManager.instance().info((Object)this, "OrientDB Server is shutting down...", new Object[0]);
            if (this.shutdownHook != null) {
                this.shutdownHook.cancel();
            }
            Orient.instance().getProfiler().unregisterHookValue("system.databases");
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onBeforeDeactivate();
            }
            this.lock.lock();
            try {
                if (this.networkListeners.size() > 0) {
                    OLogManager.instance().info((Object)this, "Shutting down listeners:", new Object[0]);
                    for (OServerNetworkListener oServerNetworkListener : this.networkListeners) {
                        OLogManager.instance().info((Object)this, "- %s", new Object[]{oServerNetworkListener});
                        try {
                            oServerNetworkListener.shutdown();
                        }
                        catch (Exception e) {
                            OLogManager.instance().error((Object)this, "Error during shutdown of listener %s.", (Throwable)e, new Object[]{oServerNetworkListener});
                        }
                    }
                }
                if (this.networkProtocols.size() > 0) {
                    OLogManager.instance().info((Object)this, "Shutting down protocols", new Object[0]);
                    this.networkProtocols.clear();
                }
                for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                    try {
                        oServerLifecycleListener.onAfterDeactivate();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during deactivation of server lifecycle listener %s", (Throwable)e, new Object[]{oServerLifecycleListener});
                    }
                }
                this.rejectRequests = true;
                this.pushManager.shutdown();
                this.clientConnectionManager.shutdown();
                this.httpSessionManager.shutdown();
                if (this.pluginManager != null) {
                    this.pluginManager.shutdown();
                }
                this.networkListeners.clear();
            }
            finally {
                this.lock.unlock();
            }
            if (this.shutdownEngineOnExit && !Orient.isRegisterDatabaseByPath()) {
                try {
                    OLogManager.instance().info((Object)this, "Shutting down databases:", new Object[0]);
                    Orient.instance().shutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during OrientDB shutdown", (Throwable)e, new Object[0]);
                }
            }
            if (!this.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.SERVER_BACKWARD_COMPATIBILITY) && this.databases != null) {
                this.databases.close();
                this.databases = null;
            }
        }
        finally {
            OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete\n", new Object[0]);
            OLogManager.instance().flush();
        }
        return true;
    }

    public boolean rejectRequests() {
        return this.rejectRequests;
    }

    public void waitForShutdown() {
        try {
            if (this.shutdownLatch != null) {
                this.shutdownLatch.await();
            }
        }
        catch (InterruptedException e) {
            OLogManager.instance().error((Object)this, "Error during waiting for OrientDB shutdown", (Throwable)e, new Object[0]);
        }
    }

    public Map<String, String> getAvailableStorageNames() {
        Set<String> dbs = this.listDatabases();
        HashMap<String, String> toSend = new HashMap<String, String>();
        for (String dbName : dbs) {
            toSend.put(dbName, dbName);
        }
        return toSend;
    }

    protected void loadDatabases() {
        if (!this.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.SERVER_OPEN_ALL_DATABASES_AT_STARTUP)) {
            return;
        }
        this.getDatabases().loadAllDatabases();
    }

    private boolean askForEncryptionKey(String iDatabaseName) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println();
        System.out.println();
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------------+}"));
        System.out.println(OAnsiCode.format((String)String.format("$ANSI{yellow | INSERT THE KEY FOR THE ENCRYPTED DATABASE %-31s|}", "'" + iDatabaseName + "'")));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------------+}"));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM setting        |}"));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow | 'storage.encryptionKey' to the key to use.                               |}"));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------------+}"));
        System.out.print(OAnsiCode.format((String)"\n$ANSI{yellow Database encryption key [BLANK=to skip opening]: }"));
        ODefaultConsoleReader reader = new ODefaultConsoleReader();
        try {
            String key = reader.readPassword();
            if (key != null && !(key = key.trim()).isEmpty()) {
                OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.setValue((Object)key);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String getDatabaseDirectory() {
        return this.databaseDirectory;
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        return this.authenticateUser(iUserName, iPassword, iResourceToCheck) != null;
    }

    public OSecurityUser authenticateUser(String iUserName, String iPassword, String iResourceToCheck) {
        return this.databases.getSecuritySystem().authenticateAndAuthorize(iUserName, iPassword, iResourceToCheck);
    }

    public boolean existsStoragePath(String iURL) {
        return this.serverCfg.getConfiguration().getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.serverCfg.getConfiguration();
    }

    public Map<String, Class<? extends ONetworkProtocol>> getNetworkProtocols() {
        return this.networkProtocols;
    }

    public List<OServerNetworkListener> getNetworkListeners() {
        return this.networkListeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.networkListeners) {
            if (!iProtocolClass.isAssignableFrom(l.getProtocolType())) continue;
            return (RET)l;
        }
        return null;
    }

    public Collection<OServerPluginInfo> getPlugins() {
        return this.pluginManager != null ? this.pluginManager.getPlugins() : null;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerPlugin> RET getPluginByClass(Class<RET> iPluginClass) {
        if (this.startupLatch == null) {
            throw new ODatabaseException("Error on plugin lookup: the server did not start correctly");
        }
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.running) {
            throw new ODatabaseException("Error on plugin lookup the server did not start correctly.");
        }
        for (OServerPluginInfo h : this.getPlugins()) {
            if (h.getInstance() == null || !h.getInstance().getClass().equals(iPluginClass)) continue;
            return (RET)h.getInstance();
        }
        return null;
    }

    public <RET extends OServerPlugin> RET getPlugin(String iName) {
        if (this.startupLatch == null) {
            throw new ODatabaseException("Error on plugin lookup: the server did not start correctly");
        }
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.running) {
            throw new ODatabaseException("Error on plugin lookup: the server did not start correctly");
        }
        OServerPluginInfo p = this.pluginManager.getPluginByName(iName);
        if (p != null) {
            return (RET)p.getInstance();
        }
        return null;
    }

    public Object getVariable(String iName) {
        return this.variables.get(iName);
    }

    public OServer setVariable(String iName, Object iValue) {
        if (iValue == null) {
            this.variables.remove(iName);
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    public void addTemporaryUser(String iName, String iPassword, String iPermissions) {
        this.databases.getSecuritySystem().addTemporaryUser(iName, iPassword, iPermissions);
    }

    public OServer registerLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.add(iListener);
        return this;
    }

    public OServer unregisterLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.remove(iListener);
        return this;
    }

    public ODatabaseDocumentInternal openDatabase(String iDbUrl, OParsedToken iToken) {
        return this.databases.open((OAuthenticationInfo)new OTokenAuthInfo(iToken), OrientDBConfig.defaultConfig());
    }

    public ODatabaseDocumentInternal openDatabase(String iDbUrl, String user, String password) {
        return this.openDatabase(iDbUrl, user, password, null);
    }

    public ODatabaseDocumentInternal openDatabase(String iDbUrl, String user, String password, ONetworkProtocolData data) {
        boolean serverAuth = false;
        ODatabaseDocumentInternal database = this.databases.open(iDbUrl, user, password);
        if ("Server".equals(database.getUser().getUserType())) {
            serverAuth = true;
        }
        if (serverAuth && data != null) {
            data.serverUser = true;
            data.serverUsername = user;
        } else if (data != null) {
            data.serverUser = false;
            data.serverUsername = null;
        }
        return database;
    }

    public ODatabaseDocumentInternal openDatabase(String database) {
        return this.getDatabases().openNoAuthorization(database);
    }

    public ODistributedServerManager getDistributedManager() {
        return this.distributedManager;
    }

    public void setServerRootDirectory(String rootDirectory) {
        this.serverRootDirectory = rootDirectory;
    }

    protected void initFromConfiguration() {
        OServerConfiguration cfg = this.serverCfg.getConfiguration();
        this.contextConfiguration = new OContextConfiguration();
        if (cfg.properties != null) {
            for (OServerEntryConfiguration prop : cfg.properties) {
                this.contextConfiguration.setValue(prop.name, (Object)prop.value);
            }
        }
        this.hookManager = new OConfigurableHooksManager(cfg);
    }

    public OConfigurableHooksManager getHookManager() {
        return this.hookManager;
    }

    protected void loadUsers() throws IOException {
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        if (configuration.isAfterFirstTime) {
            return;
        }
        configuration.isAfterFirstTime = true;
        this.createDefaultServerUsers();
    }

    protected void loadStorages() {
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        if (configuration.storages == null) {
            return;
        }
        for (OServerStorageConfiguration stg : configuration.storages) {
            int typeIndex;
            if (!stg.loadOnStartup) continue;
            String url = stg.path;
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if ((typeIndex = (url = url.replace('\\', '/')).indexOf(58)) <= 0) {
                throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + url);
            }
            String remoteUrl = url.substring(typeIndex + 1);
            int index = remoteUrl.lastIndexOf(47);
            String baseUrl = index > 0 ? remoteUrl.substring(0, index) : "./";
            this.databases.initCustomStorage(stg.name, baseUrl, stg.userName, stg.userPassword);
        }
    }

    protected void createDefaultServerUsers() throws IOException {
        boolean existsRoot;
        if (this.databases.getSecuritySystem() != null && !this.databases.getSecuritySystem().arePasswordsStored()) {
            return;
        }
        String rootPassword = OSystemVariableResolver.resolveVariable((String)ROOT_PASSWORD_VAR);
        if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
            rootPassword = null;
        }
        boolean bl = existsRoot = this.existsSystemUser("root") || this.serverCfg.existsUser("root");
        if (rootPassword == null && !existsRoot) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println();
            System.out.println();
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow |                WARNING: FIRST RUN CONFIGURATION               |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | This is the first time the server is running. Please type a   |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | password of your choice for the 'root' user or leave it blank |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | to auto-generate it.                                          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow |                                                               |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM     |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | setting ORIENTDB_ROOT_PASSWORD to the root password to use.   |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            ODefaultConsoleReader console = new ODefaultConsoleReader();
            do {
                System.out.print(OAnsiCode.format((String)"\n$ANSI{yellow Root password [BLANK=auto generate it]: }"));
                rootPassword = console.readPassword();
                if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
                    rootPassword = null;
                }
                if (rootPassword == null) continue;
                System.out.print(OAnsiCode.format((String)"$ANSI{yellow Please confirm the root password: }"));
                String rootConfirmPassword = console.readPassword();
                if (rootConfirmPassword != null && (rootConfirmPassword = rootConfirmPassword.trim()).isEmpty()) {
                    rootConfirmPassword = null;
                }
                if (!rootPassword.equals(rootConfirmPassword)) {
                    System.out.println(OAnsiCode.format((String)"$ANSI{red ERROR: Passwords don't match, please reinsert both of them, or press ENTER to auto generate it}"));
                    continue;
                }
                try {
                    if (this.getSecurity() != null) {
                        this.getSecurity().validatePassword("root", rootPassword);
                    }
                    break;
                }
                catch (OInvalidPasswordException ex) {
                    System.out.println(OAnsiCode.format((String)"$ANSI{red ERROR: Root password does not match the password policies}"));
                    if (ex.getMessage() == null) continue;
                    System.out.println(ex.getMessage());
                }
            } while (rootPassword != null);
        } else {
            OLogManager.instance().info((Object)this, "Found ORIENTDB_ROOT_PASSWORD variable, using this value as root's password", new Object[]{rootPassword});
        }
        if (!existsRoot) {
            this.context.execute("CREATE SYSTEM USER root IDENTIFIED BY ? ROLE root", new Object[]{rootPassword});
        }
        if (!this.existsSystemUser("guest")) {
            this.context.execute("CREATE SYSTEM USER guest IDENTIFIED BY ? ROLE guest", new Object[]{"!!!TheGuestPw123"});
        }
    }

    private boolean existsSystemUser(String user) {
        return Boolean.TRUE.equals(this.context.execute("EXISTS SYSTEM USER ?", new Object[]{user}).next().getProperty("exists"));
    }

    public OServerPluginManager getPluginManager() {
        return this.pluginManager;
    }

    protected void registerPlugins() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.pluginManager = new OServerPluginManager();
        this.pluginManager.config(this);
        this.pluginManager.startup();
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        if (configuration.handlers != null) {
            ArrayList<OServerPlugin> plugins = new ArrayList<OServerPlugin>();
            for (OServerHandlerConfiguration h : configuration.handlers) {
                OServerPlugin plugin;
                if (h.parameters != null) {
                    boolean enabled = true;
                    for (OServerParameterConfiguration p : h.parameters) {
                        if (!p.name.equals("enabled")) continue;
                        enabled = false;
                        String value = OSystemVariableResolver.resolveSystemVariables((String)p.value);
                        if (value == null || !"true".equalsIgnoreCase(value = value.trim())) continue;
                        enabled = true;
                        break;
                    }
                    if (!enabled) continue;
                }
                if ((plugin = (OServerPlugin)this.loadClass(h.clazz).newInstance()) instanceof ODistributedServerManager) {
                    this.distributedManager = (ODistributedServerManager)((Object)plugin);
                }
                this.pluginManager.registerPlugin(new OServerPluginInfo(plugin.getName(), null, null, null, plugin, null, 0L, null));
                this.pluginManager.callListenerBeforeConfig(plugin, h.parameters);
                plugin.config(this, h.parameters);
                this.pluginManager.callListenerAfterConfig(plugin, h.parameters);
                plugins.add(plugin);
            }
            for (OServerPlugin plugin : plugins) {
                this.pluginManager.callListenerBeforeStartup(plugin);
                plugin.startup();
                this.pluginManager.callListenerAfterStartup(plugin);
            }
        }
    }

    protected void defaultSettings() {
    }

    public OTokenHandler getTokenHandler() {
        return this.tokenHandler;
    }

    public ThreadGroup getThreadGroup() {
        return Orient.instance().getThreadGroup();
    }

    private void initSystemDatabase() {
        this.databases.getSystemDatabase().init();
    }

    public OrientDBInternal getDatabases() {
        return this.databases;
    }

    public OrientDB getContext() {
        return this.context;
    }

    public void dropDatabase(String databaseName) {
        if (!this.databases.exists(databaseName, null, null)) {
            throw new OStorageException("Database with name '" + databaseName + "' does not exist");
        }
        this.databases.drop(databaseName, null, null);
    }

    public boolean existsDatabase(String databaseName) {
        return this.databases.exists(databaseName, null, null);
    }

    public void createDatabase(String databaseName, ODatabaseType type, OrientDBConfig config) {
        this.databases.create(databaseName, null, null, type, config);
    }

    public Set<String> listDatabases() {
        Set dbs = this.databases.listDatabases(null, null);
        dbs.remove("OSystem");
        return dbs;
    }

    public void restore(String name, String path) {
        this.databases.restore(name, null, null, null, path, OrientDBConfig.defaultConfig());
    }

    public Date getStartedOn() {
        return this.startedOn;
    }

    static {
        distributedServers = new ConcurrentHashMap<String, OServer>();
    }
}

