/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.server.network.protocol.http.OChunkedResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponseAbstract;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OHttpGraphResponse
extends OHttpResponseAbstract {
    private OHttpResponse iWrapped;

    public OHttpGraphResponse(OHttpResponse iWrapped) {
        super(iWrapped.getOutputStream(), iWrapped.getHttpVersion(), iWrapped.getAdditionalHeaders(), iWrapped.getCharacterSet(), iWrapped.getServerInfo(), iWrapped.getSessionId(), iWrapped.getCallbackFunction(), iWrapped.isKeepAlive(), iWrapped.getConnection(), iWrapped.getContextConfiguration());
        this.iWrapped = iWrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            return;
        }
        if (!mode.equalsIgnoreCase("graph")) {
            super.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, mode);
            return;
        }
        if (accept != null && accept.contains("text/csv")) {
            throw new IllegalArgumentException("Graph mode cannot accept '" + accept + "'");
        }
        try (ODatabaseDocumentInternal graph = ODatabaseRecordThreadLocal.instance().get();){
            HashSet<Object> vertices = new HashSet<Object>();
            HashSet<ORID> edgeRids = new HashSet<ORID>();
            boolean lightweightFound = false;
            Iterator iIterator = OMultiValue.getMultiValueIterator((Object)iRecords);
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry != null && entry instanceof OResult && ((OResult)entry).isElement()) {
                    entry = ((OResult)entry).getElement().get();
                } else if (entry == null || !(entry instanceof OIdentifiable)) continue;
                if ((entry = ((OIdentifiable)entry).getRecord()) == null || !(entry instanceof OIdentifiable) || !(entry instanceof OElement)) continue;
                OElement element = (OElement)entry;
                if (element.isVertex()) {
                    vertices.add(element.asVertex().get());
                    continue;
                }
                if (!element.isEdge()) continue;
                OEdge edge = (OEdge)element.asEdge().get();
                vertices.add(edge.getTo());
                vertices.add(edge.getFrom());
                if (edge.getIdentity() != null) {
                    edgeRids.add(edge.getIdentity());
                    continue;
                }
                lightweightFound = true;
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, "");
            json.beginObject();
            json.beginObject((Object)"graph");
            json.beginCollection("vertices");
            for (OVertex oVertex : vertices) {
                json.beginObject();
                json.writeAttribute("@rid", (Object)oVertex.getIdentity());
                json.writeAttribute("@class", (Object)((OClass)oVertex.getSchemaType().get()).getName());
                for (String field : oVertex.getPropertyNames()) {
                    Object v = oVertex.getProperty(field);
                    if (v == null) continue;
                    json.writeAttribute(field, v);
                }
                json.endObject();
            }
            json.endCollection();
            if (lightweightFound) {
                edgeRids.clear();
            }
            json.beginCollection("edges");
            if (edgeRids.isEmpty()) {
                for (OVertex oVertex : vertices) {
                    Iterator<Object> iterator = oVertex.getEdges(ODirection.OUT).iterator();
                    while (iterator.hasNext()) {
                        OEdge e;
                        OEdge edge = e = (OEdge)iterator.next();
                        if (edgeRids.contains(e.getIdentity()) && e.getIdentity() != null || !vertices.contains(edge.getVertex(ODirection.OUT)) || !vertices.contains(edge.getVertex(ODirection.IN))) continue;
                        edgeRids.add(edge.getIdentity());
                        this.printEdge(json, edge);
                    }
                }
            } else {
                for (ORID oRID : edgeRids) {
                    OEdge edge;
                    OElement elem = (OElement)oRID.getRecord();
                    if (elem == null || (edge = (OEdge)elem.asEdge().orElse(null)) == null) continue;
                    this.printEdge(json, edge);
                }
            }
            json.endCollection();
            if (iAdditionalProperties != null) {
                for (Map.Entry entry : iAdditionalProperties.entrySet()) {
                    Object v = entry.getValue();
                    if (OMultiValue.isMultiValue(v)) {
                        json.beginCollection(-1, true, (String)entry.getKey());
                        this.formatMultiValue(OMultiValue.getMultiValueIterator(v), buffer, null);
                        json.endCollection(-1, true);
                    } else {
                        json.writeAttribute((String)entry.getKey(), v);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            json.endObject();
            json.endObject();
            this.send(200, "OK", "application/json", buffer.toString(), null);
        }
    }

    private void printEdge(OJSONWriter json, OEdge edge) throws IOException {
        json.beginObject();
        json.writeAttribute("@rid", (Object)edge.getIdentity());
        json.writeAttribute("@class", edge.getSchemaType().map(x -> x.getName()).orElse(null));
        json.writeAttribute("out", (Object)edge.getVertex(ODirection.OUT).getIdentity());
        json.writeAttribute("in", (Object)edge.getVertex(ODirection.IN).getIdentity());
        for (String field : edge.getPropertyNames()) {
            Object v;
            if (field.equals("out") || field.equals("in") || (v = edge.getProperty(field)) == null) continue;
            json.writeAttribute(field, v);
        }
        json.endObject();
    }

    @Override
    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        this.iWrapped.send(iCode, iReason, iContentType, iContent, iHeaders);
    }

    @Override
    public void writeStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.getHttpVersion() + " " + iStatus + " " + iReason);
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.sendStream(iCode, iReason, iContentType, iContent, iSize, null, null);
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize, String iFileName) throws IOException {
        this.sendStream(iCode, iReason, iContentType, iContent, iSize, iFileName, null);
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize, String iFileName, Map<String, String> additionalHeaders) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                this.writeLine(String.format("%s: %s", entry.getKey(), entry.getValue()));
            }
        }
        if (iSize < 0L) {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            if (iContent != null) {
                int b;
                while ((b = iContent.read()) > -1) {
                    o.write(b);
                }
            }
            byte[] content = o.toByteArray();
            iContent = new ByteArrayInputStream(content);
            iSize = content.length;
        }
        this.writeLine("Content-Length: " + iSize);
        this.writeLine(null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                this.getOut().write(b);
            }
        }
        this.flush();
    }

    @Override
    public void sendStream(int iCode, String iReason, String iContentType, String iFileName, OCallable<Void, OChunkedResponse> iWriter) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        this.writeLine("Transfer-Encoding: chunked");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        this.writeLine(null);
        OChunkedResponse chunkedOutput = new OChunkedResponse(this);
        iWriter.call((Object)chunkedOutput);
        chunkedOutput.close();
        this.flush();
    }

    @Override
    public void checkConnection() throws IOException {
        this.iWrapped.checkConnection();
    }
}

