/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.orient.server.security.SwitchToDefaultParamsException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class OSelfSignedCertificate {
    public static final String DEFAULT_CERTIFICATE_ALGORITHM = "RSA";
    public static final int DEFAULT_CERTIFICATE_KEY_SIZE = 2048;
    public static final int DEFAULT_CERTIFICATE_VALIDITY = 365;
    public static final String DEFAULT_CERTIFICATE_OWNER = "CN=SelfSigenedOrientDBtestOnly, OU=SAP HANA Core, O=SAP SE, L=Walldorf, C=DE";
    public static final String DEFAULT_CERTIFICATE_NAME = "ssl";
    private String algorithm;
    private int key_size;
    private int validity;
    private KeyPair keyPair = null;
    private X509Certificate certificate = null;
    private String certificateName;
    private BigInteger certificateSN = OSelfSignedCertificate.computeRandomSerialNumber();
    private String ownerFDN;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm == null || algorithm.isEmpty() ? DEFAULT_CERTIFICATE_ALGORITHM : algorithm;
    }

    public int getKey_size() {
        return this.key_size;
    }

    public void setKey_size(int key_size) {
        this.key_size = key_size >= 128 ? key_size : 2048;
    }

    public void setValidity(int validity) {
        this.validity = validity;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public void setCertificateSN(long certificateSN) throws SwitchToDefaultParamsException {
        if (certificateSN <= 11L) {
            BigInteger sn;
            this.certificateSN = sn = OSelfSignedCertificate.computeRandomSerialNumber();
            throw new SwitchToDefaultParamsException("the value " + certificateSN + " culd not be used as a Certificate Serial Nuber, the value will be set to:" + sn);
        }
        this.certificateSN = BigInteger.valueOf(certificateSN);
    }

    public static BigInteger computeRandomSerialNumber() {
        SecureRandom sr = new SecureRandom();
        return BigInteger.valueOf(sr.nextLong());
    }

    public void setOwnerFDN(String ownerFDN) {
        this.ownerFDN = ownerFDN;
    }

    public static KeyPair computeKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public void generateCertificateKeyPair() throws NoSuchAlgorithmException, SwitchToDefaultParamsException {
        try {
            this.keyPair = OSelfSignedCertificate.computeKeyPair(this.algorithm, this.key_size);
        }
        catch (NoSuchAlgorithmException e) {
            this.keyPair = OSelfSignedCertificate.computeKeyPair(DEFAULT_CERTIFICATE_ALGORITHM, 2048);
            SwitchToDefaultParamsException tmpe = new SwitchToDefaultParamsException();
            tmpe.addSuppressed(e);
            throw tmpe;
        }
    }

    public PublicKey getPublicKey() {
        if (this.keyPair == null) {
            throw new NullPointerException("generate the Key Pair");
        }
        return this.keyPair.getPublic();
    }

    public void composeSelfSignedCertificate() {
        try {
            this.certificate = OSelfSignedCertificate.generateSelfSignedCertificate(this.keyPair, this.validity, this.ownerFDN, this.certificateSN);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate generateSelfSignedCertificate(KeyPair keypair, int validity, String ownerFDN, BigInteger certSN) throws CertificateException, IOException, NoSuchAlgorithmException {
        X500Name owner = new X500Name(ownerFDN);
        Calendar c = Calendar.getInstance();
        c.add(6, 0);
        Date from = c.getTime();
        c.add(6, validity);
        Date to = c.getTime();
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(owner, certSN, from, to, owner, SubjectPublicKeyInfo.getInstance((Object)keypair.getPublic().getEncoded()));
        try {
            X509CertificateHolder certHolder = certBuilder.build(new JcaContentSignerBuilder("SHA256WithRSA").build(keypair.getPrivate()));
            return new JcaX509CertificateConverter().getCertificate(certHolder);
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public X509Certificate getCertificate() throws CertificateException {
        if (this.certificate == null) {
            throw new CertificateException("The Self-Signed Certificate han not been genetated! You have to invoke the composeSelfSignedCertificate() before get it.");
        }
        return this.certificate;
    }

    public static void checkCertificate(X509Certificate cert, PublicKey publicKey, Date date) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        cert.checkValidity(date);
        cert.verify(publicKey);
    }

    public void checkThisCertificate() throws NoSuchAlgorithmException, CertificateException, NoSuchProviderException, InvalidKeyException, SignatureException {
        OSelfSignedCertificate.checkCertificate(this.certificate, this.keyPair.getPublic(), new Date(System.currentTimeMillis()));
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }
}

