/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network;

import com.orientechnologies.orient.server.network.OServerSSLSocketFactory;
import com.orientechnologies.orient.server.security.OSelfSignedCertificate;
import com.orientechnologies.orient.server.security.SwitchToDefaultParamsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class OServerSSLCertificateManager {
    private char[] keyStorePass;
    private File keyStoreFile;
    private KeyStore keyStore;
    private OServerSSLSocketFactory oSSLSocketInfo = null;
    private OSelfSignedCertificate oSelfSignedCertificate = null;
    private KeyStore trustStore;
    private char[] trustStorePass;
    private File trustStoreFile;

    private OServerSSLCertificateManager() {
    }

    public OServerSSLCertificateManager(OServerSSLSocketFactory oServerSSLSocketFactory, KeyStore keyStore, File keyStoreFile, char[] keyStorePass) {
        this.oSSLSocketInfo = oServerSSLSocketFactory;
        this.keyStore = keyStore;
        this.keyStoreFile = keyStoreFile;
        this.keyStorePass = keyStorePass;
    }

    public static OServerSSLCertificateManager getInstance() {
        return new OServerSSLCertificateManager();
    }

    public static OServerSSLCertificateManager getInstance(OServerSSLSocketFactory oServerSSLSocketFactory, KeyStore keyStore, File keyStoreFile, char[] keyStorePass) {
        return new OServerSSLCertificateManager(oServerSSLSocketFactory, keyStore, keyStoreFile, keyStorePass);
    }

    public void loadKeyStoreForSSLSocket() throws Exception {
        try {
            if (!this.keyStoreFile.exists()) {
                OServerSSLCertificateManager.initKeyStore(this.keyStoreFile, this.keyStore, this.keyStorePass);
            } else {
                OServerSSLCertificateManager.loadKeyStore(this.keyStoreFile, this.keyStore, this.keyStorePass);
            }
            this.checkKeyStoreContentValidity();
        }
        catch (IOException e) {
            throw e;
        }
        catch (CertificateException e) {
            this.reactToCerificateLack();
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
    }

    public void loadTrustStoreForSSLSocket(KeyStore trustStore, File trustStoreFile, char[] trustStorePass) throws Exception {
        this.trustStore = trustStore;
        this.trustStoreFile = trustStoreFile;
        this.trustStorePass = trustStorePass;
        try {
            if (!trustStoreFile.exists()) {
                OServerSSLCertificateManager.initKeyStore(trustStoreFile, trustStore, trustStorePass);
            } else {
                OServerSSLCertificateManager.loadKeyStore(trustStoreFile, trustStore, trustStorePass);
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (this.oSelfSignedCertificate != null) {
                OServerSSLCertificateManager.trustCertificate(this.trustStoreFile, this.trustStore, this.trustStorePass, this.oSelfSignedCertificate.getCertificateName(), this.oSelfSignedCertificate.getCertificate());
            }
        }
    }

    public void checkKeyStoreContentValidity() throws CertificateException, KeyStoreException {
        if (!this.keyStore.aliases().hasMoreElements()) {
            throw new CertificateException("the KeyStore is empty");
        }
    }

    public void reactToCerificateLack() throws Exception {
        try {
            if (this.oSelfSignedCertificate == null) {
                this.initOSelfSignedCertificateParameters();
            }
            OServerSSLCertificateManager.autoGenerateSelfSignedX509Cerificate(this.oSelfSignedCertificate);
            OServerSSLCertificateManager.storeCertificate(this.oSelfSignedCertificate.getCertificate(), this.oSelfSignedCertificate.getPrivateKey(), this.oSelfSignedCertificate.getCertificateName(), this.keyStorePass, this.keyStoreFile, this.keyStore, this.keyStorePass);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void initOSelfSignedCertificateParameters() {
        this.oSelfSignedCertificate = new OSelfSignedCertificate();
        this.oSelfSignedCertificate.setAlgorithm("RSA");
        this.oSelfSignedCertificate.setCertificateName("ssl");
        try {
            this.oSelfSignedCertificate.setCertificateSN(0L);
        }
        catch (SwitchToDefaultParamsException switchToDefaultParamsException) {
            // empty catch block
        }
        this.oSelfSignedCertificate.setKey_size(2048);
        this.oSelfSignedCertificate.setOwnerFDN("CN=SelfSigenedOrientDBtestOnly, OU=SAP HANA Core, O=SAP SE, L=Walldorf, C=DE");
        this.oSelfSignedCertificate.setValidity(365);
    }

    public static OSelfSignedCertificate autoGenerateSelfSignedX509Cerificate(OSelfSignedCertificate oCert) throws SwitchToDefaultParamsException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, InvalidKeyException, SignatureException {
        oCert.generateCertificateKeyPair();
        oCert.composeSelfSignedCertificate();
        oCert.checkThisCertificate();
        return oCert;
    }

    public static void initKeyStore(File keyStoreFilePointer, KeyStore keyStoreInstance, char[] ks_pwd) throws IOException, CertificateException, NoSuchAlgorithmException {
        try {
            if (!keyStoreFilePointer.exists()) {
                keyStoreInstance.load(null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            throw new CertificateException("the KeyStore is empty");
        }
    }

    public static void loadKeyStore(File keyStoreFilePointer, KeyStore keyStoreInstance, char[] ks_pwd) throws IOException, CertificateException, NoSuchAlgorithmException {
        try (FileInputStream ksFIs = null;){
            ksFIs = new FileInputStream(keyStoreFilePointer);
            keyStoreInstance.load(ksFIs, ks_pwd);
        }
    }

    public static void storeCertificate(X509Certificate cert, PrivateKey key, String certName, char[] certPwd, File keyStore_FilePointer, KeyStore keyStore_instance, char[] ksPwd) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        try (FileOutputStream ksFOs = null;){
            ksFOs = new FileOutputStream(keyStore_FilePointer, true);
            keyStore_instance.setKeyEntry(certName, key, certPwd, new Certificate[]{cert});
            keyStore_instance.store(ksFOs, ksPwd);
        }
    }

    public static void trustCertificate(File keyStoreFilePointer, KeyStore keyStoreInstance, char[] ksPwd, String certName, X509Certificate cert) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        try (FileOutputStream ksFOs = null;){
            ksFOs = new FileOutputStream(keyStoreFilePointer, true);
            keyStoreInstance.setCertificateEntry(certName, cert);
            keyStoreInstance.store(ksFOs, ksPwd);
        }
    }
}

