/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.pastdev.jsch.SessionFactory;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private final SessionFactory sessionFactory;
    private Session session;

    public SessionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void close() throws IOException {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.session = null;
    }

    public Session getSession() throws JSchException {
        if (this.session == null || !this.session.isConnected()) {
            logger.debug("getting new session from factory session");
            this.session = this.sessionFactory.newSession();
            logger.debug("connecting session");
            this.session.connect();
        }
        return this.session;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public String toString() {
        return this.sessionFactory.toString();
    }
}

