/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.proxy;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.pastdev.jsch.SessionFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshProxy
implements Proxy {
    private static Logger logger = LoggerFactory.getLogger(SshProxy.class);
    private Channel channel;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SessionFactory sessionFactory;
    private Session session;

    public SshProxy(SessionFactory sessionFactory) throws JSchException {
        this.sessionFactory = sessionFactory;
        this.session = sessionFactory.newSession();
    }

    public void close() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public void connect(SocketFactory socketFactory, String host, int port, int timeout) throws Exception {
        logger.debug("connecting session");
        this.session.connect();
        this.channel = this.session.getStreamForwarder(host, port);
        this.inputStream = this.channel.getInputStream();
        this.outputStream = this.channel.getOutputStream();
        this.channel.connect(timeout);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Socket getSocket() {
        return null;
    }

    public String toString() {
        return "PROXY(" + this.sessionFactory.toString() + ")";
    }
}

