/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.scp;

import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.scp.CopyMode;
import com.pastdev.jsch.scp.ScpConnection;
import com.pastdev.jsch.scp.ScpEntry;
import com.pastdev.jsch.scp.ScpMode;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpOutputStream
extends OutputStream {
    private static Logger logger = LoggerFactory.getLogger(ScpOutputStream.class);
    private ScpConnection connection;
    private OutputStream outputStream;

    public ScpOutputStream(SessionFactory sessionFactory, String path, CopyMode copyMode) throws JSchException, IOException {
        logger.debug("Opening ScpOutputStream to {} {}", (Object)sessionFactory, (Object)path);
        this.connection = new ScpConnection(sessionFactory, path, ScpMode.TO, copyMode);
    }

    @Override
    public void close() throws IOException {
        logger.debug("Closing ScpOutputStream");
        this.connection.close();
        this.outputStream = null;
    }

    public void closeEntry() throws IOException {
        this.connection.closeEntry();
        this.outputStream = null;
    }

    public void putNextEntry(String name) throws IOException {
        this.connection.putNextEntry(ScpEntry.newDirectory(name));
        this.outputStream = this.connection.getCurrentOuputStream();
    }

    public void putNextEntry(String name, long size) throws IOException {
        this.connection.putNextEntry(ScpEntry.newFile(name, size));
        this.outputStream = this.connection.getCurrentOuputStream();
    }

    public void putNextEntry(ScpEntry entry) throws IOException {
        this.connection.putNextEntry(entry);
        this.outputStream = this.connection.getCurrentOuputStream();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.outputStream == null) {
            throw new IllegalStateException("no current entry, cannot write");
        }
        this.outputStream.write(b);
    }
}

