// Generated by delombok at Wed Apr 12 16:40:57 PDT 2017
package com.pubnub.api.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.server.PresenceEnvelope;
import com.pubnub.api.models.server.PublishMetaData;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class SubscribeMessageWorker implements Runnable {
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SubscribeMessageWorker.class);
    private PubNub pubnub;
    private ListenerManager listenerManager;
    private LinkedBlockingQueue<SubscribeMessage> queue;
    private boolean isRunning;

    public SubscribeMessageWorker(PubNub pubnubInstance, ListenerManager listenerManagerInstance, LinkedBlockingQueue<SubscribeMessage> queueInstance) {
        this.pubnub = pubnubInstance;
        this.listenerManager = listenerManagerInstance;
        this.queue = queueInstance;
    }

    @Override
    public void run() {
        takeMessage();
    }

    private void takeMessage() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                this.processIncomingPayload(this.queue.take());
            } catch (InterruptedException e) {
                this.isRunning = false;
                log.warn("take message interrupted", e);
            }
        }
    }

    private JsonElement processMessage(JsonElement input) {
        // if we do not have a crypto key, there is no way to process the node; let's return.
        if (pubnub.getConfiguration().getCipherKey() == null) {
            return input;
        }
        Crypto crypto = new Crypto(pubnub.getConfiguration().getCipherKey());
        MapperManager mapper = this.pubnub.getMapper();
        String inputText;
        String outputText;
        JsonElement outputObject;
        if (mapper.isJsonObject(input) && mapper.hasField(input, "pn_other")) {
            inputText = mapper.elementToString(input, "pn_other");
        } else {
            inputText = mapper.elementToString(input);
        }
        try {
            outputText = crypto.decrypt(inputText);
        } catch (PubNubException e) {
            PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNDecryptionErrorCategory).build();
            listenerManager.announce(pnStatus);
            return null;
        }
        try {
            outputObject = mapper.fromJson(outputText, JsonElement.class);
        } catch (PubNubException e) {
            PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNMalformedResponseCategory).build();
            listenerManager.announce(pnStatus);
            return null;
        }
        // inject the decoded response into the payload
        if (mapper.isJsonObject(input) && mapper.hasField(input, "pn_other")) {
            JsonObject objectNode = mapper.getAsObject(input);
            mapper.putOnObject(objectNode, "pn_other", outputObject);
            outputObject = objectNode;
        }
        return outputObject;
    }

    private void processIncomingPayload(SubscribeMessage message) {
        MapperManager mapper = this.pubnub.getMapper();
        String channel = message.getChannel();
        String subscriptionMatch = message.getSubscriptionMatch();
        PublishMetaData publishMetaData = message.getPublishMetaData();
        if (channel != null && channel.equals(subscriptionMatch)) {
            subscriptionMatch = null;
        }
        if (message.getChannel().endsWith("-pnpres")) {
            PresenceEnvelope presencePayload = mapper.convertValue(message.getPayload(), PresenceEnvelope.class);
            String strippedPresenceChannel = null;
            String strippedPresenceSubscription = null;
            if (channel != null) {
                strippedPresenceChannel = PubNubUtil.replaceLast(channel, "-pnpres", "");
            }
            if (subscriptionMatch != null) {
                strippedPresenceSubscription = PubNubUtil.replaceLast(subscriptionMatch, "-pnpres", "");
            }
            PNPresenceEventResult pnPresenceEventResult = 
            // deprecated
            // deprecated
            PNPresenceEventResult.builder().event(presencePayload.getAction()).actualChannel((subscriptionMatch != null) ? channel : null).subscribedChannel(subscriptionMatch != null ? subscriptionMatch : channel).channel(strippedPresenceChannel).subscription(strippedPresenceSubscription).state(presencePayload.getData()).timetoken(publishMetaData.getPublishTimetoken()).occupancy(presencePayload.getOccupancy()).uuid(presencePayload.getUuid()).timestamp(presencePayload.getTimestamp()).join(getDelta(message.getPayload().getAsJsonObject().get("join"))).leave(getDelta(message.getPayload().getAsJsonObject().get("leave"))).timeout(getDelta(message.getPayload().getAsJsonObject().get("timeout"))).build();
            listenerManager.announce(pnPresenceEventResult);
        } else {
            JsonElement extractedMessage = processMessage(message.getPayload());
            if (extractedMessage == null) {
                log.debug("unable to parse payload on #processIncomingMessages");
            }
            PNMessageResult pnMessageResult = 
            // deprecated
            // deprecated
            PNMessageResult.builder().message(extractedMessage).actualChannel((subscriptionMatch != null) ? channel : null).subscribedChannel(subscriptionMatch != null ? subscriptionMatch : channel).channel(channel).subscription(subscriptionMatch).timetoken(publishMetaData.getPublishTimetoken()).publisher(message.getIssuingClientId()).userMetadata(message.getUserMetadata()).build();
            listenerManager.announce(pnMessageResult);
        }
    }

    private List<String> getDelta(JsonElement delta) {
        List<String> list = new ArrayList<>();
        if (delta != null) {
            JsonArray jsonArray = delta.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); i++) {
                list.add(jsonArray.get(i).getAsString());
            }
        }
        return list;
    }
}
