/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNubException;
import com.pubnub.api.vendor.Base64;
import com.pubnub.api.vendor.Crypto;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0012\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J!\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u001e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b J\u001e\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001d\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b'J\u0012\u0010(\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/pubnub/api/PubNubUtil;", "", "()V", "CHARSET", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generateSignature", "configuration", "Lcom/pubnub/api/PNConfiguration;", "request", "Lokhttp3/Request;", "timestamp", "", "pamEncode", "stringToEncode", "alreadyPercentEncoded", "", "pamEncode$pubnub_kotlin", "preparePamArguments", "encodedQueryString", "pamArgs", "", "preparePamArguments$pubnub_kotlin", "removeTrailingEqualSigns", "signature", "replaceLast", "string", "toReplace", "replacement", "requestBodyToString", "requestBodyToString$pubnub_kotlin", "signRequest", "originalRequest", "pnConfiguration", "signSHA256", "key", "data", "signSHA256$pubnub_kotlin", "urlDecode", "pubnub-kotlin"})
public final class PubNubUtil {
    private static final Logger log;
    private static final String CHARSET = "UTF-8";
    public static final PubNubUtil INSTANCE;

    @NotNull
    public final String replaceLast(@NotNull String string, @NotNull String toReplace, @NotNull String replacement) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull((Object)toReplace, (String)"toReplace");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        int pos = StringsKt.lastIndexOf$default((CharSequence)string, (String)toReplace, (int)0, (boolean)false, (int)6, null);
        if (pos > -1) {
            String string3 = string;
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            String string4 = string3.substring(n, pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            string3 = string;
            n = pos + toReplace.length();
            n2 = string.length();
            stringBuilder = stringBuilder.append(string5).append(replacement);
            boolean bl = false;
            String string6 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = string6;
            string2 = stringBuilder.append(string5).toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    @Nullable
    public final String urlDecode(@Nullable String stringToEncode) {
        String string;
        try {
            string = URLDecoder.decode(stringToEncode, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Request signRequest(@NotNull Request originalRequest, @NotNull PNConfiguration pnConfiguration, int timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkParameterIsNotNull((Object)pnConfiguration, (String)"pnConfiguration");
        if (!pnConfiguration.isSecretKeyValid$pubnub_kotlin()) {
            return originalRequest;
        }
        String signature = this.generateSignature(pnConfiguration, originalRequest, timestamp);
        HttpUrl rebuiltUrl = originalRequest.url().newBuilder().addQueryParameter("timestamp", String.valueOf(timestamp)).addQueryParameter("signature", signature).build();
        Request request = originalRequest.newBuilder().url(rebuiltUrl).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"originalRequest.newBuild\u2026).url(rebuiltUrl).build()");
        return request;
    }

    @NotNull
    public final String signSHA256$pubnub_kotlin(@NotNull String key, @NotNull String data) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object sha256HMAC = null;
        byte[] hmacData = null;
        Object object3 = key;
        Object object4 = CHARSET;
        boolean bl = false;
        Charset charset = Charset.forName((String)object4);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object4 = object2 = charset;
        bl = false;
        byte[] byArray = ((String)object3).getBytes((Charset)object4);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object2 = byArray;
        String string = "HmacSHA256";
        Object object5 = object2;
        SecretKeySpec secretKey = new SecretKeySpec((byte[])object5, string);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            Intrinsics.checkExpressionValueIsNotNull((Object)mac, (String)"Mac.getInstance(\"HmacSHA256\")");
            object3 = mac;
        }
        catch (NoSuchAlgorithmException e) {
            PubNubException pubNubException = Crypto.newCryptoError(0, e);
            Intrinsics.checkExpressionValueIsNotNull((Object)pubNubException, (String)"Crypto.newCryptoError(0, e)");
            throw (Throwable)pubNubException;
        }
        sha256HMAC = object3;
        try {
            ((Mac)sha256HMAC).init(secretKey);
        }
        catch (InvalidKeyException e) {
            PubNubException pubNubException = Crypto.newCryptoError(0, e);
            Intrinsics.checkExpressionValueIsNotNull((Object)pubNubException, (String)"Crypto.newCryptoError(0, e)");
            throw (Throwable)pubNubException;
        }
        String e = data;
        object4 = CHARSET;
        Object object6 = sha256HMAC;
        bl = false;
        Charset charset2 = Charset.forName((String)object4);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(charsetName)");
        object4 = object = charset2;
        bl = false;
        byte[] byArray2 = e.getBytes((Charset)object4);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray2;
        byte[] byArray3 = ((Mac)object6).doFinal((byte[])object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"sha256HMAC.doFinal(data.\u2026eArray(charset(CHARSET)))");
        hmacData = byArray3;
        byte[] byArray4 = Base64.encode(hmacData, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"Base64.encode(hmacData, 0)");
        object4 = byArray4;
        Charset charset3 = Charset.forName(CHARSET);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"Charset.forName(CHARSET)");
        Charset charset4 = charset3;
        boolean bl2 = false;
        String signed = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)new String((byte[])object4, charset4), (char)'+', (char)'-', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
        return signed;
    }

    private final String generateSignature(PNConfiguration configuration, Request request, int timestamp) {
        boolean isV2Signature = false;
        StringBuilder signatureBuilder = new StringBuilder();
        String requestURL = request.url().encodedPath();
        boolean bl = false;
        Map queryParams = new LinkedHashMap();
        Iterator iterator = request.url().queryParameterNames().iterator();
        while (iterator.hasNext()) {
            String queryKey;
            String string = queryKey = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"queryKey");
            String string2 = request.url().queryParameter(queryKey);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.url().queryParameter(queryKey)!!");
            queryParams.put(string, string2);
        }
        queryParams.put("timestamp", String.valueOf(timestamp));
        boolean classic = true;
        String encodedQueryString = this.preparePamArguments$pubnub_kotlin(queryParams);
        String string = requestURL;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestURL");
        boolean bl2 = isV2Signature = !StringsKt.startsWith$default((String)string, (String)"/publish", (boolean)false, (int)2, null) || !StringsKt.equals((String)request.method(), (String)"post", (boolean)true);
        if (!isV2Signature) {
            signatureBuilder.append(configuration.getSubscribeKey()).append("\n");
            signatureBuilder.append(configuration.getPublishKey()).append("\n");
            signatureBuilder.append(requestURL).append("\n");
            signatureBuilder.append(encodedQueryString);
        } else {
            String string3 = request.method();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"request.method()");
            String string4 = string3;
            StringBuilder stringBuilder = signatureBuilder;
            boolean bl3 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
            String string7 = string6;
            stringBuilder.append(string7).append("\n");
            signatureBuilder.append(configuration.getPublishKey()).append("\n");
            signatureBuilder.append(requestURL).append("\n");
            signatureBuilder.append(encodedQueryString).append("\n");
            signatureBuilder.append(this.requestBodyToString$pubnub_kotlin(request));
        }
        String signature = "";
        try {
            String string8 = configuration.getSecretKey();
            String string9 = signatureBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"signatureBuilder.toString()");
            signature = this.signSHA256$pubnub_kotlin(string8, string9);
            if (isV2Signature) {
                signature = this.removeTrailingEqualSigns(signature);
                signature = "v2." + signature;
            }
        }
        catch (PubNubException e) {
            log.warn("signature failed on SignatureInterceptor: " + e);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("signature failed on SignatureInterceptor: " + e);
        }
        return signature;
    }

    @NotNull
    public final String removeTrailingEqualSigns(@NotNull String signature) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        String cleanSignature = signature;
        while (cleanSignature.charAt(cleanSignature.length() - 1) == '=') {
            String string = cleanSignature;
            int n = 0;
            int n2 = cleanSignature.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return cleanSignature;
    }

    @Nullable
    public final String requestBodyToString$pubnub_kotlin(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (request.body() == null) {
            return "";
        }
        try {
            Buffer buffer = new Buffer();
            RequestBody requestBody = request.body();
            if (requestBody == null) {
                Intrinsics.throwNpe();
            }
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @NotNull
    public final String preparePamArguments$pubnub_kotlin(@NotNull Map<String, String> pamArgs) {
        Intrinsics.checkParameterIsNotNull(pamArgs, (String)"pamArgs");
        Set pamKeys = new TreeSet(pamArgs.keySet());
        String stringifiedArguments = "";
        int i = 0;
        for (String pamKey : pamKeys) {
            String string;
            if (i != 0) {
                stringifiedArguments = stringifiedArguments + '&';
            }
            Map<String, String> map = pamArgs;
            PubNubUtil pubNubUtil = this;
            StringBuilder stringBuilder = new StringBuilder().append(stringifiedArguments).append(pamKey).append("=");
            boolean bl = false;
            String string2 = string = map.get(pamKey);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            stringifiedArguments = stringBuilder.append(PubNubUtil.pamEncode$pubnub_kotlin$default(pubNubUtil, string2, false, 2, null)).toString();
            ++i;
        }
        return stringifiedArguments;
    }

    /*
     * WARNING - void declaration
     */
    private final String preparePamArguments(String encodedQueryString) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.toSortedSet((Iterable)StringsKt.split$default((CharSequence)encodedQueryString, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            String string2 = INSTANCE.pamEncode$pubnub_kotlin((String)v0, true);
            collection.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String pamEncode$pubnub_kotlin(@NotNull String stringToEncode, boolean alreadyPercentEncoded) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)stringToEncode, (String)"stringToEncode");
        if (alreadyPercentEncoded) {
            string = stringToEncode;
        } else {
            String string2 = URLEncoder.encode(stringToEncode, CHARSET);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLEncoder.encode(stringToEncode, \"UTF-8\")");
            string = StringsKt.replace$default((String)string2, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        }
        String string3 = string;
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string3;
        boolean bl3 = false;
        return StringsKt.replace$default((String)$this$run, (String)"*", (String)"%2A", (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String pamEncode$pubnub_kotlin$default(PubNubUtil pubNubUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return pubNubUtil.pamEncode$pubnub_kotlin(string, bl);
    }

    private PubNubUtil() {
    }

    static {
        PubNubUtil pubNubUtil;
        INSTANCE = pubNubUtil = new PubNubUtil();
        log = LoggerFactory.getLogger((String)"PubNubUtil");
    }
}

