/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.history.PNFetchMessageItem;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.api.models.server.FetchMessagesEnvelope;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00012BM\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0$H\u0002J\u0016\u0010%\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0014J\"\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*H\u0014J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002J\b\u00101\u001a\u00020\"H\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b \u0010\u0015\u00a8\u00063"}, d2={"Lcom/pubnub/api/endpoints/FetchMessages;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/FetchMessagesEnvelope;", "Lcom/pubnub/api/models/consumer/history/PNFetchMessagesResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "maximumPerChannel", "", "start", "", "end", "includeMeta", "", "includeMessageActions", "(Lcom/pubnub/api/PubNub;Ljava/util/List;ILjava/lang/Long;Ljava/lang/Long;ZZ)V", "getChannels", "()Ljava/util/List;", "getEnd", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIncludeMessageActions", "()Z", "getIncludeMeta", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMaximumPerChannel", "()I", "maximumPerChannelParam", "getStart", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNFetchMessagesOperation;", "processMessage", "Lcom/google/gson/JsonElement;", "message", "validateParams", "Companion", "pubnub-kotlin"})
public final class FetchMessages
extends Endpoint<FetchMessagesEnvelope, PNFetchMessagesResult> {
    private final Logger log;
    private int maximumPerChannelParam;
    @NotNull
    private final List<String> channels;
    private final int maximumPerChannel;
    @Nullable
    private final Long start;
    @Nullable
    private final Long end;
    private final boolean includeMeta;
    private final boolean includeMessageActions;
    private static final int DEFAULT_MESSAGES = 1;
    private static final int MAX_MESSAGES = 25;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @Override
    protected void validateParams() {
        block7: {
            block6: {
                super.validateParams();
                if (this.channels.isEmpty()) {
                    throw (Throwable)new PubNubException(PubNubError.CHANNEL_MISSING);
                }
                if (this.includeMessageActions) break block6;
                int n = this.maximumPerChannel;
                if (1 <= n) {
                    if (25 >= n) break block7;
                }
                if (this.maximumPerChannel < 1) {
                    this.maximumPerChannelParam = 1;
                } else if (this.maximumPerChannel > 25) {
                    this.maximumPerChannelParam = 25;
                }
                this.log.info("maximumPerChannel param defaulting to " + this.maximumPerChannelParam);
                break block7;
            }
            int n = this.maximumPerChannel;
            if (1 > n || 25 < n) {
                this.maximumPerChannelParam = 25;
                this.log.info("maximumPerChannel param defaulting to " + this.maximumPerChannelParam);
            }
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected Call<FetchMessagesEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        Call<FetchMessagesEnvelope> call;
        Intrinsics.checkParameterIsNotNull(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        if (!this.includeMessageActions) {
            call = this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchMessages(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams);
        } else {
            if (this.channels.size() > 1) {
                throw (Throwable)new PubNubException(PubNubError.HISTORY_MESSAGE_ACTIONS_MULTIPLE_CHANNELS);
            }
            call = this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchMessagesWithActions(this.getPubnub().getConfiguration().getSubscribeKey(), (String)CollectionsKt.first(this.channels), (Map<String, String>)queryParams);
        }
        return call;
    }

    @Override
    @NotNull
    protected PNFetchMessagesResult createResponse(@NotNull Response<FetchMessagesEnvelope> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        boolean bl = false;
        HashMap<String, List<PNFetchMessageItem>> channelsMap = new HashMap<String, List<PNFetchMessageItem>>();
        Object object = input.body();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Map map = ((FetchMessagesEnvelope)object).getChannels();
        boolean bl2 = false;
        for (Map.Entry entry : map.entrySet()) {
            bl2 = false;
            List items = new ArrayList();
            for (PNFetchMessageItem item : (List)entry.getValue()) {
                Object object2 = item.getMeta();
                long l = item.getTimetoken();
                object2 = new PNFetchMessageItem(this.processMessage(item.getMessage()), (JsonElement)object2, l);
                List list = items;
                boolean bl3 = false;
                boolean bl4 = false;
                Object $this$apply = object2;
                boolean bl5 = false;
                if (this.includeMessageActions) {
                    Object object3 = $this$apply;
                    Map map2 = item.getActions();
                    if (map2 == null) {
                        Object object4 = object3;
                        boolean bl6 = false;
                        Map map3 = MapsKt.emptyMap();
                        object3 = object4;
                        map2 = map3;
                    }
                    ((PNFetchMessageItem)object3).setActions$pubnub_kotlin(map2);
                }
                Object object5 = object2;
                list.add(object5);
            }
            ((Map)channelsMap).put(entry.getKey(), items);
        }
        return new PNFetchMessagesResult(channelsMap);
    }

    @Override
    @NotNull
    protected PNOperationType.PNFetchMessagesOperation operationType() {
        return PNOperationType.PNFetchMessagesOperation.INSTANCE;
    }

    private final JsonElement processMessage(JsonElement message) {
        JsonElement outputObject;
        block2: {
            String inputText;
            if (!this.getPubnub().getConfiguration().isCipherKeyValid$pubnub_kotlin()) {
                return message;
            }
            Crypto crypto = new Crypto(this.getPubnub().getConfiguration().getCipherKey());
            String string = inputText = this.getPubnub().getMapper().isJsonObject(message) && this.getPubnub().getMapper().hasField(message, "pn_other") ? this.getPubnub().getMapper().elementToString(message, "pn_other") : this.getPubnub().getMapper().elementToString(message);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String outputText = crypto.decrypt(string);
            outputObject = this.getPubnub().getMapper().fromJson(outputText, JsonElement.class);
            JsonElement jsonElement = this.getPubnub().getMapper().getField(message, "pn_other");
            if (jsonElement == null) break block2;
            JsonElement jsonElement2 = jsonElement;
            boolean bl = false;
            boolean bl2 = false;
            JsonElement it = jsonElement2;
            boolean bl3 = false;
            JsonObject objectNode = this.getPubnub().getMapper().getAsObject(message);
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonObject jsonObject = objectNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"objectNode");
            mapperManager.putOnObject(jsonObject, "pn_other", outputObject);
            outputObject = (JsonElement)objectNode;
        }
        return outputObject;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        String string;
        boolean bl;
        Map<String, String> map;
        String string2;
        Locale locale;
        String string3;
        long $this$run;
        boolean bl2;
        boolean bl3;
        Long l;
        queryParams.put("max", String.valueOf(this.maximumPerChannelParam));
        Long l2 = this.start;
        if (l2 != null) {
            l = l2;
            bl3 = false;
            bl2 = false;
            $this$run = ((Number)l).longValue();
            boolean bl4 = false;
            string3 = String.valueOf($this$run);
            Locale locale2 = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.US");
            locale = locale2;
            string2 = "start";
            map = queryParams;
            bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = string5;
            map.put(string2, string);
        }
        Long l3 = this.end;
        if (l3 != null) {
            l = l3;
            bl3 = false;
            bl2 = false;
            $this$run = ((Number)l).longValue();
            boolean bl5 = false;
            string3 = String.valueOf($this$run);
            Locale locale3 = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.US");
            locale = locale3;
            string2 = "end";
            map = queryParams;
            bl = false;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = string7;
            map.put(string2, string);
        }
        if (this.includeMeta) {
            queryParams.put("include_meta", String.valueOf(this.includeMeta));
        }
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    public final int getMaximumPerChannel() {
        return this.maximumPerChannel;
    }

    @Nullable
    public final Long getStart() {
        return this.start;
    }

    @Nullable
    public final Long getEnd() {
        return this.end;
    }

    public final boolean getIncludeMeta() {
        return this.includeMeta;
    }

    public final boolean getIncludeMessageActions() {
        return this.includeMessageActions;
    }

    public FetchMessages(@NotNull PubNub pubnub, @NotNull List<String> channels, int maximumPerChannel, @Nullable Long start, @Nullable Long end, boolean includeMeta, boolean includeMessageActions) {
        Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
        Intrinsics.checkParameterIsNotNull(channels, (String)"channels");
        super(pubnub);
        this.channels = channels;
        this.maximumPerChannel = maximumPerChannel;
        this.start = start;
        this.end = end;
        this.includeMeta = includeMeta;
        this.includeMessageActions = includeMessageActions;
        this.log = LoggerFactory.getLogger((String)"FetchMessages");
        this.maximumPerChannelParam = this.maximumPerChannel;
    }

    public /* synthetic */ FetchMessages(PubNub pubNub, List list, int n, Long l, Long l2, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            l = null;
        }
        if ((n2 & 0x10) != 0) {
            l2 = null;
        }
        this(pubNub, list, n, l, l2, bl, bl2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pubnub/api/endpoints/FetchMessages$Companion;", "", "()V", "DEFAULT_MESSAGES", "", "MAX_MESSAGES", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

