/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.history.PNHistoryItemResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 02\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00010BO\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\"H\u0002J\u0016\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0014J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070(H\u0014J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*H\u0014J\b\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0002H\u0002J\b\u0010/\u001a\u00020 H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001e\u0010\u0018\u00a8\u00061"}, d2={"Lcom/pubnub/api/endpoints/History;", "Lcom/pubnub/api/Endpoint;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNHistoryResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channel", "", "start", "", "end", "count", "", "reverse", "", "includeTimetoken", "includeMeta", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;IZZZ)V", "getChannel", "()Ljava/lang/String;", "getCount", "()I", "countParam", "getEnd", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIncludeMeta", "()Z", "getIncludeTimetoken", "getReverse", "getStart", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannels", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHistoryOperation;", "processMessage", "message", "validateParams", "Companion", "pubnub-kotlin"})
public final class History
extends Endpoint<JsonElement, PNHistoryResult> {
    private final int countParam;
    @NotNull
    private final String channel;
    @Nullable
    private final Long start;
    @Nullable
    private final Long end;
    private final int count;
    private final boolean reverse;
    private final boolean includeTimetoken;
    private final boolean includeMeta;
    public static final int MAX_COUNT = 100;
    public static final Companion Companion = new Companion(null);

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channel)) {
            throw (Throwable)new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkParameterIsNotNull(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchHistory(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHistoryResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        MapperManager mapperManager = this.getPubnub().getMapper();
        MapperManager mapperManager2 = this.getPubnub().getMapper();
        Object object = input.body();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"input.body()!!");
        JsonElement jsonElement = mapperManager2.getArrayElement((JsonElement)object, 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"pubnub.mapper.getArrayElement(input.body()!!, 1)");
        long startTimeToken = mapperManager.elementToLong(jsonElement);
        MapperManager mapperManager3 = this.getPubnub().getMapper();
        MapperManager mapperManager4 = this.getPubnub().getMapper();
        Object object2 = input.body();
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"input.body()!!");
        JsonElement jsonElement2 = mapperManager4.getArrayElement((JsonElement)object2, 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"pubnub.mapper.getArrayElement(input.body()!!, 2)");
        long endTimeToken = mapperManager3.elementToLong(jsonElement2);
        boolean bl = false;
        List messages = new ArrayList();
        PNHistoryResult historyData = new PNHistoryResult(messages, startTimeToken, endTimeToken);
        MapperManager mapperManager5 = this.getPubnub().getMapper();
        Object object3 = input.body();
        if (object3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"input.body()!!");
        JsonElement jsonElement3 = mapperManager5.getArrayElement((JsonElement)object3, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"pubnub.mapper.getArrayElement(input.body()!!, 0)");
        if (jsonElement3.isJsonArray()) {
            MapperManager mapperManager6 = this.getPubnub().getMapper();
            MapperManager mapperManager7 = this.getPubnub().getMapper();
            Object object4 = input.body();
            if (object4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"input.body()!!");
            Iterator<JsonElement> iterator = mapperManager6.getArrayIterator(mapperManager7.getArrayElement((JsonElement)object4, 0));
            if (iterator == null) {
                Intrinsics.throwNpe();
            }
            Iterator<JsonElement> iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement historyEntry = iterator2.next();
                JsonElement message = null;
                Long timetoken = null;
                JsonElement meta = null;
                if (this.includeTimetoken || this.includeMeta) {
                    JsonElement jsonElement4 = this.getPubnub().getMapper().getField(historyEntry, "message");
                    if (jsonElement4 == null) {
                        Intrinsics.throwNpe();
                    }
                    message = this.processMessage(jsonElement4);
                    if (this.includeTimetoken) {
                        MapperManager mapperManager8 = this.getPubnub().getMapper();
                        JsonElement jsonElement5 = historyEntry;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"historyEntry");
                        timetoken = mapperManager8.elementToLong(jsonElement5, "timetoken");
                    }
                    if (this.includeMeta) {
                        meta = this.getPubnub().getMapper().getField(historyEntry, "meta");
                    }
                } else {
                    JsonElement jsonElement6 = historyEntry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"historyEntry");
                    message = this.processMessage(jsonElement6);
                }
                PNHistoryItemResult historyItem = new PNHistoryItemResult(message, timetoken, meta);
                messages.add(historyItem);
            }
        } else {
            Call call = null;
            int n = 0;
            String string = null;
            String string2 = "History is disabled";
            PubNubError pubNubError = PubNubError.HTTP_ERROR;
            throw (Throwable)new PubNubException(string2, pubNubError, string, n, call, 28, null);
        }
        return historyData;
    }

    @Override
    @NotNull
    protected PNOperationType.PNHistoryOperation operationType() {
        return PNOperationType.PNHistoryOperation.INSTANCE;
    }

    private final JsonElement processMessage(JsonElement message) {
        JsonElement outputObject;
        block2: {
            String inputText;
            if (!this.getPubnub().getConfiguration().isCipherKeyValid$pubnub_kotlin()) {
                return message;
            }
            Crypto crypto = new Crypto(this.getPubnub().getConfiguration().getCipherKey());
            String string = inputText = this.getPubnub().getMapper().isJsonObject(message) && this.getPubnub().getMapper().hasField(message, "pn_other") ? this.getPubnub().getMapper().elementToString(message, "pn_other") : this.getPubnub().getMapper().elementToString(message);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String outputText = crypto.decrypt(string);
            outputObject = this.getPubnub().getMapper().fromJson(outputText, JsonElement.class);
            JsonElement jsonElement = this.getPubnub().getMapper().getField(message, "pn_other");
            if (jsonElement == null) break block2;
            JsonElement jsonElement2 = jsonElement;
            boolean bl = false;
            boolean bl2 = false;
            JsonElement it = jsonElement2;
            boolean bl3 = false;
            JsonObject objectNode = this.getPubnub().getMapper().getAsObject(message);
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonObject jsonObject = objectNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"objectNode");
            mapperManager.putOnObject(jsonObject, "pn_other", outputObject);
            outputObject = (JsonElement)objectNode;
        }
        return outputObject;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block3: {
            String string;
            boolean bl;
            Map<String, String> map;
            String string2;
            Locale locale;
            String string3;
            long $this$run;
            boolean bl2;
            boolean bl3;
            Long l;
            queryParams.put("reverse", String.valueOf(this.reverse));
            queryParams.put("include_token", String.valueOf(this.includeTimetoken));
            queryParams.put("include_meta", String.valueOf(this.includeMeta));
            queryParams.put("count", String.valueOf(this.countParam));
            Long l2 = this.start;
            if (l2 != null) {
                l = l2;
                bl3 = false;
                bl2 = false;
                $this$run = ((Number)l).longValue();
                boolean bl4 = false;
                string3 = String.valueOf($this$run);
                Locale locale2 = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.US");
                locale = locale2;
                string2 = "start";
                map = queryParams;
                bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(locale);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                string = string5;
                map.put(string2, string);
            }
            Long l3 = this.end;
            if (l3 == null) break block3;
            l = l3;
            bl3 = false;
            bl2 = false;
            $this$run = ((Number)l).longValue();
            boolean bl5 = false;
            string3 = String.valueOf($this$run);
            Locale locale3 = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.US");
            locale = locale3;
            string2 = "end";
            map = queryParams;
            bl = false;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = string7;
            map.put(string2, string);
        }
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    @Nullable
    public final Long getStart() {
        return this.start;
    }

    @Nullable
    public final Long getEnd() {
        return this.end;
    }

    public final int getCount() {
        return this.count;
    }

    public final boolean getReverse() {
        return this.reverse;
    }

    public final boolean getIncludeTimetoken() {
        return this.includeTimetoken;
    }

    public final boolean getIncludeMeta() {
        return this.includeMeta;
    }

    public History(@NotNull PubNub pubnub, @NotNull String channel, @Nullable Long start, @Nullable Long end, int count, boolean reverse, boolean includeTimetoken, boolean includeMeta) {
        Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(pubnub);
        this.channel = channel;
        this.start = start;
        this.end = end;
        this.count = count;
        this.reverse = reverse;
        this.includeTimetoken = includeTimetoken;
        this.includeMeta = includeMeta;
        int n = this.count;
        this.countParam = 1 <= n && 100 >= n ? this.count : 100;
    }

    public /* synthetic */ History(PubNub pubNub, String string, Long l, Long l2, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        this(pubNub, string, l, l2, n, bl, bl2, bl3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pubnub/api/endpoints/History$Companion;", "", "()V", "MAX_COUNT", "", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

