/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PresenceOperation;
import com.pubnub.api.builder.StateOperation;
import com.pubnub.api.builder.SubscribeOperation;
import com.pubnub.api.builder.UnsubscribeOperation;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.endpoints.presence.Heartbeat;
import com.pubnub.api.endpoints.presence.Leave;
import com.pubnub.api.endpoints.pubsub.Subscribe;
import com.pubnub.api.enums.PNHeartbeatNotificationOptions;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.ReconnectionManager;
import com.pubnub.api.managers.StateManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeEnvelope;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.workers.SubscribeMessageWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000b\u0018\u0000 I2\u00020\u0001:\u0001IB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0017\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010+H\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b4J\u000e\u00105\u001a\u00020%2\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0002J\u0010\u0010;\u001a\u00020%2\b\b\u0002\u0010<\u001a\u00020\"J\u0006\u0010=\u001a\u00020%J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00190?J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00190?J\b\u0010A\u001a\u00020%H\u0002J\u0006\u0010B\u001a\u00020%J\b\u0010C\u001a\u00020%H\u0002J\u000e\u0010D\u001a\u00020%2\u0006\u00106\u001a\u000207J\b\u0010E\u001a\u00020%H\u0002J\b\u0010F\u001a\u00020%H\u0002J\b\u0010G\u001a\u00020%H\u0002J\u0006\u0010H\u001a\u00020%R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/pubnub/api/managers/SubscriptionManager;", "", "pubnub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "consumerThread", "Ljava/lang/Thread;", "duplicationManager", "Lcom/pubnub/api/managers/DuplicationManager;", "heartbeatCall", "Lcom/pubnub/api/endpoints/presence/Heartbeat;", "heartbeatTimer", "Ljava/util/Timer;", "listenerManager", "Lcom/pubnub/api/managers/ListenerManager;", "getListenerManager$pubnub_kotlin", "()Lcom/pubnub/api/managers/ListenerManager;", "messageQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pubnub/api/models/server/SubscribeMessage;", "getPubnub", "()Lcom/pubnub/api/PubNub;", "reconnectionManager", "Lcom/pubnub/api/managers/ReconnectionManager;", "region", "", "storedTimetoken", "", "Ljava/lang/Long;", "subscribeCall", "Lcom/pubnub/api/endpoints/pubsub/Subscribe;", "subscriptionState", "Lcom/pubnub/api/managers/StateManager;", "subscriptionStatusAnnounced", "", "timetoken", "adaptPresenceBuilder", "", "presenceOperation", "Lcom/pubnub/api/builder/PresenceOperation;", "adaptPresenceBuilder$pubnub_kotlin", "adaptStateBuilder", "stateOperation", "Lcom/pubnub/api/builder/StateOperation;", "adaptStateBuilder$pubnub_kotlin", "adaptSubscribeBuilder", "subscribeOperation", "Lcom/pubnub/api/builder/SubscribeOperation;", "adaptSubscribeBuilder$pubnub_kotlin", "adaptUnsubscribeBuilder", "unsubscribeOperation", "Lcom/pubnub/api/builder/UnsubscribeOperation;", "adaptUnsubscribeBuilder$pubnub_kotlin", "addListener", "listener", "Lcom/pubnub/api/callbacks/SubscribeCallback;", "createPublicStatus", "Lcom/pubnub/api/models/consumer/PNStatus;", "privateStatus", "destroy", "forceDestroy", "disconnect", "getSubscribedChannelGroups", "", "getSubscribedChannels", "performHeartbeatLoop", "reconnect", "registerHeartbeatTimer", "removeListener", "startSubscribeLoop", "stopHeartbeatLoop", "stopSubscribeLoop", "unsubscribeAll", "Companion", "pubnub-kotlin"})
public final class SubscriptionManager {
    private Subscribe subscribeCall;
    private Heartbeat heartbeatCall;
    private LinkedBlockingQueue<SubscribeMessage> messageQueue;
    private DuplicationManager duplicationManager;
    private long timetoken;
    private Long storedTimetoken;
    private String region;
    private Timer heartbeatTimer;
    private final StateManager subscriptionState;
    @NotNull
    private final ListenerManager listenerManager;
    private final ReconnectionManager reconnectionManager;
    private Thread consumerThread;
    private boolean subscriptionStatusAnnounced;
    @NotNull
    private final PubNub pubnub;
    private static final long HEARTBEAT_INTERVAL_MULTIPLIER = 1000L;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ListenerManager getListenerManager$pubnub_kotlin() {
        return this.listenerManager;
    }

    @NotNull
    public final synchronized List<String> getSubscribedChannels() {
        return this.subscriptionState.prepareChannelList(false);
    }

    @NotNull
    public final synchronized List<String> getSubscribedChannelGroups() {
        return this.subscriptionState.prepareChannelGroupList(false);
    }

    public final synchronized void adaptStateBuilder$pubnub_kotlin(@Nullable StateOperation stateOperation) {
        StateOperation stateOperation2 = stateOperation;
        if (stateOperation2 == null) {
            Intrinsics.throwNpe();
        }
        this.subscriptionState.adaptStateBuilder$pubnub_kotlin(stateOperation2);
        this.reconnect();
    }

    public final synchronized void adaptSubscribeBuilder$pubnub_kotlin(@NotNull SubscribeOperation subscribeOperation) {
        Intrinsics.checkParameterIsNotNull((Object)subscribeOperation, (String)"subscribeOperation");
        this.subscriptionState.adaptSubscribeBuilder$pubnub_kotlin(subscribeOperation);
        this.subscriptionStatusAnnounced = false;
        this.duplicationManager.clearHistory();
        this.timetoken = subscribeOperation.getTimetoken$pubnub_kotlin();
        if (this.timetoken != 0L) {
            this.storedTimetoken = this.timetoken;
        }
        this.timetoken = 0L;
        this.reconnect();
    }

    public final synchronized void reconnect() {
        this.startSubscribeLoop();
        this.registerHeartbeatTimer();
    }

    public final synchronized void disconnect() {
        Timer timer = this.heartbeatTimer;
        if (timer != null) {
            timer.cancel();
        }
        this.stopSubscribeLoop();
    }

    private final void registerHeartbeatTimer() {
        block2: {
            Timer timer = this.heartbeatTimer;
            if (timer != null) {
                timer.cancel();
            }
            if (this.pubnub.getConfiguration().getHeartbeatInterval() <= 0) {
                return;
            }
            Timer timer2 = this.heartbeatTimer = new Timer();
            if (timer2 == null) break block2;
            Timer timer3 = timer2;
            boolean bl = false;
            TimerTask timerTask2 = new TimerTask(this){
                final /* synthetic */ SubscriptionManager this$0;
                {
                    this.this$0 = subscriptionManager;
                }

                public void run() {
                    TimerTask $this$timerTask = this;
                    boolean bl = false;
                    SubscriptionManager.access$performHeartbeatLoop(this.this$0);
                }
            };
            timer3.schedule(timerTask2, 0L, (long)this.pubnub.getConfiguration().getHeartbeatInterval() * 1000L);
        }
    }

    private final void performHeartbeatLoop() {
        block2: {
            Heartbeat heartbeat = this.heartbeatCall;
            if (heartbeat != null) {
                heartbeat.silentCancel();
            }
            List<String> presenceChannels = this.subscriptionState.prepareChannelList(false);
            List<String> presenceChannelGroups = this.subscriptionState.prepareChannelGroupList(false);
            List<String> heartbeatChannels = this.subscriptionState.prepareHeartbeatChannelList(false);
            List<String> heartbeatChannelGroups = this.subscriptionState.prepareHeartbeatChannelGroupList(false);
            if (presenceChannels.isEmpty() && presenceChannelGroups.isEmpty() && heartbeatChannels.isEmpty() && heartbeatChannelGroups.isEmpty()) {
                return;
            }
            List channels = new ArrayList();
            channels.addAll((Collection)presenceChannels);
            channels.addAll((Collection)heartbeatChannels);
            List groups = new ArrayList();
            groups.addAll((Collection)presenceChannelGroups);
            groups.addAll((Collection)heartbeatChannelGroups);
            Heartbeat heartbeat2 = this.heartbeatCall = new Heartbeat(this.pubnub, channels, groups);
            if (heartbeat2 == null) break block2;
            heartbeat2.async((Function2)new Function2<Boolean, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable Boolean $noName_0, @NotNull PNStatus status) {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    PNHeartbeatNotificationOptions heartbeatVerbosity = this.this$0.getPubnub().getConfiguration().getHeartbeatNotificationOptions();
                    if (status.getError()) {
                        if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL || heartbeatVerbosity == PNHeartbeatNotificationOptions.FAILURES) {
                            this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                        }
                        Timer timer = SubscriptionManager.access$getHeartbeatTimer$p(this.this$0);
                        if (timer != null) {
                            timer.cancel();
                        }
                    } else if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL) {
                        this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                    }
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
    }

    private final void startSubscribeLoop() {
        block1: {
            Subscribe subscribe;
            this.stopSubscribeLoop();
            List<String> combinedChannels = this.subscriptionState.prepareChannelList(true);
            List<String> combinedChannelGroups = this.subscriptionState.prepareChannelGroupList(true);
            Map<String, Object> stateStorage = this.subscriptionState.createStatePayload();
            if (combinedChannels.isEmpty() && combinedChannelGroups.isEmpty()) {
                return;
            }
            Subscribe subscribe2 = new Subscribe(this.pubnub);
            SubscriptionManager subscriptionManager = this;
            boolean bl = false;
            boolean bl2 = false;
            Subscribe $this$apply = subscribe2;
            boolean bl3 = false;
            $this$apply.setChannels(combinedChannels);
            $this$apply.setChannelGroups(combinedChannelGroups);
            $this$apply.setTimetoken(this.timetoken);
            $this$apply.setRegion(this.region);
            this.pubnub.getConfiguration().isFilterExpressionKeyValid$pubnub_kotlin((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($this$apply){
                final /* synthetic */ Subscribe $this_apply;

                public final void invoke(@NotNull String $this$isFilterExpressionKeyValid) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$isFilterExpressionKeyValid, (String)"$receiver");
                    this.$this_apply.setFilterExpression($this$isFilterExpressionKeyValid);
                }
                {
                    this.$this_apply = subscribe;
                    super(1);
                }
            }));
            $this$apply.setState(stateStorage);
            subscriptionManager.subscribeCall = subscribe = subscribe2;
            Subscribe subscribe3 = this.subscribeCall;
            if (subscribe3 == null) break block1;
            subscribe3.async((Function2)new Function2<SubscribeEnvelope, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable SubscribeEnvelope result, @NotNull PNStatus status) {
                    Object object;
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    if (status.getError()) {
                        if (status.getCategory() == PNStatusCategory.PNTimeoutCategory) {
                            SubscriptionManager.access$startSubscribeLoop(this.this$0);
                            return;
                        }
                        this.this$0.disconnect();
                        this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                        if (status.getCategory() == PNStatusCategory.PNUnexpectedDisconnectCategory) {
                            SubscriptionManager.access$getReconnectionManager$p(this.this$0).startPolling$pubnub_kotlin(this.this$0.getPubnub().getConfiguration());
                        }
                        return;
                    }
                    if (!SubscriptionManager.access$getSubscriptionStatusAnnounced$p(this.this$0)) {
                        PNStatus pNStatus = SubscriptionManager.access$createPublicStatus(this.this$0, status);
                        bl = false;
                        boolean bl2 = false;
                        PNStatus $this$apply = pNStatus;
                        boolean bl3 = false;
                        $this$apply.setCategory(PNStatusCategory.PNConnectedCategory);
                        $this$apply.setError(false);
                        PNStatus pnStatus = pNStatus;
                        SubscriptionManager.access$setSubscriptionStatusAnnounced$p(this.this$0, true);
                        this.this$0.getListenerManager$pubnub_kotlin().announce(pnStatus);
                    }
                    Integer n = this.this$0.getPubnub().getConfiguration().getRequestMessageCountThreshold();
                    if (n != null) {
                        object = n;
                        boolean bl4 = false;
                        bl = false;
                        int it = ((Number)object).intValue();
                        boolean bl5 = false;
                        SubscribeEnvelope subscribeEnvelope = result;
                        if (subscribeEnvelope == null) {
                            Intrinsics.throwNpe();
                        }
                        if (it <= subscribeEnvelope.getMessages$pubnub_kotlin().size()) {
                            PNStatus pNStatus = SubscriptionManager.access$createPublicStatus(this.this$0, status);
                            ListenerManager listenerManager = this.this$0.getListenerManager$pubnub_kotlin();
                            boolean bl6 = false;
                            boolean bl7 = false;
                            PNStatus $this$apply = pNStatus;
                            boolean bl8 = false;
                            $this$apply.setCategory(PNStatusCategory.PNRequestMessageCountExceededCategory);
                            $this$apply.setError(false);
                            PNStatus pNStatus2 = pNStatus;
                            listenerManager.announce(pNStatus2);
                        }
                    }
                    SubscribeEnvelope subscribeEnvelope = result;
                    if (subscribeEnvelope == null) {
                        Intrinsics.throwNpe();
                    }
                    object = subscribeEnvelope.getMessages$pubnub_kotlin();
                    boolean bl9 = false;
                    if (!object.isEmpty()) {
                        SubscriptionManager.access$getMessageQueue$p(this.this$0).addAll((Collection)result.getMessages$pubnub_kotlin());
                    }
                    if (SubscriptionManager.access$getStoredTimetoken$p(this.this$0) != null) {
                        Long l = SubscriptionManager.access$getStoredTimetoken$p(this.this$0);
                        if (l == null) {
                            Intrinsics.throwNpe();
                        }
                        SubscriptionManager.access$setTimetoken$p(this.this$0, l);
                        SubscriptionManager.access$setStoredTimetoken$p(this.this$0, null);
                    } else {
                        SubscriptionManager.access$setTimetoken$p(this.this$0, result.getMetadata$pubnub_kotlin().getTimetoken$pubnub_kotlin());
                    }
                    SubscriptionManager.access$setRegion$p(this.this$0, result.getMetadata$pubnub_kotlin().getRegion$pubnub_kotlin());
                    SubscriptionManager.access$startSubscribeLoop(this.this$0);
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
    }

    private final void stopSubscribeLoop() {
        block0: {
            Subscribe subscribe = this.subscribeCall;
            if (subscribe == null) break block0;
            subscribe.silentCancel();
        }
    }

    private final void stopHeartbeatLoop() {
        block0: {
            Heartbeat heartbeat = this.heartbeatCall;
            if (heartbeat == null) break block0;
            heartbeat.silentCancel();
        }
    }

    public final void adaptPresenceBuilder$pubnub_kotlin(@NotNull PresenceOperation presenceOperation) {
        Intrinsics.checkParameterIsNotNull((Object)presenceOperation, (String)"presenceOperation");
        this.subscriptionState.adaptPresenceBuilder$pubnub_kotlin(presenceOperation);
        if (!this.pubnub.getConfiguration().getSuppressLeaveEvents() && !presenceOperation.getConnected$pubnub_kotlin()) {
            Leave leave = new Leave(this.pubnub);
            boolean bl = false;
            boolean bl2 = false;
            Leave $this$apply = leave;
            boolean bl3 = false;
            $this$apply.setChannels(presenceOperation.getChannels$pubnub_kotlin());
            $this$apply.setChannelGroups(presenceOperation.getChannelGroups$pubnub_kotlin());
            leave.async((Function2)new Function2<Boolean, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable Boolean $noName_0, @NotNull PNStatus status) {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
        this.registerHeartbeatTimer();
    }

    public final synchronized void adaptUnsubscribeBuilder$pubnub_kotlin(@NotNull UnsubscribeOperation unsubscribeOperation) {
        Intrinsics.checkParameterIsNotNull((Object)unsubscribeOperation, (String)"unsubscribeOperation");
        this.subscriptionState.adaptUnsubscribeBuilder$pubnub_kotlin(unsubscribeOperation);
        this.subscriptionStatusAnnounced = false;
        if (!this.pubnub.getConfiguration().getSuppressLeaveEvents()) {
            Leave leave = new Leave(this.pubnub);
            boolean bl = false;
            boolean bl2 = false;
            Leave $this$apply = leave;
            boolean bl3 = false;
            $this$apply.setChannels(unsubscribeOperation.getChannels$pubnub_kotlin());
            $this$apply.setChannelGroups(unsubscribeOperation.getChannelGroups$pubnub_kotlin());
            leave.async((Function2)new Function2<Boolean, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable Boolean $noName_0, @NotNull PNStatus status) {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
        if (this.subscriptionState.isEmpty()) {
            this.region = null;
            this.storedTimetoken = null;
            this.timetoken = 0L;
        } else {
            this.storedTimetoken = this.timetoken;
            this.timetoken = 0L;
        }
        this.reconnect();
    }

    public final synchronized void unsubscribeAll() {
        this.adaptUnsubscribeBuilder$pubnub_kotlin(new UnsubscribeOperation(this.subscriptionState.prepareChannelList(false), this.subscriptionState.prepareChannelGroupList(false)));
    }

    private final PNStatus createPublicStatus(PNStatus privateStatus) {
        boolean bl = false;
        boolean bl2 = false;
        PNStatus $this$with = privateStatus;
        boolean bl3 = false;
        return new PNStatus($this$with.getCategory(), $this$with.getError(), $this$with.getOperation(), $this$with.getException(), $this$with.getStatusCode(), $this$with.getTlsEnabled(), $this$with.getOrigin(), $this$with.getUuid(), $this$with.getAuthKey(), $this$with.getAffectedChannels(), $this$with.getAffectedChannelGroups());
    }

    public final void addListener(@NotNull SubscribeCallback listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerManager.addListener(listener);
    }

    public final void removeListener(@NotNull SubscribeCallback listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerManager.removeListener(listener);
    }

    public final synchronized void destroy(boolean forceDestroy) {
        this.disconnect();
        if (forceDestroy && this.consumerThread != null) {
            Thread thread = this.consumerThread;
            if (thread == null) {
                Intrinsics.throwNpe();
            }
            thread.interrupt();
        }
    }

    public static /* synthetic */ void destroy$default(SubscriptionManager subscriptionManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        subscriptionManager.destroy(bl);
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    public SubscriptionManager(@NotNull PubNub pubnub) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
            this.pubnub = pubnub;
            this.messageQueue = new LinkedBlockingQueue();
            this.duplicationManager = new DuplicationManager(this.pubnub.getConfiguration());
            this.subscriptionState = new StateManager();
            this.listenerManager = new ListenerManager(this.pubnub);
            this.reconnectionManager = new ReconnectionManager(this.pubnub);
            this.reconnectionManager.setReconnectionCallback$pubnub_kotlin(new ReconnectionCallback(){

                @Override
                public void onReconnection() {
                    this.reconnect();
                    List<String> list = subscriptionState.prepareChannelGroupList(true);
                    List<String> list2 = subscriptionState.prepareChannelList(true);
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    Boolean bl = null;
                    Integer n = null;
                    PubNubException pubNubException = null;
                    boolean bl2 = false;
                    PNOperationType pNOperationType = PNOperationType.PNSubscribeOperation.INSTANCE;
                    this.getListenerManager$pubnub_kotlin().announce(new PNStatus(PNStatusCategory.PNReconnectedCategory, bl2, pNOperationType, pubNubException, n, bl, string3, string2, string, list2, list, 504, null));
                    subscriptionStatusAnnounced = true;
                }

                @Override
                public void onMaxReconnectionExhaustion() {
                    List<String> list = subscriptionState.prepareChannelGroupList(true);
                    List<String> list2 = subscriptionState.prepareChannelList(true);
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    Boolean bl = null;
                    Integer n = null;
                    PubNubException pubNubException = null;
                    boolean bl2 = false;
                    PNOperationType pNOperationType = PNOperationType.PNSubscribeOperation.INSTANCE;
                    this.getListenerManager$pubnub_kotlin().announce(new PNStatus(PNStatusCategory.PNReconnectionAttemptsExhausted, bl2, pNOperationType, pubNubException, n, bl, string3, string2, string, list2, list, 504, null));
                    this.disconnect();
                }
            });
            if (!this.pubnub.getConfiguration().getStartSubscriberThread()) break block2;
            Thread thread = this.consumerThread = new Thread(new SubscribeMessageWorker(this.pubnub, this.listenerManager, this.messageQueue, this.duplicationManager));
            if (thread != null) {
                thread.setName("Subscription Manager Consumer Thread");
            }
            Thread thread2 = this.consumerThread;
            if (thread2 != null) {
                thread2.start();
            }
        }
    }

    public static final /* synthetic */ void access$performHeartbeatLoop(SubscriptionManager $this) {
        $this.performHeartbeatLoop();
    }

    public static final /* synthetic */ Timer access$getHeartbeatTimer$p(SubscriptionManager $this) {
        return $this.heartbeatTimer;
    }

    public static final /* synthetic */ void access$setHeartbeatTimer$p(SubscriptionManager $this, Timer timer) {
        $this.heartbeatTimer = timer;
    }

    public static final /* synthetic */ void access$startSubscribeLoop(SubscriptionManager $this) {
        $this.startSubscribeLoop();
    }

    public static final /* synthetic */ ReconnectionManager access$getReconnectionManager$p(SubscriptionManager $this) {
        return $this.reconnectionManager;
    }

    public static final /* synthetic */ boolean access$getSubscriptionStatusAnnounced$p(SubscriptionManager $this) {
        return $this.subscriptionStatusAnnounced;
    }

    public static final /* synthetic */ PNStatus access$createPublicStatus(SubscriptionManager $this, PNStatus privateStatus) {
        return $this.createPublicStatus(privateStatus);
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getMessageQueue$p(SubscriptionManager $this) {
        return $this.messageQueue;
    }

    public static final /* synthetic */ void access$setMessageQueue$p(SubscriptionManager $this, LinkedBlockingQueue linkedBlockingQueue) {
        $this.messageQueue = linkedBlockingQueue;
    }

    public static final /* synthetic */ Long access$getStoredTimetoken$p(SubscriptionManager $this) {
        return $this.storedTimetoken;
    }

    public static final /* synthetic */ void access$setStoredTimetoken$p(SubscriptionManager $this, Long l) {
        $this.storedTimetoken = l;
    }

    public static final /* synthetic */ long access$getTimetoken$p(SubscriptionManager $this) {
        return $this.timetoken;
    }

    public static final /* synthetic */ void access$setTimetoken$p(SubscriptionManager $this, long l) {
        $this.timetoken = l;
    }

    public static final /* synthetic */ String access$getRegion$p(SubscriptionManager $this) {
        return $this.region;
    }

    public static final /* synthetic */ void access$setRegion$p(SubscriptionManager $this, String string) {
        $this.region = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pubnub/api/managers/SubscriptionManager$Companion;", "", "()V", "HEARTBEAT_INTERVAL_MULTIPLIER", "", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

