/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.TelemetryManager;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00192\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ'\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001fR6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/pubnub/api/managers/TelemetryManager;", "", "()V", "latencies", "Ljava/util/HashMap;", "", "", "Lcom/pubnub/api/managers/TelemetryManager$Latency;", "Lkotlin/collections/HashMap;", "numberFormat", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "getNumberFormat", "()Ljava/text/NumberFormat;", "numberFormat$delegate", "Lkotlin/Lazy;", "averageLatencyFromData", "", "endpointLatencies", "", "cleanUpTelemetryData", "", "currentDate", "", "operationsLatency", "", "operationsLatency$pubnub_kotlin", "storeLatency", "latency", "type", "Lcom/pubnub/api/enums/PNOperationType;", "storeLatency$pubnub_kotlin", "Companion", "Latency", "pubnub-kotlin"})
public final class TelemetryManager {
    private final HashMap<String, List<Latency>> latencies = new HashMap();
    private final Lazy numberFormat$delegate = LazyKt.lazy((Function0)numberFormat.2.INSTANCE);
    private static final int MAX_FRACTION_DIGITS = 3;
    private static final int TIMESTAMP_DIVIDER = 1000;
    private static final double MAXIMUM_LATENCY_DATA_AGE = 60.0;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    private final NumberFormat getNumberFormat() {
        Lazy lazy = this.numberFormat$delegate;
        TelemetryManager telemetryManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NumberFormat)lazy.getValue();
    }

    @NotNull
    public final synchronized Map<String, String> operationsLatency$pubnub_kotlin(long currentDate) {
        this.cleanUpTelemetryData(currentDate);
        HashMap operationLatencies = new HashMap();
        Set<Map.Entry<String, List<Latency>>> set = this.latencies.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"latencies.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            String latencyKey = "l_" + (String)it.getKey();
            Object v = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
            double endpointAverageLatency = this.averageLatencyFromData((List)v);
            if (!(endpointAverageLatency > (double)0.0f)) continue;
            Map map = operationLatencies;
            String string = this.getNumberFormat().format(endpointAverageLatency);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"numberFormat.format(endpointAverageLatency)");
            map.put(latencyKey, string);
        }
        return operationLatencies;
    }

    public static /* synthetic */ Map operationsLatency$pubnub_kotlin$default(TelemetryManager telemetryManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = new Date().getTime();
        }
        return telemetryManager.operationsLatency$pubnub_kotlin(l);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void cleanUpTelemetryData(long currentDate) {
        boolean bl;
        Collection collection;
        Map.Entry element$iv2;
        double date = (double)currentDate / (double)1000;
        Map $this$forEach$iv = this.latencies;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl2 = false;
        for (Map.Entry element$iv2 : map.entrySet()) {
            void $this$filterTo$iv$iv;
            Map.Entry $dstr$_u24__u24$operationLatencies = element$iv2;
            boolean bl3 = false;
            Map.Entry entry = $dstr$_u24__u24$operationLatencies;
            boolean bl4 = false;
            List operationLatencies = (List)entry.getValue();
            Iterable $this$filter$iv = operationLatencies;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Latency it = (Latency)element$iv$iv;
                boolean bl5 = false;
                if (!it.isOutdated(date)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List outdated = (List)destination$iv$iv;
            collection = operationLatencies;
            bl = false;
            CollectionsKt.removeAll((Collection)collection, (Iterable)outdated);
        }
        Map $this$filterValues$iv = this.latencies;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl6 = false;
        element$iv2 = map2.entrySet().iterator();
        while (element$iv2.hasNext()) {
            Map.Entry entry$iv = (Map.Entry)element$iv2.next();
            List it = (List)entry$iv.getValue();
            boolean bl7 = false;
            collection = it;
            boolean operationLatencies = false;
            bl = false;
            if (!(collection == null || collection.isEmpty())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$forEach$iv = result$iv;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl8 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$endpoint$_u24__u24 = element$iv2 = iterator.next();
            boolean bl9 = false;
            Object object = $dstr$endpoint$_u24__u24;
            boolean bl10 = false;
            String endpoint = (String)object.getKey();
            object = this.latencies;
            bl10 = false;
            object.remove(endpoint);
        }
    }

    static /* synthetic */ void cleanUpTelemetryData$default(TelemetryManager telemetryManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = new Date().getTime();
        }
        telemetryManager.cleanUpTelemetryData(l);
    }

    /*
     * WARNING - void declaration
     */
    private final double averageLatencyFromData(List<Latency> endpointLatencies) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = endpointLatencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Latency latency = (Latency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getLatency();
            Double d2 = d != null ? d : 0.0;
            collection.add(d2);
        }
        double totalLatency = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
        return totalLatency / (double)endpointLatencies.size();
    }

    public final synchronized void storeLatency$pubnub_kotlin(long latency, @NotNull PNOperationType type, long currentDate) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            String string = type.getQueryParam();
            if (string == null) break block3;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String queryParam = string2;
            boolean bl3 = false;
            if (latency > 0L) {
                double storeDate = (double)currentDate / (double)1000;
                if (this.latencies.get(queryParam) == null) {
                    ((Map)this.latencies).put(queryParam, new ArrayList());
                }
                List<Latency> list = this.latencies.get(queryParam);
                if (list != null) {
                    List<Latency> list2 = list;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    List<Latency> it = list2;
                    boolean bl6 = false;
                    Double d = (double)latency / (double)1000;
                    Double d2 = storeDate;
                    Latency latencyEntry = new Latency(d, d2);
                    it.add(latencyEntry);
                }
            }
        }
    }

    public static /* synthetic */ void storeLatency$pubnub_kotlin$default(TelemetryManager telemetryManager, long l, PNOperationType pNOperationType, long l2, int n, Object object) {
        if ((n & 4) != 0) {
            l2 = new Date().getTime();
        }
        telemetryManager.storeLatency$pubnub_kotlin(l, pNOperationType, l2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J&\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/pubnub/api/managers/TelemetryManager$Latency;", "", "latency", "", "date", "(Ljava/lang/Double;Ljava/lang/Double;)V", "getDate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getLatency", "component1", "component2", "copy", "(Ljava/lang/Double;Ljava/lang/Double;)Lcom/pubnub/api/managers/TelemetryManager$Latency;", "equals", "", "other", "hashCode", "", "isOutdated", "currentDate", "toString", "", "pubnub-kotlin"})
    private static final class Latency {
        @Nullable
        private final Double latency;
        @Nullable
        private final Double date;

        public final boolean isOutdated(double currentDate) {
            boolean bl;
            Double d = this.date;
            if (d != null) {
                Double d2 = d;
                boolean bl2 = false;
                boolean bl3 = false;
                double it = ((Number)d2).doubleValue();
                boolean bl4 = false;
                Companion;
                bl = currentDate - it > 60.0;
            } else {
                bl = true;
            }
            return bl;
        }

        @Nullable
        public final Double getLatency() {
            return this.latency;
        }

        @Nullable
        public final Double getDate() {
            return this.date;
        }

        public Latency(@Nullable Double latency, @Nullable Double date) {
            this.latency = latency;
            this.date = date;
        }

        @Nullable
        public final Double component1() {
            return this.latency;
        }

        @Nullable
        public final Double component2() {
            return this.date;
        }

        @NotNull
        public final Latency copy(@Nullable Double latency, @Nullable Double date) {
            return new Latency(latency, date);
        }

        public static /* synthetic */ Latency copy$default(Latency latency, Double d, Double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = latency.latency;
            }
            if ((n & 2) != 0) {
                d2 = latency.date;
            }
            return latency.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "Latency(latency=" + this.latency + ", date=" + this.date + ")";
        }

        public int hashCode() {
            Double d = this.latency;
            Double d2 = this.date;
            return (d != null ? ((Object)d).hashCode() : 0) * 31 + (d2 != null ? ((Object)d2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Latency)) break block3;
                    Latency latency = (Latency)object;
                    if (!Intrinsics.areEqual((Object)this.latency, (Object)latency.latency) || !Intrinsics.areEqual((Object)this.date, (Object)latency.date)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/pubnub/api/managers/TelemetryManager$Companion;", "", "()V", "MAXIMUM_LATENCY_DATA_AGE", "", "MAX_FRACTION_DIGITS", "", "TIMESTAMP_DIVIDER", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

