/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.history.PNMessageCountResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B+\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0014J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/pubnub/api/endpoints/MessageCounts;", "Lcom/pubnub/api/Endpoint;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNMessageCountResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "channelsTimetoken", "", "(Lcom/pubnub/api/PubNub;Ljava/util/List;Ljava/util/List;)V", "getChannels", "()Ljava/util/List;", "getChannelsTimetoken", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNMessageCountOperation;", "validateParams", "pubnub-kotlin"})
public final class MessageCounts
extends Endpoint<JsonElement, PNMessageCountResult> {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<Long> channelsTimetoken;

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty()) {
            throw (Throwable)new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.channelsTimetoken.isEmpty()) {
            throw (Throwable)new PubNubException(PubNubError.TIMETOKEN_MISSING);
        }
        if (this.channelsTimetoken.size() != this.channels.size() && this.channelsTimetoken.size() > 1) {
            throw (Throwable)new PubNubException(PubNubError.CHANNELS_TIMETOKEN_MISMATCH);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkParameterIsNotNull(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchCount(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNMessageCountResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        HashMap channelsMap = new HashMap();
        MapperManager mapperManager = this.getPubnub().getMapper();
        Object object = input.body();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"input.body()!!");
        Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator((JsonElement)object, "channels");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> entry = it.next();
            Map map = channelsMap;
            String string = entry.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.key");
            JsonElement jsonElement = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"entry.value");
            map.put(string, jsonElement.getAsLong());
        }
        return new PNMessageCountResult(channelsMap);
    }

    @Override
    @NotNull
    public PNOperationType.PNMessageCountOperation operationType() {
        return PNOperationType.PNMessageCountOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (this.channelsTimetoken.size() == 1) {
            queryParams.put("timetoken", PubNubUtilKt.toCsv(this.channelsTimetoken));
        } else {
            queryParams.put("channelsTimetoken", PubNubUtilKt.toCsv(this.channelsTimetoken));
        }
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final List<Long> getChannelsTimetoken() {
        return this.channelsTimetoken;
    }

    public MessageCounts(@NotNull PubNub pubnub, @NotNull List<String> channels, @NotNull List<Long> channelsTimetoken) {
        Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
        Intrinsics.checkParameterIsNotNull(channels, (String)"channels");
        Intrinsics.checkParameterIsNotNull(channelsTimetoken, (String)"channelsTimetoken");
        super(pubnub);
        this.channels = channels;
        this.channelsTimetoken = channelsTimetoken;
    }
}

