/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.ConnectedStatusAnnouncedOperation;
import com.pubnub.api.builder.NoOpOperation;
import com.pubnub.api.builder.PresenceOperation;
import com.pubnub.api.builder.PubSubOperation;
import com.pubnub.api.builder.StateOperation;
import com.pubnub.api.builder.SubscribeOperation;
import com.pubnub.api.builder.TimetokenRegionOperation;
import com.pubnub.api.builder.UnsubscribeOperation;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.endpoints.presence.Heartbeat;
import com.pubnub.api.endpoints.presence.Leave;
import com.pubnub.api.endpoints.pubsub.Subscribe;
import com.pubnub.api.enums.PNHeartbeatNotificationOptions;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.ReconnectionManager;
import com.pubnub.api.managers.StateManager;
import com.pubnub.api.managers.SubscriptionStateData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeEnvelope;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.workers.SubscribeMessageWorker;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 I2\u00020\u0001:\u0001IB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u0010\u00103\u001a\u00020\u001d2\b\b\u0002\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\u001dJ\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020908J\b\u0010;\u001a\u00020\u001dH\u0002J\u0017\u0010<\u001a\u00020\u001d2\b\b\u0002\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>H\u0002J\u000e\u0010A\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/J#\u0010B\u001a\u00020\u001d2\u0014\b\u0002\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020>0D\"\u00020>H\u0002\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020\u001dH\u0002J\b\u0010G\u001a\u00020\u001dH\u0002J\u0006\u0010H\u001a\u00020\u001dR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/pubnub/api/managers/SubscriptionManager;", "", "pubnub", "Lcom/pubnub/api/PubNub;", "subscriptionState", "Lcom/pubnub/api/managers/StateManager;", "(Lcom/pubnub/api/PubNub;Lcom/pubnub/api/managers/StateManager;)V", "consumerThread", "Ljava/lang/Thread;", "duplicationManager", "Lcom/pubnub/api/managers/DuplicationManager;", "heartbeatCall", "Lcom/pubnub/api/endpoints/presence/Heartbeat;", "heartbeatTimer", "Ljava/util/Timer;", "listenerManager", "Lcom/pubnub/api/managers/ListenerManager;", "getListenerManager$pubnub_kotlin", "()Lcom/pubnub/api/managers/ListenerManager;", "messageQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pubnub/api/models/server/SubscribeMessage;", "getPubnub", "()Lcom/pubnub/api/PubNub;", "reconnectionManager", "Lcom/pubnub/api/managers/ReconnectionManager;", "subscribeCall", "Lcom/pubnub/api/endpoints/pubsub/Subscribe;", "adaptPresenceBuilder", "", "presenceOperation", "Lcom/pubnub/api/builder/PresenceOperation;", "adaptPresenceBuilder$pubnub_kotlin", "adaptStateBuilder", "stateOperation", "Lcom/pubnub/api/builder/StateOperation;", "adaptStateBuilder$pubnub_kotlin", "adaptSubscribeBuilder", "subscribeOperation", "Lcom/pubnub/api/builder/SubscribeOperation;", "adaptSubscribeBuilder$pubnub_kotlin", "adaptUnsubscribeBuilder", "unsubscribeOperation", "Lcom/pubnub/api/builder/UnsubscribeOperation;", "adaptUnsubscribeBuilder$pubnub_kotlin", "addListener", "listener", "Lcom/pubnub/api/callbacks/SubscribeCallback;", "createPublicStatus", "Lcom/pubnub/api/models/consumer/PNStatus;", "privateStatus", "destroy", "forceDestroy", "", "disconnect", "getSubscribedChannelGroups", "", "", "getSubscribedChannels", "performHeartbeatLoop", "reconnect", "pubSubOperation", "Lcom/pubnub/api/builder/PubSubOperation;", "reconnect$pubnub_kotlin", "registerHeartbeatTimer", "removeListener", "startSubscribeLoop", "pubSubOperations", "", "([Lcom/pubnub/api/builder/PubSubOperation;)V", "stopHeartbeatLoop", "stopSubscribeLoop", "unsubscribeAll", "Companion", "pubnub-kotlin"})
public final class SubscriptionManager {
    private Subscribe subscribeCall;
    private Heartbeat heartbeatCall;
    private LinkedBlockingQueue<SubscribeMessage> messageQueue;
    private DuplicationManager duplicationManager;
    private Timer heartbeatTimer;
    @NotNull
    private final ListenerManager listenerManager;
    private final ReconnectionManager reconnectionManager;
    private Thread consumerThread;
    @NotNull
    private final PubNub pubnub;
    private final StateManager subscriptionState;
    private static final long HEARTBEAT_INTERVAL_MULTIPLIER = 1000L;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ListenerManager getListenerManager$pubnub_kotlin() {
        return this.listenerManager;
    }

    @NotNull
    public final List<String> getSubscribedChannels() {
        return this.subscriptionState.subscriptionStateData$pubnub_kotlin(false).getChannels();
    }

    @NotNull
    public final List<String> getSubscribedChannelGroups() {
        return this.subscriptionState.subscriptionStateData$pubnub_kotlin(false).getChannelGroups();
    }

    public final void adaptStateBuilder$pubnub_kotlin(@NotNull StateOperation stateOperation) {
        Intrinsics.checkParameterIsNotNull((Object)stateOperation, (String)"stateOperation");
        this.reconnect$pubnub_kotlin(stateOperation);
    }

    public final void adaptSubscribeBuilder$pubnub_kotlin(@NotNull SubscribeOperation subscribeOperation) {
        Intrinsics.checkParameterIsNotNull((Object)subscribeOperation, (String)"subscribeOperation");
        this.reconnect$pubnub_kotlin(subscribeOperation);
    }

    public final void reconnect$pubnub_kotlin(@NotNull PubSubOperation pubSubOperation) {
        Intrinsics.checkParameterIsNotNull((Object)pubSubOperation, (String)"pubSubOperation");
        this.startSubscribeLoop(pubSubOperation);
        this.registerHeartbeatTimer(NoOpOperation.INSTANCE);
    }

    public static /* synthetic */ void reconnect$pubnub_kotlin$default(SubscriptionManager subscriptionManager, PubSubOperation pubSubOperation, int n, Object object) {
        if ((n & 1) != 0) {
            pubSubOperation = NoOpOperation.INSTANCE;
        }
        subscriptionManager.reconnect$pubnub_kotlin(pubSubOperation);
    }

    public final void disconnect() {
        Timer timer = this.heartbeatTimer;
        if (timer != null) {
            timer.cancel();
        }
        this.stopSubscribeLoop();
    }

    private final synchronized void registerHeartbeatTimer(PubSubOperation pubSubOperation) {
        block2: {
            this.subscriptionState.handleOperation$pubnub_kotlin(pubSubOperation);
            Timer timer = this.heartbeatTimer;
            if (timer != null) {
                timer.cancel();
            }
            if (this.pubnub.getConfiguration().getHeartbeatInterval() <= 0) {
                return;
            }
            Timer timer2 = this.heartbeatTimer = new Timer();
            if (timer2 == null) break block2;
            Timer timer3 = timer2;
            boolean bl = false;
            TimerTask timerTask2 = new TimerTask(this){
                final /* synthetic */ SubscriptionManager this$0;
                {
                    this.this$0 = subscriptionManager;
                }

                public void run() {
                    TimerTask $this$timerTask = this;
                    boolean bl = false;
                    SubscriptionManager.access$performHeartbeatLoop(this.this$0);
                }
            };
            timer3.schedule(timerTask2, 0L, (long)this.pubnub.getConfiguration().getHeartbeatInterval() * 1000L);
        }
    }

    private final synchronized void performHeartbeatLoop() {
        block2: {
            Heartbeat heartbeat = this.heartbeatCall;
            if (heartbeat != null) {
                heartbeat.silentCancel();
            }
            SubscriptionStateData subscriptionStateData = this.subscriptionState.subscriptionStateData$pubnub_kotlin(false);
            if (subscriptionStateData.getChannels().isEmpty() && subscriptionStateData.getChannelGroups().isEmpty() && subscriptionStateData.getHeartbeatChannels().isEmpty() && subscriptionStateData.getHeartbeatChannelGroups().isEmpty()) {
                return;
            }
            List channels = CollectionsKt.plus((Collection)subscriptionStateData.getChannels(), (Iterable)subscriptionStateData.getHeartbeatChannels());
            List groups = CollectionsKt.plus((Collection)subscriptionStateData.getChannelGroups(), (Iterable)subscriptionStateData.getHeartbeatChannelGroups());
            Heartbeat heartbeat2 = this.heartbeatCall = new Heartbeat(this.pubnub, channels, groups);
            if (heartbeat2 == null) break block2;
            heartbeat2.async((Function2)new Function2<Boolean, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable Boolean $noName_0, @NotNull PNStatus status) {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    PNHeartbeatNotificationOptions heartbeatVerbosity = this.this$0.getPubnub().getConfiguration().getHeartbeatNotificationOptions();
                    if (status.getError()) {
                        if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL || heartbeatVerbosity == PNHeartbeatNotificationOptions.FAILURES) {
                            this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                        }
                        Timer timer = SubscriptionManager.access$getHeartbeatTimer$p(this.this$0);
                        if (timer != null) {
                            timer.cancel();
                        }
                    } else if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL) {
                        this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                    }
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
    }

    private final synchronized void startSubscribeLoop(PubSubOperation ... pubSubOperations) {
        block4: {
            Subscribe subscribe;
            SubscriptionStateData stateData;
            boolean bl;
            int n;
            block3: {
                this.stopSubscribeLoop();
                this.subscriptionState.handleOperation$pubnub_kotlin(Arrays.copyOf(pubSubOperations, pubSubOperations.length));
                PubSubOperation[] $this$any$iv = pubSubOperations;
                boolean $i$f$any = false;
                PubSubOperation[] pubSubOperationArray = $this$any$iv;
                n = pubSubOperationArray.length;
                for (int i = 0; i < n; ++i) {
                    PubSubOperation element$iv;
                    PubSubOperation it = element$iv = pubSubOperationArray[i];
                    boolean bl2 = false;
                    if (!(it instanceof SubscribeOperation)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                this.duplicationManager.clearHistory();
            }
            if ((stateData = this.subscriptionState.subscriptionStateData$pubnub_kotlin(true)).getChannels().isEmpty() && stateData.getChannelGroups().isEmpty()) {
                return;
            }
            Subscribe subscribe2 = new Subscribe(this.pubnub);
            SubscriptionManager subscriptionManager = this;
            boolean bl3 = false;
            n = 0;
            Subscribe $this$apply = subscribe2;
            boolean bl4 = false;
            $this$apply.setChannels(stateData.getChannels());
            $this$apply.setChannelGroups(stateData.getChannelGroups());
            $this$apply.setTimetoken(stateData.getTimetoken());
            $this$apply.setRegion(stateData.getRegion());
            this.pubnub.getConfiguration().isFilterExpressionKeyValid$pubnub_kotlin((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($this$apply){
                final /* synthetic */ Subscribe $this_apply;

                public final void invoke(@NotNull String $this$isFilterExpressionKeyValid) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$isFilterExpressionKeyValid, (String)"$receiver");
                    this.$this_apply.setFilterExpression($this$isFilterExpressionKeyValid);
                }
                {
                    this.$this_apply = subscribe;
                    super(1);
                }
            }));
            $this$apply.setState(stateData.getStatePayload());
            subscriptionManager.subscribeCall = subscribe = subscribe2;
            Subscribe subscribe3 = this.subscribeCall;
            if (subscribe3 == null) break block4;
            subscribe3.async((Function2)new Function2<SubscribeEnvelope, PNStatus, Unit>(this, stateData){
                final /* synthetic */ SubscriptionManager this$0;
                final /* synthetic */ SubscriptionStateData $stateData;

                public final void invoke(@Nullable SubscribeEnvelope result, @NotNull PNStatus status) {
                    Object object;
                    ConnectedStatusAnnouncedOperation connectedStatusAnnouncedOperation;
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    if (status.getError()) {
                        if (status.getCategory() == PNStatusCategory.PNTimeoutCategory) {
                            SubscriptionManager.startSubscribeLoop$default(this.this$0, null, 1, null);
                            return;
                        }
                        this.this$0.disconnect();
                        this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                        if (status.getCategory() == PNStatusCategory.PNUnexpectedDisconnectCategory) {
                            SubscriptionManager.access$getReconnectionManager$p(this.this$0).startPolling$pubnub_kotlin(this.this$0.getPubnub().getConfiguration());
                        }
                        return;
                    }
                    if (this.$stateData.getShouldAnnounce()) {
                        PNStatus pNStatus = SubscriptionManager.access$createPublicStatus(this.this$0, status);
                        bl = false;
                        boolean bl2 = false;
                        PNStatus $this$apply = pNStatus;
                        boolean bl3 = false;
                        $this$apply.setCategory(PNStatusCategory.PNConnectedCategory);
                        $this$apply.setError(false);
                        PNStatus pnStatus = pNStatus;
                        this.this$0.getListenerManager$pubnub_kotlin().announce(pnStatus);
                        connectedStatusAnnouncedOperation = ConnectedStatusAnnouncedOperation.INSTANCE;
                    } else {
                        connectedStatusAnnouncedOperation = null;
                    }
                    ConnectedStatusAnnouncedOperation announcedOperation = connectedStatusAnnouncedOperation;
                    Integer n = this.this$0.getPubnub().getConfiguration().getRequestMessageCountThreshold();
                    if (n != null) {
                        object = n;
                        boolean bl4 = false;
                        bl = false;
                        int it = ((Number)object).intValue();
                        boolean bl5 = false;
                        SubscribeEnvelope subscribeEnvelope = result;
                        if (subscribeEnvelope == null) {
                            Intrinsics.throwNpe();
                        }
                        if (it <= subscribeEnvelope.getMessages$pubnub_kotlin().size()) {
                            PNStatus pNStatus = SubscriptionManager.access$createPublicStatus(this.this$0, status);
                            ListenerManager listenerManager = this.this$0.getListenerManager$pubnub_kotlin();
                            boolean bl6 = false;
                            boolean bl7 = false;
                            PNStatus $this$apply = pNStatus;
                            boolean bl8 = false;
                            $this$apply.setCategory(PNStatusCategory.PNRequestMessageCountExceededCategory);
                            $this$apply.setError(false);
                            PNStatus pNStatus2 = pNStatus;
                            listenerManager.announce(pNStatus2);
                        }
                    }
                    SubscribeEnvelope subscribeEnvelope = result;
                    if (subscribeEnvelope == null) {
                        Intrinsics.throwNpe();
                    }
                    object = subscribeEnvelope.getMessages$pubnub_kotlin();
                    boolean bl9 = false;
                    if (!object.isEmpty()) {
                        SubscriptionManager.access$getMessageQueue$p(this.this$0).addAll((Collection)result.getMessages$pubnub_kotlin());
                    }
                    PubSubOperation[] pubSubOperationArray = new PubSubOperation[2];
                    pubSubOperationArray[0] = new TimetokenRegionOperation(result.getMetadata$pubnub_kotlin().getTimetoken$pubnub_kotlin(), result.getMetadata$pubnub_kotlin().getRegion$pubnub_kotlin());
                    ConnectedStatusAnnouncedOperation connectedStatusAnnouncedOperation2 = announcedOperation;
                    pubSubOperationArray[1] = connectedStatusAnnouncedOperation2 != null ? (PubSubOperation)connectedStatusAnnouncedOperation2 : (PubSubOperation)NoOpOperation.INSTANCE;
                    SubscriptionManager.access$startSubscribeLoop(this.this$0, pubSubOperationArray);
                }
                {
                    this.this$0 = subscriptionManager;
                    this.$stateData = subscriptionStateData;
                    super(2);
                }
            });
        }
    }

    static /* synthetic */ void startSubscribeLoop$default(SubscriptionManager subscriptionManager, PubSubOperation[] pubSubOperationArray, int n, Object object) {
        if ((n & 1) != 0) {
            pubSubOperationArray = new NoOpOperation[]{NoOpOperation.INSTANCE};
        }
        subscriptionManager.startSubscribeLoop(pubSubOperationArray);
    }

    private final void stopSubscribeLoop() {
        block0: {
            Subscribe subscribe = this.subscribeCall;
            if (subscribe == null) break block0;
            subscribe.silentCancel();
        }
    }

    private final void stopHeartbeatLoop() {
        block0: {
            Heartbeat heartbeat = this.heartbeatCall;
            if (heartbeat == null) break block0;
            heartbeat.silentCancel();
        }
    }

    public final void adaptPresenceBuilder$pubnub_kotlin(@NotNull PresenceOperation presenceOperation) {
        Intrinsics.checkParameterIsNotNull((Object)presenceOperation, (String)"presenceOperation");
        if (!this.pubnub.getConfiguration().getSuppressLeaveEvents() && !presenceOperation.getConnected()) {
            Leave leave = new Leave(this.pubnub);
            boolean bl = false;
            boolean bl2 = false;
            Leave $this$apply = leave;
            boolean bl3 = false;
            $this$apply.setChannels(presenceOperation.getChannels());
            $this$apply.setChannelGroups(presenceOperation.getChannelGroups());
            leave.async((Function2)new Function2<Boolean, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable Boolean $noName_0, @NotNull PNStatus status) {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
        this.registerHeartbeatTimer(presenceOperation);
    }

    public final void adaptUnsubscribeBuilder$pubnub_kotlin(@NotNull UnsubscribeOperation unsubscribeOperation) {
        Intrinsics.checkParameterIsNotNull((Object)unsubscribeOperation, (String)"unsubscribeOperation");
        if (!this.pubnub.getConfiguration().getSuppressLeaveEvents()) {
            Leave leave = new Leave(this.pubnub);
            boolean bl = false;
            boolean bl2 = false;
            Leave $this$apply = leave;
            boolean bl3 = false;
            $this$apply.setChannels(unsubscribeOperation.getChannels());
            $this$apply.setChannelGroups(unsubscribeOperation.getChannelGroups());
            leave.async((Function2)new Function2<Boolean, PNStatus, Unit>(this){
                final /* synthetic */ SubscriptionManager this$0;

                public final void invoke(@Nullable Boolean $noName_0, @NotNull PNStatus status) {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    this.this$0.getListenerManager$pubnub_kotlin().announce(status);
                }
                {
                    this.this$0 = subscriptionManager;
                    super(2);
                }
            });
        }
        this.reconnect$pubnub_kotlin(unsubscribeOperation);
    }

    public final void unsubscribeAll() {
        SubscriptionStateData subscriptionStateData = this.subscriptionState.subscriptionStateData$pubnub_kotlin(false);
        boolean bl = false;
        boolean bl2 = false;
        SubscriptionStateData it = subscriptionStateData;
        boolean bl3 = false;
        this.adaptUnsubscribeBuilder$pubnub_kotlin(new UnsubscribeOperation(it.getChannels(), it.getChannelGroups()));
    }

    private final PNStatus createPublicStatus(PNStatus privateStatus) {
        boolean bl = false;
        boolean bl2 = false;
        PNStatus $this$with = privateStatus;
        boolean bl3 = false;
        return new PNStatus($this$with.getCategory(), $this$with.getError(), $this$with.getOperation(), $this$with.getException(), $this$with.getStatusCode(), $this$with.getTlsEnabled(), $this$with.getOrigin(), $this$with.getUuid(), $this$with.getAuthKey(), $this$with.getAffectedChannels(), $this$with.getAffectedChannelGroups());
    }

    public final void addListener(@NotNull SubscribeCallback listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerManager.addListener(listener);
    }

    public final void removeListener(@NotNull SubscribeCallback listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerManager.removeListener(listener);
    }

    public final synchronized void destroy(boolean forceDestroy) {
        this.disconnect();
        if (forceDestroy && this.consumerThread != null) {
            Thread thread = this.consumerThread;
            if (thread == null) {
                Intrinsics.throwNpe();
            }
            thread.interrupt();
        }
    }

    public static /* synthetic */ void destroy$default(SubscriptionManager subscriptionManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        subscriptionManager.destroy(bl);
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    public SubscriptionManager(@NotNull PubNub pubnub, @NotNull StateManager subscriptionState) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
            Intrinsics.checkParameterIsNotNull((Object)subscriptionState, (String)"subscriptionState");
            this.pubnub = pubnub;
            this.subscriptionState = subscriptionState;
            this.messageQueue = new LinkedBlockingQueue();
            this.duplicationManager = new DuplicationManager(this.pubnub.getConfiguration());
            this.listenerManager = new ListenerManager(this.pubnub);
            this.reconnectionManager = new ReconnectionManager(this.pubnub);
            this.reconnectionManager.setReconnectionCallback$pubnub_kotlin(new ReconnectionCallback(){

                @Override
                public void onReconnection() {
                    SubscriptionManager.reconnect$pubnub_kotlin$default(this, null, 1, null);
                    SubscriptionStateData subscriptionStateData = subscriptionState.subscriptionStateData$pubnub_kotlin(true);
                    boolean bl = false;
                    boolean bl2 = false;
                    SubscriptionStateData it = subscriptionStateData;
                    boolean bl3 = false;
                    List<String> list = it.getChannelGroups();
                    List<String> list2 = it.getChannels();
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    Boolean bl4 = null;
                    Integer n = null;
                    PubNubException pubNubException = null;
                    boolean bl5 = false;
                    PNOperationType pNOperationType = PNOperationType.PNSubscribeOperation.INSTANCE;
                    this.getListenerManager$pubnub_kotlin().announce(new PNStatus(PNStatusCategory.PNReconnectedCategory, bl5, pNOperationType, pubNubException, n, bl4, string3, string2, string, list2, list, 504, null));
                }

                @Override
                public void onMaxReconnectionExhaustion() {
                    SubscriptionStateData subscriptionStateData = subscriptionState.subscriptionStateData$pubnub_kotlin(true);
                    boolean bl = false;
                    boolean bl2 = false;
                    SubscriptionStateData it = subscriptionStateData;
                    boolean bl3 = false;
                    List<String> list = it.getChannelGroups();
                    List<String> list2 = it.getChannels();
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    Boolean bl4 = null;
                    Integer n = null;
                    PubNubException pubNubException = null;
                    boolean bl5 = false;
                    PNOperationType pNOperationType = PNOperationType.PNSubscribeOperation.INSTANCE;
                    this.getListenerManager$pubnub_kotlin().announce(new PNStatus(PNStatusCategory.PNReconnectionAttemptsExhausted, bl5, pNOperationType, pubNubException, n, bl4, string3, string2, string, list2, list, 504, null));
                    this.disconnect();
                }
            });
            if (!this.pubnub.getConfiguration().getStartSubscriberThread()) break block2;
            Thread thread = this.consumerThread = new Thread(new SubscribeMessageWorker(this.pubnub, this.listenerManager, this.messageQueue, this.duplicationManager));
            if (thread != null) {
                thread.setName("Subscription Manager Consumer Thread");
            }
            Thread thread2 = this.consumerThread;
            if (thread2 != null) {
                thread2.start();
            }
        }
    }

    public /* synthetic */ SubscriptionManager(PubNub pubNub, StateManager stateManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            stateManager = new StateManager();
        }
        this(pubNub, stateManager);
    }

    public static final /* synthetic */ void access$performHeartbeatLoop(SubscriptionManager $this) {
        $this.performHeartbeatLoop();
    }

    public static final /* synthetic */ Timer access$getHeartbeatTimer$p(SubscriptionManager $this) {
        return $this.heartbeatTimer;
    }

    public static final /* synthetic */ void access$setHeartbeatTimer$p(SubscriptionManager $this, Timer timer) {
        $this.heartbeatTimer = timer;
    }

    public static final /* synthetic */ ReconnectionManager access$getReconnectionManager$p(SubscriptionManager $this) {
        return $this.reconnectionManager;
    }

    public static final /* synthetic */ PNStatus access$createPublicStatus(SubscriptionManager $this, PNStatus privateStatus) {
        return $this.createPublicStatus(privateStatus);
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getMessageQueue$p(SubscriptionManager $this) {
        return $this.messageQueue;
    }

    public static final /* synthetic */ void access$setMessageQueue$p(SubscriptionManager $this, LinkedBlockingQueue linkedBlockingQueue) {
        $this.messageQueue = linkedBlockingQueue;
    }

    public static final /* synthetic */ void access$startSubscribeLoop(SubscriptionManager $this, PubSubOperation ... pubSubOperations) {
        $this.startSubscribeLoop(pubSubOperations);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pubnub/api/managers/SubscriptionManager$Companion;", "", "()V", "HEARTBEAT_INTERVAL_MULTIPLIER", "", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

