/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNListFilesResult;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.server.files.ListFilesResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 !2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001!B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0014J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0014J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pubnub/api/endpoints/files/ListFiles;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/files/ListFilesResult;", "Lcom/pubnub/api/models/consumer/files/PNListFilesResult;", "channel", "", "limit", "", "next", "Lcom/pubnub/api/models/consumer/objects/PNPage$PNNext;", "pubNub", "Lcom/pubnub/api/PubNub;", "(Ljava/lang/String;Ljava/lang/Integer;Lcom/pubnub/api/models/consumer/objects/PNPage$PNNext;Lcom/pubnub/api/PubNub;)V", "Ljava/lang/Integer;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "Companion", "pubnub-kotlin"})
public final class ListFiles
extends Endpoint<ListFilesResult, PNListFilesResult> {
    private final String channel;
    private final Integer limit;
    private final PNPage.PNNext next;
    private static final String LIMIT_QUERY_PARAM = "limit";
    private static final String NEXT_PAGE_QUERY_PARAM = "next";
    private static final int DEFAULT_LIMIT = 100;
    private static final int MIN_LIMIT = 1;
    private static final int MAX_LIMIT = 100;
    public static final Companion Companion = new Companion(null);

    @Override
    protected void validateParams() throws PubNubException {
        int n;
        CharSequence charSequence = this.channel;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.limit != null && (1 > (n = this.limit.intValue()) || 100 < n)) {
            throw (Throwable)PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "Limit should be in range from 1 to 100 (both inclusive)", null, null, 0, null, 30, null);
        }
        if (this.next != null && StringsKt.isBlank((CharSequence)this.next.getPageHash())) {
            throw (Throwable)PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "Next should not be an empty string", null, null, 0, null, 30, null);
        }
    }

    @Override
    @NotNull
    protected Call<ListFilesResult> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkParameterIsNotNull(queryParams, (String)"queryParams");
        Integer n = this.limit;
        ((Map)queryParams).put(LIMIT_QUERY_PARAM, String.valueOf(n != null ? n : 100));
        if (this.next != null) {
            ((Map)queryParams).put(NEXT_PAGE_QUERY_PARAM, this.next.getPageHash());
        }
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getFilesService$pubnub_kotlin().listFiles(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNListFilesResult createResponse(@NotNull Response<ListFilesResult> input) throws PubNubException {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        ListFilesResult listFilesResult = (ListFilesResult)input.body();
        if (listFilesResult == null) {
            throw (Throwable)new PubNubException(PubNubError.INTERNAL_ERROR);
        }
        ListFilesResult listFilesResult2 = listFilesResult;
        boolean bl = false;
        boolean bl2 = false;
        ListFilesResult body = listFilesResult2;
        boolean bl3 = false;
        return new PNListFilesResult(body.getCount(), body.getNext(), body.getStatus(), body.getData());
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    public ListFiles(@NotNull String channel, @Nullable Integer limit, @Nullable PNPage.PNNext next, @NotNull PubNub pubNub) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.limit = limit;
        this.next = next;
    }

    public /* synthetic */ ListFiles(String string, Integer n, PNPage.PNNext pNNext, PubNub pubNub, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            pNNext = null;
        }
        this(string, n, pNNext, pubNub);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/pubnub/api/endpoints/files/ListFiles$Companion;", "", "()V", "DEFAULT_LIMIT", "", "LIMIT_QUERY_PARAM", "", "MAX_LIMIT", "MIN_LIMIT", "NEXT_PAGE_QUERY_PARAM", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

