/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import com.pubnub.api.models.server.files.FormField;
import com.pubnub.api.services.S3Service;
import com.pubnub.api.vendor.FileEncryptionUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import retrofit2.Call;
import retrofit2.Callback;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000212BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJB\u0010\u0012\u001a\u00020\u000228\u0010\u0013\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002J0\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001d2\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#H\u0002J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010'\u001a\u00020(H\u0016J\u001a\u0010)\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0002J\b\u0010+\u001a\u00020\u0002H\u0016J\b\u0010,\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020\u0002H\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0010\u0010/\u001a\u00020 *\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0012\u00100\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/pubnub/api/endpoints/files/UploadFile;", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "", "s3Service", "Lcom/pubnub/api/services/S3Service;", "fileName", "", "content", "", "cipherKey", "key", "Lcom/pubnub/api/models/server/files/FormField;", "formParams", "", "baseUrl", "(Lcom/pubnub/api/services/S3Service;Ljava/lang/String;[BLjava/lang/String;Lcom/pubnub/api/models/server/files/FormField;Ljava/util/List;Ljava/lang/String;)V", "call", "Lretrofit2/Call;", "async", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "createException", "Lcom/pubnub/api/PubNubException;", "response", "Lretrofit2/Response;", "createStatusResponse", "category", "Lcom/pubnub/api/enums/PNStatusCategory;", "throwable", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getMediaType", "Lokhttp3/MediaType;", "contentType", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "prepareBytes", "prepareCall", "retry", "silentCancel", "sync", "findContentType", "getCategory", "readErrorMessage", "Companion", "Factory", "pubnub-kotlin"})
public final class UploadFile
implements ExtendedRemoteAction<Unit> {
    private Call<Unit> call;
    private final S3Service s3Service;
    private final String fileName;
    private final byte[] content;
    private final String cipherKey;
    private final FormField key;
    private final List<FormField> formParams;
    private final String baseUrl;
    private static final MediaType APPLICATION_OCTET_STREAM;
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String FILE_PART_MULTIPART = "file";
    private static final Logger log;
    public static final Companion Companion;

    private final Call<Unit> prepareCall() throws PubNubException {
        MultipartBody.Builder builder;
        MultipartBody.Builder builder2 = builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        UploadFile.Companion.addFormParamsWithKeyFirst(this.key, this.formParams, builder2);
        MediaType mediaType = this.getMediaType(this.findContentType(this.formParams));
        byte[] bytes = this.prepareBytes(this.content, this.cipherKey);
        builder.addFormDataPart(FILE_PART_MULTIPART, this.fileName, RequestBody.create((MediaType)mediaType, (byte[])bytes));
        MultipartBody multipartBody = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)multipartBody, (String)"builder.build()");
        return this.s3Service.upload(this.baseUrl, multipartBody);
    }

    private final byte[] prepareBytes(byte[] content, String cipherKey) {
        return cipherKey == null ? content : FileEncryptionUtil.INSTANCE.encryptToBytes$pubnub_kotlin(content, cipherKey);
    }

    private final String findContentType(@NotNull List<FormField> $this$findContentType) {
        Object v0;
        block1: {
            Iterable iterable = $this$findContentType;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FormField $dstr$key$_u24__u24 = (FormField)t;
                boolean bl3 = false;
                String key = $dstr$key$_u24__u24.component1();
                if (!StringsKt.equals((String)key, (String)CONTENT_TYPE_HEADER, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        FormField formField = v0;
        return formField != null ? formField.getValue() : null;
    }

    private final MediaType getMediaType(String contentType) {
        MediaType mediaType;
        if (contentType == null) {
            MediaType mediaType2 = APPLICATION_OCTET_STREAM;
            mediaType = mediaType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)mediaType2, (String)"APPLICATION_OCTET_STREAM");
        } else {
            MediaType mediaType3;
            try {
                mediaType3 = MediaType.get((String)contentType);
            }
            catch (Throwable t) {
                log.warn("Content-Type: " + contentType + " was not recognized by MediaType.get", t);
                mediaType3 = APPLICATION_OCTET_STREAM;
            }
            MediaType mediaType4 = mediaType3;
            mediaType = mediaType4;
            Intrinsics.checkExpressionValueIsNotNull((Object)mediaType4, (String)"try {\n            MediaT\u2026ON_OCTET_STREAM\n        }");
        }
        return mediaType;
    }

    @Override
    public void sync() throws PubNubException {
        retrofit2.Response serverResponse;
        retrofit2.Response response;
        this.call = this.prepareCall();
        try {
            Call<Unit> call = this.call;
            if (call == null) {
                Intrinsics.throwNpe();
            }
            response = call.execute();
        }
        catch (IOException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            int n = 0;
            String string = null;
            Call<Unit> call = this.call;
            throw (Throwable)new PubNubException(e.getMessage(), pubNubError, string, n, call, 12, null);
        }
        retrofit2.Response response2 = serverResponse = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"serverResponse");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.createException((retrofit2.Response<Unit>)serverResponse);
        }
    }

    @Override
    public void async(@NotNull Function2<? super Unit, ? super PNStatus, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Call<Unit> call = this.call = this.prepareCall();
            if (call == null) {
                Intrinsics.throwNpe();
            }
            call.enqueue((Callback)new Callback<Unit>(this, callback){
                final /* synthetic */ UploadFile this$0;
                final /* synthetic */ Function2 $callback;

                public void onResponse(@NotNull Call<Unit> performedCall, @NotNull retrofit2.Response<Unit> response) {
                    Intrinsics.checkParameterIsNotNull(performedCall, (String)"performedCall");
                    Intrinsics.checkParameterIsNotNull(response, (String)"response");
                    if (!response.isSuccessful()) {
                        PubNubException ex = UploadFile.access$createException(this.this$0, response);
                        PNStatusCategory pnStatusCategory = UploadFile.access$getCategory(this.this$0, response);
                        this.$callback.invoke(null, (Object)UploadFile.access$createStatusResponse(this.this$0, pnStatusCategory, response, ex));
                        return;
                    }
                    this.$callback.invoke((Object)Unit.INSTANCE, (Object)UploadFile.access$createStatusResponse(this.this$0, PNStatusCategory.PNAcknowledgmentCategory, response, null));
                }

                /*
                 * WARNING - void declaration
                 */
                public void onFailure(@NotNull Call<Unit> performedCall, @NotNull Throwable throwable) {
                    void statusCategory;
                    Intrinsics.checkParameterIsNotNull(performedCall, (String)"performedCall");
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                    Call call = UploadFile.access$getCall$p(this.this$0);
                    if (call == null) {
                        Intrinsics.throwNpe();
                    }
                    if (call.isCanceled()) {
                        return;
                    }
                    Throwable throwable2 = throwable;
                    Pair pair = throwable2 instanceof UnknownHostException ? TuplesKt.to((Object)((Object)PNStatusCategory.PNUnexpectedDisconnectCategory), (Object)((Object)PubNubError.CONNECTION_NOT_SET)) : (throwable2 instanceof SocketException || throwable2 instanceof SSLException ? TuplesKt.to((Object)((Object)PNStatusCategory.PNUnexpectedDisconnectCategory), (Object)((Object)PubNubError.CONNECT_EXCEPTION)) : (throwable2 instanceof SocketTimeoutException ? TuplesKt.to((Object)((Object)PNStatusCategory.PNTimeoutCategory), (Object)((Object)PubNubError.SUBSCRIBE_TIMEOUT)) : (performedCall.isCanceled() ? TuplesKt.to((Object)((Object)PNStatusCategory.PNCancelledCategory), (Object)((Object)PubNubError.HTTP_ERROR)) : TuplesKt.to((Object)((Object)PNStatusCategory.PNBadRequestCategory), (Object)((Object)PubNubError.HTTP_ERROR)))));
                    PNStatusCategory pNStatusCategory = (PNStatusCategory)((Object)pair.component1());
                    PubNubError error = (PubNubError)((Object)pair.component2());
                    PubNubException pubNubException = new PubNubException(error);
                    String string = throwable.getMessage();
                    if (string == null) {
                        string = error.getMessage();
                    }
                    this.$callback.invoke(null, (Object)UploadFile.access$createStatusResponse(this.this$0, (PNStatusCategory)statusCategory, null, PubNubException.copy$default(pubNubException, string, null, null, 0, null, 30, null)));
                }
                {
                    this.this$0 = $outer;
                    this.$callback = $captured_local_variable$1;
                }
            });
        }
        catch (IOException e) {
            callback.invoke(null, (Object)this.createStatusResponse(PNStatusCategory.PNUnknownCategory, null, e));
        }
        catch (PubNubException e) {
            callback.invoke(null, (Object)this.createStatusResponse(PNStatusCategory.PNUnknownCategory, null, e));
        }
    }

    private final PNStatusCategory getCategory(@NotNull retrofit2.Response<?> $this$getCategory) {
        PNStatusCategory pNStatusCategory;
        switch ($this$getCategory.code()) {
            case 401: 
            case 403: {
                pNStatusCategory = PNStatusCategory.PNAccessDeniedCategory;
                break;
            }
            case 400: {
                pNStatusCategory = PNStatusCategory.PNBadRequestCategory;
                break;
            }
            default: {
                pNStatusCategory = PNStatusCategory.PNUnknownCategory;
            }
        }
        return pNStatusCategory;
    }

    @Override
    public void retry() {
    }

    @Override
    public void silentCancel() {
        Call<Unit> call = this.call;
        if (call == null) {
            Intrinsics.throwNpe();
        }
        if (!call.isCanceled()) {
            Call<Unit> call2 = this.call;
            if (call2 == null) {
                Intrinsics.throwNpe();
            }
            call2.cancel();
        }
    }

    private final PubNubException createException(retrofit2.Response<Unit> response) {
        PubNubException pubNubException;
        try {
            int n = response.code();
            Call<Unit> call = this.call;
            pubNubException = new PubNubException(this.readErrorMessage(response), null, null, n, call, 6, null);
        }
        catch (Exception e) {
            int n = response.code();
            Call<Unit> call = this.call;
            pubNubException = new PubNubException(e.getMessage(), null, null, n, call, 6, null);
        }
        return pubNubException;
    }

    private final String readErrorMessage(@NotNull retrofit2.Response<Unit> $this$readErrorMessage) {
        Document doc;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        ResponseBody responseBody = $this$readErrorMessage.errorBody();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Document document = doc = dBuilder.parse(responseBody.byteStream());
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
        document.getDocumentElement().normalize();
        NodeList elements = doc.getElementsByTagName("Message");
        Object object = elements.item(0);
        if (object == null || (object = object.getFirstChild()) == null || (object = object.getNodeValue()) == null) {
            object = "N/A";
        }
        return object;
    }

    private final PNStatus createStatusResponse(PNStatusCategory category, retrofit2.Response<Unit> response, Exception throwable) {
        Response response2 = response;
        PNStatus pNStatus = null;
        List list = null;
        String string = null;
        String string2 = null;
        boolean bl = response == null || throwable != null;
        Response response3 = response;
        String string3 = response3 != null && (response3 = response3.raw()) != null && (response3 = response3.request()) != null && (response3 = response3.url()) != null ? response3.host() : null;
        Response response4 = response;
        Boolean bl2 = response4 != null && (response4 = response4.raw()) != null && (response4 = response4.request()) != null && (response4 = response4.url()) != null ? Boolean.valueOf(response4.isHttps()) : null;
        PubNubException pubNubException = null;
        Integer n = response2 != null ? Integer.valueOf(response2.code()) : null;
        PNOperationType pNOperationType = this.operationType();
        pNStatus = new PNStatus(category, bl, pNOperationType, pubNubException, n, bl2, string3, string2, string, list, (List)((Object)pNStatus), 1928, null);
        boolean bl3 = false;
        boolean bl4 = false;
        PNStatus $this$apply = pNStatus;
        boolean bl5 = false;
        $this$apply.setExecutedEndpoint$pubnub_kotlin(this);
        return pNStatus;
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    public UploadFile(@NotNull S3Service s3Service, @NotNull String fileName, @NotNull byte[] content, @Nullable String cipherKey, @NotNull FormField key, @NotNull List<FormField> formParams, @NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)s3Service, (String)"s3Service");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(formParams, (String)"formParams");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        this.s3Service = s3Service;
        this.fileName = fileName;
        this.content = content;
        this.cipherKey = cipherKey;
        this.key = key;
        this.formParams = formParams;
        this.baseUrl = baseUrl;
    }

    static {
        Companion = new Companion(null);
        APPLICATION_OCTET_STREAM = MediaType.get((String)"application/octet-stream");
        log = LoggerFactory.getLogger(UploadFile.class);
    }

    public static final /* synthetic */ PubNubException access$createException(UploadFile $this, retrofit2.Response response) {
        return $this.createException((retrofit2.Response<Unit>)response);
    }

    public static final /* synthetic */ PNStatusCategory access$getCategory(UploadFile $this, retrofit2.Response $this$access_u24getCategory) {
        return $this.getCategory($this$access_u24getCategory);
    }

    public static final /* synthetic */ PNStatus access$createStatusResponse(UploadFile $this, PNStatusCategory category, retrofit2.Response response, Exception throwable) {
        return $this.createStatusResponse(category, (retrofit2.Response<Unit>)response, throwable);
    }

    public static final /* synthetic */ Call access$getCall$p(UploadFile $this) {
        return $this.call;
    }

    public static final /* synthetic */ void access$setCall$p(UploadFile $this, Call call) {
        $this.call = call;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/api/endpoints/files/UploadFile$Factory;", "", "pubNub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "", "fileName", "", "content", "", "cipherKey", "fileUploadRequestDetails", "Lcom/pubnub/api/models/server/files/FileUploadRequestDetails;", "pubnub-kotlin"})
    public static final class Factory {
        private final PubNub pubNub;

        @NotNull
        public final ExtendedRemoteAction<Unit> create(@NotNull String fileName, @NotNull byte[] content, @Nullable String cipherKey, @NotNull FileUploadRequestDetails fileUploadRequestDetails) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)fileUploadRequestDetails, (String)"fileUploadRequestDetails");
            String effectiveCipherKey = FileEncryptionUtil.INSTANCE.effectiveCipherKey$pubnub_kotlin(this.pubNub, cipherKey);
            return new UploadFile(this.pubNub.getRetrofitManager$pubnub_kotlin().getS3Service$pubnub_kotlin(), fileName, content, effectiveCipherKey, fileUploadRequestDetails.getKeyFormField(), fileUploadRequestDetails.getFormFields(), fileUploadRequestDetails.getUrl());
        }

        public Factory(@NotNull PubNub pubNub) {
            Intrinsics.checkParameterIsNotNull((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/api/endpoints/files/UploadFile$Companion;", "", "()V", "APPLICATION_OCTET_STREAM", "Lokhttp3/MediaType;", "kotlin.jvm.PlatformType", "CONTENT_TYPE_HEADER", "", "FILE_PART_MULTIPART", "log", "Lorg/slf4j/Logger;", "addFormParamsWithKeyFirst", "", "keyValue", "Lcom/pubnub/api/models/server/files/FormField;", "formParams", "", "builder", "Lokhttp3/MultipartBody$Builder;", "pubnub-kotlin"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final void addFormParamsWithKeyFirst(FormField keyValue, List<FormField> formParams, MultipartBody.Builder builder) {
            void $this$filterTo$iv$iv;
            builder.addFormDataPart(keyValue.getKey(), keyValue.getValue());
            Iterable $this$filter$iv = formParams;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FormField it = (FormField)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getKey(), (Object)keyValue.getKey()) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormField it = (FormField)element$iv;
                boolean bl = false;
                builder.addFormDataPart(it.getKey(), it.getValue());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

