/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.models.server.Envelope;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B5\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0018H\u0014J(\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001a2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0013H\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/pubnub/api/endpoints/presence/GetState;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNGetStateResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "channelGroups", "uuid", "(Lcom/pubnub/api/PubNub;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getChannelGroups", "()Ljava/util/List;", "getChannels", "getUuid", "()Ljava/lang/String;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNGetState;", "validateParams", "pubnub-kotlin"})
public final class GetState
extends Endpoint<Envelope<JsonElement>, PNGetStateResult> {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final String uuid;

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty() && this.channelGroups.isEmpty()) {
            throw (Throwable)new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkParameterIsNotNull(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getPresenceService$pubnub_kotlin().getState(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), this.uuid, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNGetStateResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        boolean bl = false;
        HashMap stateMappings = new HashMap();
        if (this.channels.size() == 1 && this.channelGroups.isEmpty()) {
            Map map = stateMappings;
            Object object = CollectionsKt.first(this.channels);
            Object object2 = input.body();
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            Object t = ((Envelope)object2).getPayload$pubnub_kotlin();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            map.put(object, t);
        } else {
            MapperManager mapperManager = this.getPubnub().getMapper();
            Object object = input.body();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object t = ((Envelope)object).getPayload$pubnub_kotlin();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator((JsonElement)t);
            while (it.hasNext()) {
                Map.Entry<String, JsonElement> stateMapping = it.next();
                Map map = stateMappings;
                String string = stateMapping.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stateMapping.key");
                JsonElement jsonElement = stateMapping.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"stateMapping.value");
                map.put(string, jsonElement);
            }
        }
        return new PNGetStateResult(stateMappings);
    }

    @Override
    @NotNull
    public PNOperationType.PNGetState operationType() {
        return PNOperationType.PNGetState.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        Collection collection = this.channelGroups;
        boolean bl = false;
        if (!collection.isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.channelGroups));
        }
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    public GetState(@NotNull PubNub pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
        Intrinsics.checkParameterIsNotNull(channels, (String)"channels");
        Intrinsics.checkParameterIsNotNull(channelGroups, (String)"channelGroups");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuid = uuid;
    }

    public /* synthetic */ GetState(PubNub pubNub, List list, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = pubNub.getConfiguration().getUuid();
        }
        this(pubNub, list, list2, string);
    }
}

