/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.PNTimeResult;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0015\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/pubnub/api/managers/ReconnectionManager;", "", "pubnub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "exponentialMultiplier", "", "failedCalls", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxConnectionRetries", "pnReconnectionPolicy", "Lcom/pubnub/api/enums/PNReconnectionPolicy;", "getPubnub", "()Lcom/pubnub/api/PubNub;", "reconnectionCallback", "Lcom/pubnub/api/callbacks/ReconnectionCallback;", "getReconnectionCallback$pubnub_kotlin", "()Lcom/pubnub/api/callbacks/ReconnectionCallback;", "setReconnectionCallback$pubnub_kotlin", "(Lcom/pubnub/api/callbacks/ReconnectionCallback;)V", "timer", "Ljava/util/Timer;", "callTime", "", "getBestInterval", "isReconnectionPolicyUndefined", "", "registerHeartbeatTimer", "startPolling", "pnConfiguration", "Lcom/pubnub/api/PNConfiguration;", "startPolling$pubnub_kotlin", "stopHeartbeatTimer", "Companion", "pubnub-kotlin"})
public final class ReconnectionManager {
    private final Logger log;
    @NotNull
    public ReconnectionCallback reconnectionCallback;
    private int exponentialMultiplier;
    private int failedCalls;
    private PNReconnectionPolicy pnReconnectionPolicy;
    private int maxConnectionRetries;
    private Timer timer;
    @NotNull
    private final PubNub pubnub;
    private static final int LINEAR_INTERVAL = 3;
    private static final int MIN_EXPONENTIAL_BACKOFF = 1;
    private static final int MAX_EXPONENTIAL_BACKOFF = 32;
    private static final int MILLISECONDS = 1000;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ReconnectionCallback getReconnectionCallback$pubnub_kotlin() {
        ReconnectionCallback reconnectionCallback = this.reconnectionCallback;
        if (reconnectionCallback == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reconnectionCallback");
        }
        return reconnectionCallback;
    }

    public final void setReconnectionCallback$pubnub_kotlin(@NotNull ReconnectionCallback reconnectionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)reconnectionCallback, (String)"<set-?>");
        this.reconnectionCallback = reconnectionCallback;
    }

    public final void startPolling$pubnub_kotlin(@NotNull PNConfiguration pnConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)pnConfiguration, (String)"pnConfiguration");
        this.pnReconnectionPolicy = pnConfiguration.getReconnectionPolicy();
        this.maxConnectionRetries = pnConfiguration.getMaximumReconnectionRetries();
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        this.exponentialMultiplier = 1;
        this.failedCalls = 0;
        this.registerHeartbeatTimer();
    }

    private final void registerHeartbeatTimer() {
        block3: {
            this.stopHeartbeatTimer();
            if (this.isReconnectionPolicyUndefined()) {
                return;
            }
            if (this.maxConnectionRetries != -1 && this.failedCalls >= this.maxConnectionRetries) {
                ReconnectionCallback reconnectionCallback = this.reconnectionCallback;
                if (reconnectionCallback == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"reconnectionCallback");
                }
                reconnectionCallback.onMaxReconnectionExhaustion();
                return;
            }
            Timer timer = this.timer = new Timer("Reconnection Manager timer", true);
            if (timer == null) break block3;
            timer.schedule(new TimerTask(this){
                final /* synthetic */ ReconnectionManager this$0;

                public void run() {
                    ReconnectionManager.access$callTime(this.this$0);
                }
                {
                    this.this$0 = $outer;
                }
            }, (long)this.getBestInterval() * (long)1000);
        }
    }

    private final int getBestInterval() {
        int timerInterval = 3;
        PNReconnectionPolicy pNReconnectionPolicy = this.pnReconnectionPolicy;
        if (pNReconnectionPolicy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pnReconnectionPolicy");
        }
        if (pNReconnectionPolicy == PNReconnectionPolicy.EXPONENTIAL) {
            double d = 2.0;
            double d2 = this.exponentialMultiplier;
            boolean bl = false;
            timerInterval = (int)(Math.pow(d, d2) - 1.0);
            if (timerInterval > 32) {
                timerInterval = 1;
                this.exponentialMultiplier = 1;
                StringBuilder stringBuilder = new StringBuilder().append("timerInterval > MAXEXPONENTIALBACKOFF at: ");
                Calendar calendar = Calendar.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
                this.log.info(stringBuilder.append(calendar.getTime().toString()).toString());
            } else if (timerInterval < 1) {
                timerInterval = 1;
            }
            StringBuilder stringBuilder = new StringBuilder().append("timerInterval = ").append(timerInterval).append(" at: ");
            Calendar calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
            this.log.info(stringBuilder.append(calendar.getTime().toString()).toString());
        }
        PNReconnectionPolicy pNReconnectionPolicy2 = this.pnReconnectionPolicy;
        if (pNReconnectionPolicy2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pnReconnectionPolicy");
        }
        if (pNReconnectionPolicy2 == PNReconnectionPolicy.LINEAR) {
            timerInterval = 3;
        }
        return timerInterval;
    }

    private final void stopHeartbeatTimer() {
        block0: {
            Timer timer = this.timer;
            if (timer == null) break block0;
            timer.cancel();
        }
    }

    private final void callTime() {
        this.pubnub.time().async((Function2)new Function2<PNTimeResult, PNStatus, Unit>(this){
            final /* synthetic */ ReconnectionManager this$0;

            public final void invoke(@Nullable PNTimeResult $noName_0, @NotNull PNStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                if (!status.getError()) {
                    ReconnectionManager.access$stopHeartbeatTimer(this.this$0);
                    this.this$0.getReconnectionCallback$pubnub_kotlin().onReconnection();
                } else {
                    ReconnectionManager.access$getLog$p(this.this$0).info("callTime at " + System.currentTimeMillis());
                    ReconnectionManager reconnectionManager = this.this$0;
                    int n = ReconnectionManager.access$getExponentialMultiplier$p(reconnectionManager);
                    ReconnectionManager.access$setExponentialMultiplier$p(reconnectionManager, n + 1);
                    ReconnectionManager reconnectionManager2 = this.this$0;
                    n = ReconnectionManager.access$getFailedCalls$p(reconnectionManager2);
                    ReconnectionManager.access$setFailedCalls$p(reconnectionManager2, n + 1);
                    ReconnectionManager.access$registerHeartbeatTimer(this.this$0);
                }
            }
            {
                this.this$0 = reconnectionManager;
                super(2);
            }
        });
    }

    private final boolean isReconnectionPolicyUndefined() {
        PNReconnectionPolicy pNReconnectionPolicy = this.pnReconnectionPolicy;
        if (pNReconnectionPolicy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pnReconnectionPolicy");
        }
        if (pNReconnectionPolicy == PNReconnectionPolicy.NONE) {
            this.log.info("reconnection policy is disabled, please handle reconnection manually.");
            return true;
        }
        return false;
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    public ReconnectionManager(@NotNull PubNub pubnub) {
        Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
        this.pubnub = pubnub;
        this.log = LoggerFactory.getLogger((String)"ReconnectionManager");
        this.exponentialMultiplier = 1;
        this.maxConnectionRetries = -1;
    }

    public static final /* synthetic */ void access$callTime(ReconnectionManager $this) {
        $this.callTime();
    }

    public static final /* synthetic */ void access$stopHeartbeatTimer(ReconnectionManager $this) {
        $this.stopHeartbeatTimer();
    }

    public static final /* synthetic */ Logger access$getLog$p(ReconnectionManager $this) {
        return $this.log;
    }

    public static final /* synthetic */ int access$getExponentialMultiplier$p(ReconnectionManager $this) {
        return $this.exponentialMultiplier;
    }

    public static final /* synthetic */ void access$setExponentialMultiplier$p(ReconnectionManager $this, int n) {
        $this.exponentialMultiplier = n;
    }

    public static final /* synthetic */ int access$getFailedCalls$p(ReconnectionManager $this) {
        return $this.failedCalls;
    }

    public static final /* synthetic */ void access$setFailedCalls$p(ReconnectionManager $this, int n) {
        $this.failedCalls = n;
    }

    public static final /* synthetic */ void access$registerHeartbeatTimer(ReconnectionManager $this) {
        $this.registerHeartbeatTimer();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/pubnub/api/managers/ReconnectionManager$Companion;", "", "()V", "LINEAR_INTERVAL", "", "MAX_EXPONENTIAL_BACKOFF", "MILLISECONDS", "MIN_EXPONENTIAL_BACKOFF", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

