/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNDownloadableFile;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.models.consumer.pubsub.BasePubSubResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.PubSubResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.ObjectPayload;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventMessage;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.api.models.server.PresenceEnvelope;
import com.pubnub.api.models.server.PublishMetaData;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.models.server.files.FileUploadNotification;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J*\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010,\u001a\u00020\bH\u0002J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcom/pubnub/api/workers/SubscribeMessageWorker;", "Ljava/lang/Runnable;", "pubnub", "Lcom/pubnub/api/PubNub;", "listenerManager", "Lcom/pubnub/api/managers/ListenerManager;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pubnub/api/models/server/SubscribeMessage;", "duplicationManager", "Lcom/pubnub/api/managers/DuplicationManager;", "(Lcom/pubnub/api/PubNub;Lcom/pubnub/api/managers/ListenerManager;Ljava/util/concurrent/LinkedBlockingQueue;Lcom/pubnub/api/managers/DuplicationManager;)V", "getDuplicationManager", "()Lcom/pubnub/api/managers/DuplicationManager;", "formatFriendlyGetFileUrl", "", "getListenerManager", "()Lcom/pubnub/api/managers/ListenerManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPubnub", "()Lcom/pubnub/api/PubNub;", "getQueue", "()Ljava/util/concurrent/LinkedBlockingQueue;", "buildFileUrl", "channel", "fileId", "fileName", "generateSignature", "configuration", "Lcom/pubnub/api/PNConfiguration;", "url", "authKey", "timestamp", "", "getDelta", "", "delta", "Lcom/google/gson/JsonElement;", "processIncomingPayload", "", "message", "processMessage", "subscribeMessage", "run", "takeMessage", "Companion", "pubnub-kotlin"})
public final class SubscribeMessageWorker
implements Runnable {
    private final Logger log;
    private final String formatFriendlyGetFileUrl;
    @NotNull
    private final PubNub pubnub;
    @NotNull
    private final ListenerManager listenerManager;
    @NotNull
    private final LinkedBlockingQueue<SubscribeMessage> queue;
    @NotNull
    private final DuplicationManager duplicationManager;
    public static final int TYPE_MESSAGE = 0;
    public static final int TYPE_SIGNAL = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_MESSAGE_ACTION = 3;
    public static final int TYPE_FILES = 4;
    public static final Companion Companion = new Companion(null);

    @Override
    public void run() {
        this.takeMessage();
    }

    private final void takeMessage() {
        while (!Thread.interrupted()) {
            try {
                SubscribeMessage subscribeMessage = this.queue.take();
                Intrinsics.checkExpressionValueIsNotNull((Object)subscribeMessage, (String)"queue.take()");
                this.processIncomingPayload(subscribeMessage);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.trace("take message interrupted!", (Throwable)e);
            }
        }
    }

    private final void processIncomingPayload(SubscribeMessage message) {
        block12: {
            Integer n;
            BasePubSubResult result;
            JsonElement extractedMessage;
            block17: {
                int isHereNowRefresh2;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                PublishMetaData publishMetaData;
                                String subscriptionMatch;
                                String channel;
                                block11: {
                                    JsonElement jsonElement;
                                    JsonElement jsonElement2;
                                    JsonElement jsonElement3;
                                    String string;
                                    if (message.getChannel$pubnub_kotlin() == null) {
                                        return;
                                    }
                                    channel = message.getChannel$pubnub_kotlin();
                                    subscriptionMatch = message.getSubscriptionMatch$pubnub_kotlin();
                                    publishMetaData = message.getPublishMetaData$pubnub_kotlin();
                                    if (Intrinsics.areEqual((Object)channel, (Object)subscriptionMatch)) {
                                        subscriptionMatch = null;
                                    }
                                    if (this.pubnub.getConfiguration().getDedupOnSubscribe()) {
                                        if (this.duplicationManager.isDuplicate(message)) {
                                            return;
                                        }
                                        this.duplicationManager.addEntry(message);
                                    }
                                    if (!StringsKt.endsWith$default((String)message.getChannel$pubnub_kotlin(), (String)"-pnpres", (boolean)false, (int)2, null)) break block11;
                                    PresenceEnvelope presencePayload = this.pubnub.getMapper().convertValue(message.getPayload$pubnub_kotlin(), PresenceEnvelope.class);
                                    String strippedPresenceChannel = PubNubUtil.INSTANCE.replaceLast(channel, "-pnpres", "");
                                    String string2 = subscriptionMatch;
                                    if (string2 != null) {
                                        String string3 = string2;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        String it = string3;
                                        boolean bl3 = false;
                                        string = PubNubUtil.INSTANCE.replaceLast(it, "-pnpres", "");
                                    } else {
                                        string = null;
                                    }
                                    String strippedPresenceSubscription = string;
                                    JsonElement jsonElement4 = message.getPayload$pubnub_kotlin();
                                    JsonElement isHereNowRefresh2 = jsonElement4 != null && (jsonElement4 = jsonElement4.getAsJsonObject()) != null ? jsonElement4.get("here_now_refresh") : null;
                                    PublishMetaData publishMetaData2 = publishMetaData;
                                    this.listenerManager.announce(new PNPresenceEventResult(presencePayload.getAction$pubnub_kotlin(), presencePayload.getUuid$pubnub_kotlin(), presencePayload.getTimestamp$pubnub_kotlin(), presencePayload.getOccupancy$pubnub_kotlin(), presencePayload.getData$pubnub_kotlin(), strippedPresenceChannel, strippedPresenceSubscription, publishMetaData2 != null ? publishMetaData2.getPublishTimetoken$pubnub_kotlin() : null, this.getDelta((jsonElement3 = message.getPayload$pubnub_kotlin()) != null && (jsonElement3 = jsonElement3.getAsJsonObject()) != null ? jsonElement3.get("join") : null), this.getDelta((jsonElement2 = message.getPayload$pubnub_kotlin()) != null && (jsonElement2 = jsonElement2.getAsJsonObject()) != null ? jsonElement2.get("leave") : null), this.getDelta((jsonElement = message.getPayload$pubnub_kotlin()) != null && (jsonElement = jsonElement.getAsJsonObject()) != null ? jsonElement.get("timeout") : null), isHereNowRefresh2 != null && isHereNowRefresh2.getAsBoolean(), null, 4096, null));
                                    break block12;
                                }
                                extractedMessage = this.processMessage(message);
                                if (extractedMessage == null) {
                                    this.log.debug("unable to parse payload on #processIncomingMessages");
                                }
                                PublishMetaData publishMetaData3 = publishMetaData;
                                result = new BasePubSubResult(channel, subscriptionMatch, publishMetaData3 != null ? publishMetaData3.getPublishTimetoken$pubnub_kotlin() : null, message.getUserMetadata$pubnub_kotlin(), message.getIssuingClientId$pubnub_kotlin());
                                n = message.getType$pubnub_kotlin();
                                if (n != null) break block13;
                                PubSubResult pubSubResult = result;
                                JsonElement jsonElement = extractedMessage;
                                if (jsonElement == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.listenerManager.announce(new PNMessageResult(pubSubResult, jsonElement));
                                break block12;
                            }
                            isHereNowRefresh2 = 0;
                            if (n != 0) break block14;
                            PubSubResult pubSubResult = result;
                            JsonElement jsonElement = extractedMessage;
                            if (jsonElement == null) {
                                Intrinsics.throwNpe();
                            }
                            this.listenerManager.announce(new PNMessageResult(pubSubResult, jsonElement));
                            break block12;
                        }
                        isHereNowRefresh2 = 1;
                        if (n != isHereNowRefresh2) break block15;
                        PubSubResult pubSubResult = result;
                        JsonElement jsonElement = extractedMessage;
                        if (jsonElement == null) {
                            Intrinsics.throwNpe();
                        }
                        this.listenerManager.announce(new PNSignalResult(pubSubResult, jsonElement));
                        break block12;
                    }
                    isHereNowRefresh2 = 2;
                    if (n != isHereNowRefresh2) break block16;
                    this.listenerManager.announce(new PNObjectEventResult(result, this.pubnub.getMapper().convertValue(extractedMessage, PNObjectEventMessage.class)));
                    break block12;
                }
                isHereNowRefresh2 = 3;
                if (n != isHereNowRefresh2) break block17;
                ObjectPayload objectPayload = this.pubnub.getMapper().convertValue(extractedMessage, ObjectPayload.class);
                JsonObject data = objectPayload.getData().getAsJsonObject();
                if (!data.has("uuid")) {
                    data.addProperty("uuid", result.getPublisher());
                }
                this.listenerManager.announce(new PNMessageActionResult(result, objectPayload.getEvent(), this.pubnub.getMapper().convertValue((JsonElement)data, PNMessageAction.class)));
                break block12;
            }
            int objectPayload = 4;
            if (n != objectPayload) break block12;
            FileUploadNotification fileUploadNotification = this.pubnub.getMapper().convertValue(extractedMessage, FileUploadNotification.class);
            Long l = result.getTimetoken();
            String string = message.getIssuingClientId$pubnub_kotlin();
            PNDownloadableFile pNDownloadableFile = new PNDownloadableFile(fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName(), this.buildFileUrl(message.getChannel$pubnub_kotlin(), fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName()));
            Object object = fileUploadNotification.getMessage();
            this.listenerManager.announce(new PNFileEventResult(message.getChannel$pubnub_kotlin(), l, string, object, pNDownloadableFile));
        }
    }

    private final String buildFileUrl(String channel, String fileId, String fileName) {
        ArrayList<String> queryParams;
        String basePath;
        block1: {
            String authKey;
            String string = String.format(this.formatFriendlyGetFileUrl, this.pubnub.baseUrl$pubnub_kotlin(), this.pubnub.getConfiguration().getSubscribeKey(), channel, fileId, fileName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026       fileName\n        )");
            basePath = string;
            queryParams = new ArrayList<String>();
            String string2 = authKey = this.pubnub.getConfiguration().isAuthKeyValid$pubnub_kotlin() ? this.pubnub.getConfiguration().getAuthKey() : null;
            if (PubNubUtil.INSTANCE.shouldSignRequest(this.pubnub.getConfiguration())) {
                int timestamp = this.pubnub.timestamp$pubnub_kotlin();
                String signature = this.generateSignature(this.pubnub.getConfiguration(), basePath, authKey, timestamp);
                queryParams.add("timestamp=" + timestamp);
                queryParams.add("signature=" + signature);
            }
            String string3 = authKey;
            if (string3 == null) break block1;
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String $this$run = string4;
            boolean bl3 = false;
            queryParams.add("auth=" + authKey);
        }
        return queryParams.isEmpty() ? basePath : basePath + '?' + CollectionsKt.joinToString$default((Iterable)queryParams, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    private final String generateSignature(PNConfiguration configuration, String url, String authKey, int timestamp) {
        boolean bl = false;
        Map queryParams = new LinkedHashMap();
        if (authKey != null) {
            queryParams.put("auth", authKey);
        }
        return PubNubUtil.INSTANCE.generateSignature(configuration, url, queryParams, "get", null, timestamp);
    }

    private final JsonElement processMessage(SubscribeMessage subscribeMessage) {
        JsonElement e2;
        String string;
        JsonElement input = subscribeMessage.getPayload$pubnub_kotlin();
        if (!this.pubnub.getConfiguration().isCipherKeyValid$pubnub_kotlin()) {
            return input;
        }
        if (!subscribeMessage.supportsEncryption()) {
            return input;
        }
        Crypto crypto = new Crypto(this.pubnub.getConfiguration().getCipherKey(), this.pubnub.getConfiguration().getUseRandomInitializationVector());
        MapperManager mapperManager = this.pubnub.getMapper();
        JsonElement jsonElement = input;
        if (jsonElement == null) {
            Intrinsics.throwNpe();
        }
        String inputText = mapperManager.isJsonObject(jsonElement) && this.pubnub.getMapper().hasField(input, "pn_other") ? this.pubnub.getMapper().elementToString(input, "pn_other") : this.pubnub.getMapper().elementToString(input);
        try {
            String string2 = inputText;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = crypto.decrypt(string2);
        }
        catch (PubNubException e2) {
            PNStatus pnStatus = new PNStatus(PNStatusCategory.PNMalformedResponseCategory, true, PNOperationType.PNSubscribeOperation.INSTANCE, e2, null, null, null, null, null, null, null, 2032, null);
            this.listenerManager.announce(pnStatus);
            return null;
        }
        String outputText = string;
        try {
            e2 = this.pubnub.getMapper().fromJson(outputText, JsonElement.class);
        }
        catch (PubNubException e3) {
            PNStatus pnStatus = new PNStatus(PNStatusCategory.PNMalformedResponseCategory, true, PNOperationType.PNSubscribeOperation.INSTANCE, e3, null, null, null, null, null, null, null, 2032, null);
            this.listenerManager.announce(pnStatus);
            return null;
        }
        JsonElement outputObject = e2;
        if (this.pubnub.getMapper().isJsonObject(input) && this.pubnub.getMapper().hasField(input, "pn_other")) {
            JsonObject objectNode = this.pubnub.getMapper().getAsObject(input);
            MapperManager mapperManager2 = this.pubnub.getMapper();
            JsonObject jsonObject = objectNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"objectNode");
            mapperManager2.putOnObject(jsonObject, "pn_other", outputObject);
            outputObject = (JsonElement)objectNode;
        }
        return outputObject;
    }

    private final List<String> getDelta(JsonElement delta) {
        boolean bl = false;
        List list = new ArrayList();
        JsonElement jsonElement = delta;
        if (jsonElement != null) {
            JsonElement jsonElement2 = jsonElement;
            boolean bl2 = false;
            boolean bl3 = false;
            JsonElement it = jsonElement2;
            boolean bl4 = false;
            JsonArray jsonArray = it.getAsJsonArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"it.asJsonArray");
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement item = (JsonElement)element$iv;
                boolean bl5 = false;
                if (item != null) {
                    JsonElement jsonElement3;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    JsonElement it2 = jsonElement3;
                    boolean bl8 = false;
                    String string = it2.getAsString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.asString");
                    list.add(string);
                }
            }
        }
        return list;
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    @NotNull
    public final ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    @NotNull
    public final LinkedBlockingQueue<SubscribeMessage> getQueue() {
        return this.queue;
    }

    @NotNull
    public final DuplicationManager getDuplicationManager() {
        return this.duplicationManager;
    }

    public SubscribeMessageWorker(@NotNull PubNub pubnub, @NotNull ListenerManager listenerManager, @NotNull LinkedBlockingQueue<SubscribeMessage> queue, @NotNull DuplicationManager duplicationManager) {
        Intrinsics.checkParameterIsNotNull((Object)pubnub, (String)"pubnub");
        Intrinsics.checkParameterIsNotNull((Object)listenerManager, (String)"listenerManager");
        Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
        Intrinsics.checkParameterIsNotNull((Object)duplicationManager, (String)"duplicationManager");
        this.pubnub = pubnub;
        this.listenerManager = listenerManager;
        this.queue = queue;
        this.duplicationManager = duplicationManager;
        this.log = LoggerFactory.getLogger((String)"SubscribeMessageWorker");
        CharSequence charSequence = "/v1/files/{subKey}/channels/{channel}/files/{fileId}/{fileName}";
        String string = "\\{.*?\\}";
        StringBuilder stringBuilder = new StringBuilder().append("%s");
        SubscribeMessageWorker subscribeMessageWorker = this;
        boolean bl = false;
        Object object = new Regex(string);
        string = object;
        String string2 = "%s";
        boolean bl2 = false;
        object = string.replace(charSequence, string2);
        subscribeMessageWorker.formatFriendlyGetFileUrl = stringBuilder.append((String)object).toString();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pubnub/api/workers/SubscribeMessageWorker$Companion;", "", "()V", "TYPE_FILES", "", "TYPE_MESSAGE", "TYPE_MESSAGE_ACTION", "TYPE_OBJECT", "TYPE_SIGNAL", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

