/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNBoundedPage;
import com.pubnub.api.models.consumer.history.Action;
import com.pubnub.api.models.consumer.history.PNFetchMessageItem;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.api.models.server.FetchMessagesEnvelope;
import com.pubnub.api.models.server.FetchMessagesPage;
import com.pubnub.extension.IntKt;
import com.pubnub.extension.JsonElementKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B=\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0014J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0!H\u0014J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0019H\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/pubnub/api/endpoints/FetchMessages;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/FetchMessagesEnvelope;", "Lcom/pubnub/api/models/consumer/history/PNFetchMessagesResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "page", "Lcom/pubnub/api/models/consumer/PNBoundedPage;", "includeUUID", "", "includeMeta", "includeMessageActions", "(Lcom/pubnub/api/PubNub;Ljava/util/List;Lcom/pubnub/api/models/consumer/PNBoundedPage;ZZZ)V", "getChannels", "()Ljava/util/List;", "getIncludeMessageActions", "()Z", "getIncludeMeta", "getIncludeUUID", "getPage", "()Lcom/pubnub/api/models/consumer/PNBoundedPage;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNFetchMessagesOperation;", "validateParams", "Companion", "pubnub-kotlin"})
public final class FetchMessages
extends Endpoint<FetchMessagesEnvelope, PNFetchMessagesResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> channels;
    @NotNull
    private final PNBoundedPage page;
    private final boolean includeUUID;
    private final boolean includeMeta;
    private final boolean includeMessageActions;
    private static final int SINGLE_CHANNEL_DEFAULT_MESSAGES = 100;
    private static final int SINGLE_CHANNEL_MAX_MESSAGES = 100;
    private static final int MULTIPLE_CHANNEL_DEFAULT_MESSAGES = 25;
    private static final int MULTIPLE_CHANNEL_MAX_MESSAGES = 25;
    private static final int DEFAULT_MESSAGES_WITH_ACTIONS = 25;
    private static final int MAX_MESSAGES_WITH_ACTIONS = 25;

    public FetchMessages(@NotNull PubNub pubnub, @NotNull List<String> channels, @NotNull PNBoundedPage page, boolean includeUUID, boolean includeMeta, boolean includeMessageActions) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        super(pubnub);
        this.channels = channels;
        this.page = page;
        this.includeUUID = includeUUID;
        this.includeMeta = includeMeta;
        this.includeMessageActions = includeMessageActions;
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final PNBoundedPage getPage() {
        return this.page;
    }

    public final boolean getIncludeUUID() {
        return this.includeUUID;
    }

    public final boolean getIncludeMeta() {
        return this.includeMeta;
    }

    public final boolean getIncludeMessageActions() {
        return this.includeMessageActions;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.includeMessageActions && this.channels.size() > 1) {
            throw new PubNubException(PubNubError.HISTORY_MESSAGE_ACTIONS_MULTIPLE_CHANNELS);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected Call<FetchMessagesEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return !this.includeMessageActions ? this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchMessages(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams) : this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchMessagesWithActions(this.getPubnub().getConfiguration().getSubscribeKey(), (String)CollectionsKt.first(this.channels), (Map<String, String>)queryParams);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PNFetchMessagesResult createResponse(@NotNull Response<FetchMessagesEnvelope> input) {
        PNBoundedPage pNBoundedPage;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"input.body()!!");
        FetchMessagesEnvelope body = (FetchMessagesEnvelope)object2;
        Map<String, List<PNFetchMessageItem>> $this$mapValues$iv = body.getChannels();
        boolean $i$f$mapValues = false;
        Object object3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl2 = false;
            void var19_21 = $dstr$_u24__u24$value;
            boolean bl3 = false;
            List value = (List)var19_21.getValue();
            Iterable $this$map$iv = value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map map3;
                void messageItem;
                PNFetchMessageItem pNFetchMessageItem = (PNFetchMessageItem)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                JsonElement newMessage = JsonElementKt.processHistoryMessage(messageItem.getMessage(), this.getPubnub().getConfiguration(), this.getPubnub().getMapper());
                if (this.getIncludeMessageActions()) {
                    Map<String, Map<String, List<Action>>> map4 = messageItem.getActions();
                    if (map4 == null) {
                        boolean bl5 = false;
                        map3 = MapsKt.emptyMap();
                    } else {
                        map3 = map4;
                    }
                } else {
                    map3 = messageItem.getActions();
                }
                Map newActions = map3;
                PNFetchMessageItem pNFetchMessageItem2 = PNFetchMessageItem.copy$default((PNFetchMessageItem)messageItem, null, newMessage, null, 0L, newActions, 13, null);
                collection.add(pNFetchMessageItem2);
            }
            List list = (List)destination$iv$iv2;
            map2.put(k2, list);
        }
        Map channelsMap = MapsKt.toMap((Map)destination$iv$iv);
        FetchMessagesPage fetchMessagesPage = body.getMore();
        if (fetchMessagesPage == null) {
            pNBoundedPage = null;
        } else {
            object3 = fetchMessagesPage;
            boolean bl = false;
            boolean bl6 = false;
            Object it = object3;
            boolean bl7 = false;
            pNBoundedPage = new PNBoundedPage(((FetchMessagesPage)it).getStart(), ((FetchMessagesPage)it).getEnd(), ((FetchMessagesPage)it).getMax());
        }
        PNBoundedPage page = pNBoundedPage;
        return new PNFetchMessagesResult(channelsMap, page);
    }

    @Override
    @NotNull
    public PNOperationType.PNFetchMessagesOperation operationType() {
        return PNOperationType.PNFetchMessagesOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        boolean bl;
        String string;
        boolean bl2;
        String string2;
        String string3;
        Map<String, String> map;
        Map<String, String> map2 = queryParams;
        Object object = "max";
        String string4 = String.valueOf(Companion.effectiveMax$pubnub_kotlin(this.page.getLimit(), this.includeMessageActions, this.channels.size()));
        boolean bl3 = false;
        map2.put((String)object, string4);
        map2 = queryParams;
        object = "include_uuid";
        string4 = String.valueOf(this.includeUUID);
        bl3 = false;
        map2.put((String)object, string4);
        map2 = this.page.getStart();
        if (map2 != null) {
            object = map2;
            boolean bl4 = false;
            bl3 = false;
            long $this$addQueryParams_u24lambda_u2d3 = ((Number)object).longValue();
            boolean bl5 = false;
            map = queryParams;
            string3 = "start";
            string2 = String.valueOf($this$addQueryParams_u24lambda_u2d3);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            bl2 = false;
            string = string2;
            bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            string2 = string6;
            boolean bl6 = false;
            map.put(string3, string2);
        }
        map2 = this.page.getEnd();
        if (map2 != null) {
            object = map2;
            boolean bl7 = false;
            bl3 = false;
            long $this$addQueryParams_u24lambda_u2d4 = ((Number)object).longValue();
            boolean bl8 = false;
            map = queryParams;
            string3 = "end";
            string2 = String.valueOf($this$addQueryParams_u24lambda_u2d4);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            bl2 = false;
            string = string2;
            bl = false;
            String string7 = string;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
            string2 = string8;
            boolean bl9 = false;
            map.put(string3, string2);
        }
        if (this.includeMeta) {
            map2 = queryParams;
            object = "include_meta";
            String string9 = String.valueOf(this.includeMeta);
            bl3 = false;
            map2.put((String)object, string9);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/pubnub/api/endpoints/FetchMessages$Companion;", "", "()V", "DEFAULT_MESSAGES_WITH_ACTIONS", "", "MAX_MESSAGES_WITH_ACTIONS", "MULTIPLE_CHANNEL_DEFAULT_MESSAGES", "MULTIPLE_CHANNEL_MAX_MESSAGES", "SINGLE_CHANNEL_DEFAULT_MESSAGES", "SINGLE_CHANNEL_MAX_MESSAGES", "effectiveMax", "maximumPerChannel", "includeMessageActions", "", "numberOfChannels", "effectiveMax$pubnub_kotlin", "(Ljava/lang/Integer;ZI)I", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public final int effectiveMax$pubnub_kotlin(@Nullable Integer maximumPerChannel, boolean includeMessageActions, int numberOfChannels) {
            int n;
            Integer n2;
            Integer n3;
            int n4;
            Integer n5;
            Integer n6;
            int n7;
            Integer n8;
            Integer n9;
            int n10 = includeMessageActions ? ((n9 = maximumPerChannel) == null ? 25 : ((n8 = IntKt.nonPositiveToNull(n7 = IntKt.limit(n9, 25))) == null ? 25 : n8)) : (numberOfChannels == 1 ? ((n6 = maximumPerChannel) == null ? 100 : ((n5 = IntKt.nonPositiveToNull(n4 = IntKt.limit(n6, 100))) == null ? 100 : n5)) : ((n3 = maximumPerChannel) == null ? 25 : ((n2 = IntKt.nonPositiveToNull(n = IntKt.limit(n3, 25))) == null ? 25 : n2)));
            return n10;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

