/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.history.PNHistoryItemResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.extension.JsonElementKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001.BO\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\"H\u0002J\u0016\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0014J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070(H\u0014J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*H\u0014J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020 H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/pubnub/api/endpoints/History;", "Lcom/pubnub/api/Endpoint;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNHistoryResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channel", "", "start", "", "end", "count", "", "reverse", "", "includeTimetoken", "includeMeta", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;IZZZ)V", "getChannel", "()Ljava/lang/String;", "getCount", "()I", "countParam", "getEnd", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIncludeMeta", "()Z", "getIncludeTimetoken", "getReverse", "getStart", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannels", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHistoryOperation;", "validateParams", "Companion", "pubnub-kotlin"})
public final class History
extends Endpoint<JsonElement, PNHistoryResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String channel;
    @Nullable
    private final Long start;
    @Nullable
    private final Long end;
    private final int count;
    private final boolean reverse;
    private final boolean includeTimetoken;
    private final boolean includeMeta;
    private final int countParam;
    public static final int MAX_COUNT = 100;

    public History(@NotNull PubNub pubnub, @NotNull String channel, @Nullable Long start, @Nullable Long end, int count, boolean reverse, boolean includeTimetoken, boolean includeMeta) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.channel = channel;
        this.start = start;
        this.end = end;
        this.count = count;
        this.reverse = reverse;
        this.includeTimetoken = includeTimetoken;
        this.includeMeta = includeMeta;
        int n = this.count;
        this.countParam = (1 <= n ? n <= 100 : false) ? this.count : 100;
    }

    public /* synthetic */ History(PubNub pubNub, String string, Long l, Long l2, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        this(pubNub, string, l, l2, n, bl, bl2, bl3);
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    @Nullable
    public final Long getStart() {
        return this.start;
    }

    @Nullable
    public final Long getEnd() {
        return this.end;
    }

    public final int getCount() {
        return this.count;
    }

    public final boolean getReverse() {
        return this.reverse;
    }

    public final boolean getIncludeTimetoken() {
        return this.includeTimetoken;
    }

    public final boolean getIncludeMeta() {
        return this.includeMeta;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channel)) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchHistory(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHistoryResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        MapperManager mapperManager = this.getPubnub().getMapper();
        MapperManager mapperManager2 = this.getPubnub().getMapper();
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"input.body()!!");
        JsonElement jsonElement = mapperManager2.getArrayElement((JsonElement)object2, 1);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"pubnub.mapper.getArrayElement(input.body()!!, 1)");
        long startTimeToken = mapperManager.elementToLong(jsonElement);
        MapperManager mapperManager3 = this.getPubnub().getMapper();
        MapperManager mapperManager4 = this.getPubnub().getMapper();
        Object object3 = input.body();
        Intrinsics.checkNotNull((Object)object3);
        Object object4 = object3;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"input.body()!!");
        JsonElement jsonElement2 = mapperManager4.getArrayElement((JsonElement)object4, 2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"pubnub.mapper.getArrayElement(input.body()!!, 2)");
        long endTimeToken = mapperManager3.elementToLong(jsonElement2);
        boolean bl = false;
        List messages = new ArrayList();
        PNHistoryResult historyData = new PNHistoryResult(messages, startTimeToken, endTimeToken);
        MapperManager mapperManager5 = this.getPubnub().getMapper();
        Object object5 = input.body();
        Intrinsics.checkNotNull((Object)object5);
        Object object6 = object5;
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"input.body()!!");
        if (mapperManager5.getArrayElement((JsonElement)object6, 0).isJsonArray()) {
            MapperManager mapperManager6 = this.getPubnub().getMapper();
            MapperManager mapperManager7 = this.getPubnub().getMapper();
            Object object7 = input.body();
            Intrinsics.checkNotNull((Object)object7);
            Object object8 = object7;
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"input.body()!!");
            Iterator<JsonElement> iterator = mapperManager6.getArrayIterator(mapperManager7.getArrayElement((JsonElement)object8, 0));
            Intrinsics.checkNotNull(iterator);
            Iterator<JsonElement> iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement historyEntry = iterator2.next();
                JsonElement message = null;
                Long timetoken = null;
                JsonElement meta = null;
                if (this.includeTimetoken || this.includeMeta) {
                    JsonElement jsonElement3 = this.getPubnub().getMapper().getField(historyEntry, "message");
                    Intrinsics.checkNotNull((Object)jsonElement3);
                    message = JsonElementKt.processHistoryMessage(jsonElement3, this.getPubnub().getConfiguration(), this.getPubnub().getMapper());
                    if (this.includeTimetoken) {
                        MapperManager mapperManager8 = this.getPubnub().getMapper();
                        Intrinsics.checkNotNullExpressionValue((Object)historyEntry, (String)"historyEntry");
                        timetoken = mapperManager8.elementToLong(historyEntry, "timetoken");
                    }
                    if (this.includeMeta) {
                        meta = this.getPubnub().getMapper().getField(historyEntry, "meta");
                    }
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)historyEntry, (String)"historyEntry");
                    message = JsonElementKt.processHistoryMessage(historyEntry, this.getPubnub().getConfiguration(), this.getPubnub().getMapper());
                }
                PNHistoryItemResult historyItem = new PNHistoryItemResult(message, timetoken, meta);
                messages.add(historyItem);
            }
        } else {
            object6 = PubNubError.HTTP_ERROR;
            throw new PubNubException("History is disabled", (PubNubError)((Object)object6), null, 0, null, 28, null);
        }
        return historyData;
    }

    @Override
    @NotNull
    public PNOperationType.PNHistoryOperation operationType() {
        return PNOperationType.PNHistoryOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        boolean bl;
        String string;
        boolean bl2;
        String string2;
        String string3;
        Map<String, String> map;
        Object object = queryParams;
        Object object2 = "reverse";
        String string4 = String.valueOf(this.reverse);
        boolean bl3 = false;
        object.put((String)object2, (String)string4);
        object = queryParams;
        object2 = "include_token";
        string4 = String.valueOf(this.includeTimetoken);
        bl3 = false;
        object.put((String)object2, (String)string4);
        object = queryParams;
        object2 = "include_meta";
        string4 = String.valueOf(this.includeMeta);
        bl3 = false;
        object.put((String)object2, (String)string4);
        object = queryParams;
        object2 = "count";
        string4 = String.valueOf(this.countParam);
        bl3 = false;
        object.put((String)object2, (String)string4);
        object = this.start;
        if (object != null) {
            object2 = object;
            boolean bl4 = false;
            bl3 = false;
            long $this$addQueryParams_u24lambda_u2d0 = ((Number)object2).longValue();
            boolean bl5 = false;
            map = queryParams;
            string3 = "start";
            string2 = String.valueOf($this$addQueryParams_u24lambda_u2d0);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            bl2 = false;
            string = string2;
            bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            string2 = string6;
            boolean bl6 = false;
            map.put(string3, string2);
        }
        object = this.end;
        if (object != null) {
            object2 = object;
            boolean bl7 = false;
            bl3 = false;
            long $this$addQueryParams_u24lambda_u2d1 = ((Number)object2).longValue();
            boolean bl8 = false;
            map = queryParams;
            string3 = "end";
            string2 = String.valueOf($this$addQueryParams_u24lambda_u2d1);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            bl2 = false;
            string = string2;
            bl = false;
            String string7 = string;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
            string2 = string8;
            boolean bl9 = false;
            map.put(string3, string2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pubnub/api/endpoints/History$Companion;", "", "()V", "MAX_COUNT", "", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

