/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.pubsub;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.server.SubscribeEnvelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010%\u001a\u0004\u0018\u00010\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0014J\"\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0+H\u0014J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0014R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Lcom/pubnub/api/endpoints/pubsub/Subscribe;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/SubscribeEnvelope;", "pubnub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "channelGroups", "", "", "getChannelGroups", "()Ljava/util/List;", "setChannelGroups", "(Ljava/util/List;)V", "channels", "getChannels", "setChannels", "filterExpression", "getFilterExpression", "()Ljava/lang/String;", "setFilterExpression", "(Ljava/lang/String;)V", "region", "getRegion", "setRegion", "state", "", "getState", "()Ljava/lang/Object;", "setState", "(Ljava/lang/Object;)V", "timetoken", "", "getTimetoken", "()Ljava/lang/Long;", "setTimetoken", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSubscribeOperation;", "validateParams", "", "pubnub-kotlin"})
public final class Subscribe
extends Endpoint<SubscribeEnvelope, SubscribeEnvelope> {
    @NotNull
    private List<String> channels;
    @NotNull
    private List<String> channelGroups;
    @Nullable
    private Long timetoken;
    @Nullable
    private String region;
    @Nullable
    private Object state;
    @Nullable
    private String filterExpression;

    public Subscribe(@NotNull PubNub pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        super(pubnub);
        this.channels = CollectionsKt.emptyList();
        this.channelGroups = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    public final void setChannels(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channels = list;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public final void setChannelGroups(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channelGroups = list;
    }

    @Nullable
    public final Long getTimetoken() {
        return this.timetoken;
    }

    public final void setTimetoken(@Nullable Long l) {
        this.timetoken = l;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    public final void setRegion(@Nullable String string) {
        this.region = string;
    }

    @Nullable
    public final Object getState() {
        return this.state;
    }

    public final void setState(@Nullable Object object) {
        this.state = object;
    }

    @Nullable
    public final String getFilterExpression() {
        return this.filterExpression;
    }

    public final void setFilterExpression(@Nullable String string) {
        this.filterExpression = string;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty() && this.channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    protected Call<SubscribeEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        String string;
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Object object2 = this.channelGroups;
        boolean bl2 = false;
        if (!object2.isEmpty()) {
            object2 = queryParams;
            String string2 = "channel-group";
            String string3 = CollectionsKt.joinToString$default((Iterable)this.channelGroups, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            bl = false;
            object2.put(string2, string3);
        }
        object2 = this.filterExpression;
        bl2 = false;
        boolean bl3 = false;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            object2 = queryParams;
            String string4 = "filter-expr";
            String string5 = this.filterExpression;
            Intrinsics.checkNotNull((Object)string5);
            String string6 = string5;
            bl = false;
            object2.put(string4, string6);
        }
        if ((object2 = this.timetoken) != null) {
            Object object3 = object2;
            boolean bl4 = false;
            bl = false;
            long it = ((Number)object3).longValue();
            boolean bl5 = false;
            object = queryParams;
            string = "tt";
            String string7 = String.valueOf(it);
            boolean bl6 = false;
            object.put(string, string7);
        }
        object2 = this.region;
        if (object2 != null) {
            Object object4 = object2;
            boolean bl7 = false;
            bl = false;
            Object it = object4;
            boolean bl8 = false;
            Map map = queryParams;
            object = "tr";
            boolean bl9 = false;
            map.put(object, it);
        }
        object2 = queryParams;
        Object object5 = "heartbeat";
        String string8 = String.valueOf(this.getPubnub().getConfiguration().getPresenceTimeout());
        bl = false;
        object2.put(object5, string8);
        object2 = this.state;
        if (object2 != null) {
            object5 = object2;
            boolean bl10 = false;
            bl = false;
            Object it = object5;
            boolean bl11 = false;
            Map map = queryParams;
            object = "state";
            string = this.getPubnub().getMapper().toJson(it);
            boolean bl12 = false;
            map.put(object, string);
        }
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getSubscribeService$pubnub_kotlin().subscribe(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams);
    }

    @Override
    @Nullable
    protected SubscribeEnvelope createResponse(@NotNull Response<SubscribeEnvelope> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return (SubscribeEnvelope)object;
    }

    @Override
    @NotNull
    public PNOperationType.PNSubscribeOperation operationType() {
        return PNOperationType.PNSubscribeOperation.INSTANCE;
    }
}

