/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.okhttp3;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Connection;
import okhttp3.Request;
import okhttp3.Response;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010\t\u001a\u00020\u0001H\u0096\u0001J\u0019\u0010\n\u001a\u00020\b2\u000e\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0011\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\t\u0010\u0011\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010\u0012\u001a\n \u0006*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0011\u0010\u0014\u001a\n \u0006*\u0004\u0018\u00010\u00150\u0015H\u0096\u0001J%\u0010\u0016\u001a\u0004\u0018\u00010\u0017\"\b\b\u0000\u0010\u0018*\u00020\u0017*\u0002H\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u001c\u001a\u0004\u0018\u00010\u0017\"\b\b\u0000\u0010\u0018*\u00020\u0017*\u0002H\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u001f\"\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u0001H\u0002J\u0018\u0010#\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030$2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u001b\u0010'\u001a\u00020\u0010\"\b\b\u0000\u0010\u0018*\u00020\u0001*\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010(J\u001b\u0010)\u001a\u00020\u0010\"\b\b\u0000\u0010\u0018*\u00020\u0001*\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010(R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pubnub/okhttp3/PNCall;", "Lokhttp3/Call;", "realCall", "(Lokhttp3/Call;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cancel", "", "clone", "enqueue", "p0", "Lokhttp3/Callback;", "execute", "Lokhttp3/Response;", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "timeout", "Lokio/Timeout;", "accessField", "", "T", "fieldName", "", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "callPrivateFunction", "name", "args", "", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "getConnection", "Lokhttp3/Connection;", "hasField", "Ljava/lang/Class;", "hasMethod", "methodName", "isStreamAllocationAvailable", "(Lokhttp3/Call;)Z", "isTransmitterAvailable", "pubnub-kotlin"})
public final class PNCall
implements Call {
    @NotNull
    private final Call realCall;
    private final Logger log;

    public PNCall(@NotNull Call realCall) {
        Intrinsics.checkNotNullParameter((Object)realCall, (String)"realCall");
        this.realCall = realCall;
        this.log = LoggerFactory.getLogger((String)"PNCall");
    }

    @NotNull
    public Call clone() {
        return this.realCall.clone();
    }

    public void enqueue(Callback p0) {
        this.realCall.enqueue(p0);
    }

    public Response execute() {
        return this.realCall.execute();
    }

    public boolean isCanceled() {
        return this.realCall.isCanceled();
    }

    public boolean isExecuted() {
        return this.realCall.isExecuted();
    }

    public Request request() {
        return this.realCall.request();
    }

    public Timeout timeout() {
        return this.realCall.timeout();
    }

    public void cancel() {
        try {
            Socket socket;
            Connection connection = this.getConnection(this.realCall);
            if (connection != null && (socket = connection.socket()) != null) {
                socket.shutdownInput();
            }
        }
        catch (Throwable t) {
            this.log.warn("Caught throwable when canceling call", t);
        }
        this.realCall.cancel();
    }

    private final Connection getConnection(Call $this$getConnection) {
        Object object;
        if (this.isTransmitterAvailable($this$getConnection)) {
            Object object2 = this.accessField($this$getConnection, "transmitter");
            object = object2 == null ? null : this.accessField(object2, "connection");
        } else if (this.isStreamAllocationAvailable($this$getConnection)) {
            Object object3 = this.callPrivateFunction($this$getConnection, "streamAllocation", new Object[0]);
            object = object3 == null ? null : this.accessField(object3, "connection");
        } else {
            this.log.warn("Unrecognized version of OkHttp client. This may cause unexpected behavior when Security Provider updated on Android");
            object = null;
        }
        return (Connection)object;
    }

    private final <T extends Call> boolean isTransmitterAvailable(T $this$isTransmitterAvailable) {
        return this.hasField($this$isTransmitterAvailable.getClass(), "transmitter");
    }

    private final <T extends Call> boolean isStreamAllocationAvailable(T $this$isStreamAllocationAvailable) {
        return this.hasMethod($this$isStreamAllocationAvailable.getClass(), "streamAllocation");
    }

    private final <T> Object accessField(T $this$accessField, String fieldName) {
        Field field = $this$accessField.getClass().getDeclaredField(fieldName);
        boolean bl = false;
        boolean bl2 = false;
        Field field2 = field;
        boolean bl3 = false;
        field2.setAccessible(true);
        return field2.get($this$accessField);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Object callPrivateFunction(T $this$callPrivateFunction, String name, Object ... args) {
        Object object;
        Object v0;
        Iterable iterable;
        block3: {
            void $this$firstOrNull$iv;
            iterable = KClasses.getDeclaredMemberFunctions((KClass)Reflection.getOrCreateKotlinClass($this$callPrivateFunction.getClass()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KFunction it = (KFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        KFunction kFunction = v0;
        if (kFunction == null) {
            object = null;
        } else {
            KFunction kFunction2 = kFunction;
            boolean bl = false;
            boolean bl2 = false;
            KFunction $this$callPrivateFunction_u24lambda_u2d2 = kFunction2;
            boolean bl3 = false;
            KCallablesJvm.setAccessible((KCallable)((KCallable)$this$callPrivateFunction_u24lambda_u2d2), (boolean)true);
            iterable = kFunction2;
            kFunction2 = new SpreadBuilder(2);
            kFunction2.add($this$callPrivateFunction);
            kFunction2.addSpread((Object)args);
            object = iterable.call(kFunction2.toArray(new Object[kFunction2.size()]));
        }
        return object;
    }

    private final boolean hasField(Class<?> $this$hasField, String fieldName) {
        boolean bl;
        try {
            bl = $this$hasField.getDeclaredField(fieldName) != null;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean hasMethod(Class<?> $this$hasMethod, String methodName) {
        boolean bl;
        block1: {
            Method[] methodArray = $this$hasMethod.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"declaredMethods");
            Object[] $this$any$iv = methodArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Method it = (Method)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)methodName)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

