/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import com.pubnub.api.models.server.files.FormField;
import com.pubnub.api.models.server.files.GenerateUploadUrlPayload;
import com.pubnub.api.models.server.files.GeneratedUploadUrlResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0014J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0010j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/pubnub/api/endpoints/files/GenerateUploadUrl;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/files/GeneratedUploadUrlResponse;", "Lcom/pubnub/api/models/server/files/FileUploadRequestDetails;", "channel", "", "fileName", "pubNub", "Lcom/pubnub/api/PubNub;", "(Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/PubNub;)V", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "getKeyFormField", "Lcom/pubnub/api/models/server/files/FormField;", "response", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "Factory", "pubnub-kotlin"})
public final class GenerateUploadUrl
extends Endpoint<GeneratedUploadUrlResponse, FileUploadRequestDetails> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;

    public GenerateUploadUrl(@NotNull String channel, @NotNull String fileName, @NotNull PubNub pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
    }

    @Override
    protected void validateParams() throws PubNubException {
        CharSequence charSequence = this.channel;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected FileUploadRequestDetails createResponse(@NotNull Response<GeneratedUploadUrlResponse> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (input.body() == null) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INTERNAL_ERROR), "Empty body, but GeneratedUploadUrlResponse expected", null, null, 0, null, 30, null);
        }
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"input.body()!!");
        GeneratedUploadUrlResponse response = (GeneratedUploadUrlResponse)object2;
        FormField keyFormField = this.getKeyFormField(response);
        return new FileUploadRequestDetails(response.getStatus(), response.getData(), response.getFileUploadRequest().getUrl(), response.getFileUploadRequest().getMethod(), response.getFileUploadRequest().getExpirationDate(), keyFormField, response.getFileUploadRequest().getFormFields());
    }

    private final FormField getKeyFormField(GeneratedUploadUrlResponse response) throws PubNubException {
        Object v0;
        block2: {
            List<FormField> formFields = response.getFileUploadRequest().getFormFields();
            Iterable iterable = formFields;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FormField it = (FormField)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"key")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        FormField formField = v0;
        if (formField == null) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INTERNAL_ERROR), "Couldn't find `key` form field in GeneratedUploadUrlResponse", null, null, 0, null, 30, null);
        }
        return formField;
    }

    @Override
    @NotNull
    protected Call<GeneratedUploadUrlResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getFilesService$pubnub_kotlin().generateUploadUrl(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, new GenerateUploadUrlPayload(this.fileName), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/pubnub/api/endpoints/files/GenerateUploadUrl$Factory;", "", "pubNub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/server/files/FileUploadRequestDetails;", "channel", "", "fileName", "pubnub-kotlin"})
    public static final class Factory {
        @NotNull
        private final PubNub pubNub;

        public Factory(@NotNull PubNub pubNub) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final ExtendedRemoteAction<FileUploadRequestDetails> create(@NotNull String channel, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new GenerateUploadUrl(channel, fileName, this.pubNub);
        }
    }
}

