/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import com.pubnub.api.models.server.files.FormField;
import com.pubnub.api.services.S3Service;
import com.pubnub.api.vendor.FileEncryptionUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000212BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJB\u0010\u0012\u001a\u00020\u000228\u0010\u0013\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002J0\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001d2\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#H\u0002J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010'\u001a\u00020(H\u0016J\u001a\u0010)\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0002J\b\u0010+\u001a\u00020\u0002H\u0016J\b\u0010,\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020\u0002H\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0010\u0010/\u001a\u00020 *\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0012\u00100\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/pubnub/api/endpoints/files/UploadFile;", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "", "s3Service", "Lcom/pubnub/api/services/S3Service;", "fileName", "", "content", "", "cipherKey", "key", "Lcom/pubnub/api/models/server/files/FormField;", "formParams", "", "baseUrl", "(Lcom/pubnub/api/services/S3Service;Ljava/lang/String;[BLjava/lang/String;Lcom/pubnub/api/models/server/files/FormField;Ljava/util/List;Ljava/lang/String;)V", "call", "Lretrofit2/Call;", "async", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "createException", "Lcom/pubnub/api/PubNubException;", "response", "Lretrofit2/Response;", "createStatusResponse", "category", "Lcom/pubnub/api/enums/PNStatusCategory;", "throwable", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getMediaType", "Lokhttp3/MediaType;", "contentType", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "prepareBytes", "prepareCall", "retry", "silentCancel", "sync", "findContentType", "getCategory", "readErrorMessage", "Companion", "Factory", "pubnub-kotlin"})
public final class UploadFile
implements ExtendedRemoteAction<Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final S3Service s3Service;
    @NotNull
    private final String fileName;
    @NotNull
    private final byte[] content;
    @Nullable
    private final String cipherKey;
    @NotNull
    private final FormField key;
    @NotNull
    private final List<FormField> formParams;
    @NotNull
    private final String baseUrl;
    @Nullable
    private Call<Unit> call;
    @NotNull
    private static final MediaType APPLICATION_OCTET_STREAM = MediaType.Companion.get("application/octet-stream");
    @NotNull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    private static final String FILE_PART_MULTIPART = "file";
    private static final Logger log = LoggerFactory.getLogger(UploadFile.class);

    public UploadFile(@NotNull S3Service s3Service, @NotNull String fileName, @NotNull byte[] content, @Nullable String cipherKey, @NotNull FormField key, @NotNull List<FormField> formParams, @NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)s3Service, (String)"s3Service");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(formParams, (String)"formParams");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.s3Service = s3Service;
        this.fileName = fileName;
        this.content = content;
        this.cipherKey = cipherKey;
        this.key = key;
        this.formParams = formParams;
        this.baseUrl = baseUrl;
    }

    private final Call<Unit> prepareCall() throws PubNubException {
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        UploadFile.Companion.addFormParamsWithKeyFirst(this.key, this.formParams, builder);
        MediaType mediaType = this.getMediaType(this.findContentType(this.formParams));
        byte[] bytes = this.prepareBytes(this.content, this.cipherKey);
        builder.addFormDataPart(FILE_PART_MULTIPART, this.fileName, RequestBody.Companion.create(bytes, mediaType, 0, this.content.length));
        return this.s3Service.upload(this.baseUrl, builder.build());
    }

    private final byte[] prepareBytes(byte[] content, String cipherKey) {
        return cipherKey == null ? content : FileEncryptionUtil.INSTANCE.encryptToBytes$pubnub_kotlin(content, cipherKey);
    }

    private final String findContentType(List<FormField> $this$findContentType) {
        Object v0;
        block1: {
            Iterable iterable = $this$findContentType;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FormField $dstr$key$_u24__u24 = (FormField)t;
                boolean bl3 = false;
                String key = $dstr$key$_u24__u24.component1();
                if (!StringsKt.equals((String)key, (String)CONTENT_TYPE_HEADER, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        FormField formField = v0;
        return formField == null ? null : formField.getValue();
    }

    private final MediaType getMediaType(String contentType) {
        MediaType mediaType;
        if (contentType == null) {
            mediaType = APPLICATION_OCTET_STREAM;
        } else {
            MediaType mediaType2;
            try {
                mediaType2 = MediaType.Companion.get(contentType);
            }
            catch (Throwable t) {
                log.warn("Content-Type: " + contentType + " was not recognized by MediaType.get", t);
                mediaType2 = APPLICATION_OCTET_STREAM;
            }
            mediaType = mediaType2;
        }
        return mediaType;
    }

    @Override
    public void sync() throws PubNubException {
        Response response;
        this.call = this.prepareCall();
        try {
            Call<Unit> call = this.call;
            Intrinsics.checkNotNull(call);
            response = call.execute();
        }
        catch (IOException e) {
            String string = e.getMessage();
            Call<Unit> call = this.call;
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            throw new PubNubException(string, pubNubError, null, 0, call, 12, null);
        }
        Response serverResponse = response;
        if (!serverResponse.isSuccessful()) {
            Intrinsics.checkNotNullExpressionValue((Object)serverResponse, (String)"serverResponse");
            throw this.createException((Response<Unit>)serverResponse);
        }
    }

    @Override
    public void async(@NotNull Function2<? super Unit, ? super PNStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            Call<Unit> call = this.call = this.prepareCall();
            Intrinsics.checkNotNull(call);
            call.enqueue((Callback)new Callback<Unit>(this, callback){
                final /* synthetic */ UploadFile this$0;
                final /* synthetic */ Function2<Unit, PNStatus, Unit> $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                }

                public void onResponse(@NotNull Call<Unit> performedCall, @NotNull Response<Unit> response) {
                    Intrinsics.checkNotNullParameter(performedCall, (String)"performedCall");
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    if (!response.isSuccessful()) {
                        PubNubException ex = UploadFile.access$createException(this.this$0, response);
                        PNStatusCategory pnStatusCategory = UploadFile.access$getCategory(this.this$0, response);
                        this.$callback.invoke(null, (Object)UploadFile.access$createStatusResponse(this.this$0, pnStatusCategory, response, ex));
                        return;
                    }
                    this.$callback.invoke((Object)Unit.INSTANCE, (Object)UploadFile.access$createStatusResponse(this.this$0, PNStatusCategory.PNAcknowledgmentCategory, response, null));
                }

                public void onFailure(@NotNull Call<Unit> performedCall, @NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter(performedCall, (String)"performedCall");
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    Call call = UploadFile.access$getCall$p(this.this$0);
                    Intrinsics.checkNotNull((Object)call);
                    if (call.isCanceled()) {
                        return;
                    }
                    Throwable throwable2 = throwable;
                    Pair pair = throwable2 instanceof UnknownHostException ? TuplesKt.to((Object)((Object)PNStatusCategory.PNUnexpectedDisconnectCategory), (Object)((Object)PubNubError.CONNECTION_NOT_SET)) : ((throwable2 instanceof SocketException ? true : throwable2 instanceof SSLException) ? TuplesKt.to((Object)((Object)PNStatusCategory.PNUnexpectedDisconnectCategory), (Object)((Object)PubNubError.CONNECT_EXCEPTION)) : (throwable2 instanceof SocketTimeoutException ? TuplesKt.to((Object)((Object)PNStatusCategory.PNTimeoutCategory), (Object)((Object)PubNubError.SUBSCRIBE_TIMEOUT)) : (performedCall.isCanceled() ? TuplesKt.to((Object)((Object)PNStatusCategory.PNCancelledCategory), (Object)((Object)PubNubError.HTTP_ERROR)) : TuplesKt.to((Object)((Object)PNStatusCategory.PNBadRequestCategory), (Object)((Object)PubNubError.HTTP_ERROR)))));
                    PNStatusCategory statusCategory = (PNStatusCategory)((Object)pair.component1());
                    PubNubError error = (PubNubError)((Object)pair.component2());
                    String string = throwable.getMessage();
                    this.$callback.invoke(null, (Object)UploadFile.access$createStatusResponse(this.this$0, statusCategory, null, PubNubException.copy$default(new PubNubException(error), string == null ? error.getMessage() : string, null, null, 0, null, 30, null)));
                }
            });
        }
        catch (IOException e) {
            callback.invoke(null, (Object)this.createStatusResponse(PNStatusCategory.PNUnknownCategory, null, e));
        }
        catch (PubNubException e) {
            callback.invoke(null, (Object)this.createStatusResponse(PNStatusCategory.PNUnknownCategory, null, e));
        }
    }

    private final PNStatusCategory getCategory(Response<?> $this$getCategory) {
        PNStatusCategory pNStatusCategory;
        int n = $this$getCategory.code();
        switch (n) {
            case 401: 
            case 403: {
                pNStatusCategory = PNStatusCategory.PNAccessDeniedCategory;
                break;
            }
            case 400: {
                pNStatusCategory = PNStatusCategory.PNBadRequestCategory;
                break;
            }
            default: {
                pNStatusCategory = PNStatusCategory.PNUnknownCategory;
            }
        }
        return pNStatusCategory;
    }

    @Override
    public void retry() {
    }

    @Override
    public void silentCancel() {
        Call<Unit> call = this.call;
        Intrinsics.checkNotNull(call);
        if (!call.isCanceled()) {
            Call<Unit> call2 = this.call;
            Intrinsics.checkNotNull(call2);
            call2.cancel();
        }
    }

    private final PubNubException createException(Response<Unit> response) {
        Object object;
        try {
            object = this.readErrorMessage(response);
            Call<Unit> call = this.call;
            int n = response.code();
            object = new PubNubException((String)object, null, null, n, call, 6, null);
        }
        catch (Exception e) {
            String string = e.getMessage();
            Call<Unit> call = this.call;
            int n = response.code();
            object = new PubNubException(string, null, null, n, call, 6, null);
        }
        return object;
    }

    private final String readErrorMessage(Response<Unit> $this$readErrorMessage) {
        String string;
        Node node;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        ResponseBody responseBody = $this$readErrorMessage.errorBody();
        Intrinsics.checkNotNull((Object)responseBody);
        Document doc = dBuilder.parse(responseBody.byteStream());
        doc.getDocumentElement().normalize();
        NodeList elements = doc.getElementsByTagName("Message");
        Node node2 = elements.item(0);
        return node2 == null ? "N/A" : ((node = node2.getFirstChild()) == null ? "N/A" : ((string = node.getNodeValue()) == null ? "N/A" : string));
    }

    private final PNStatus createStatusResponse(PNStatusCategory category, Response<Unit> response, Exception throwable) {
        HttpUrl httpUrl;
        HttpUrl httpUrl2;
        Request request;
        Response<Unit> response2;
        Object object = this.operationType();
        Response<Unit> response3 = response;
        Integer n = response3 == null ? null : Integer.valueOf(response3.code());
        Response<Unit> response4 = response;
        response3 = response4 == null ? null : ((response2 = response4.raw()) == null ? null : ((request = response2.request()) == null ? null : ((httpUrl2 = request.url()) == null ? null : Boolean.valueOf(httpUrl2.isHttps()))));
        response2 = response;
        response4 = response2 == null ? null : ((request = response2.raw()) == null ? null : ((httpUrl2 = request.request()) == null ? null : ((httpUrl = httpUrl2.url()) == null ? null : httpUrl.host())));
        boolean bl = response == null || throwable != null;
        object = new PNStatus(category, bl, (PNOperationType)object, null, n, (Boolean)response3, (String)response4, null, null, null, null, 1928, null);
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$createStatusResponse_u24lambda_u2d1 = object;
        boolean bl4 = false;
        ((PNStatus)$this$createStatusResponse_u24lambda_u2d1).setExecutedEndpoint$pubnub_kotlin(this);
        return object;
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    public static final /* synthetic */ PubNubException access$createException(UploadFile $this, Response response) {
        return $this.createException((Response<Unit>)response);
    }

    public static final /* synthetic */ PNStatusCategory access$getCategory(UploadFile $this, Response $receiver) {
        return $this.getCategory($receiver);
    }

    public static final /* synthetic */ PNStatus access$createStatusResponse(UploadFile $this, PNStatusCategory category, Response response, Exception throwable) {
        return $this.createStatusResponse(category, (Response<Unit>)response, throwable);
    }

    public static final /* synthetic */ Call access$getCall$p(UploadFile $this) {
        return $this.call;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/api/endpoints/files/UploadFile$Factory;", "", "pubNub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "", "fileName", "", "content", "", "cipherKey", "fileUploadRequestDetails", "Lcom/pubnub/api/models/server/files/FileUploadRequestDetails;", "pubnub-kotlin"})
    public static final class Factory {
        @NotNull
        private final PubNub pubNub;

        public Factory(@NotNull PubNub pubNub) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final ExtendedRemoteAction<Unit> create(@NotNull String fileName, @NotNull byte[] content, @Nullable String cipherKey, @NotNull FileUploadRequestDetails fileUploadRequestDetails) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)fileUploadRequestDetails, (String)"fileUploadRequestDetails");
            String effectiveCipherKey = FileEncryptionUtil.INSTANCE.effectiveCipherKey$pubnub_kotlin(this.pubNub, cipherKey);
            return new UploadFile(this.pubNub.getRetrofitManager$pubnub_kotlin().getS3Service$pubnub_kotlin(), fileName, content, effectiveCipherKey, fileUploadRequestDetails.getKeyFormField(), fileUploadRequestDetails.getFormFields(), fileUploadRequestDetails.getUrl());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/api/endpoints/files/UploadFile$Companion;", "", "()V", "APPLICATION_OCTET_STREAM", "Lokhttp3/MediaType;", "CONTENT_TYPE_HEADER", "", "FILE_PART_MULTIPART", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addFormParamsWithKeyFirst", "", "keyValue", "Lcom/pubnub/api/models/server/files/FormField;", "formParams", "", "builder", "Lokhttp3/MultipartBody$Builder;", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void addFormParamsWithKeyFirst(FormField keyValue, List<FormField> formParams, MultipartBody.Builder builder) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            builder.addFormDataPart(keyValue.getKey(), keyValue.getValue());
            Iterable iterable = formParams;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FormField it = (FormField)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getKey(), (Object)keyValue.getKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormField it = (FormField)element$iv;
                boolean bl = false;
                builder.addFormDataPart(it.getKey(), it.getValue());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

