/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNDownloadableFile;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.models.consumer.pubsub.BasePubSubResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.PubSubResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.ObjectPayload;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventMessage;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.api.models.server.PresenceEnvelope;
import com.pubnub.api.models.server.PublishMetaData;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.models.server.files.FileUploadNotification;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J*\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010,\u001a\u00020\bH\u0002J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcom/pubnub/api/workers/SubscribeMessageWorker;", "Ljava/lang/Runnable;", "pubnub", "Lcom/pubnub/api/PubNub;", "listenerManager", "Lcom/pubnub/api/managers/ListenerManager;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pubnub/api/models/server/SubscribeMessage;", "duplicationManager", "Lcom/pubnub/api/managers/DuplicationManager;", "(Lcom/pubnub/api/PubNub;Lcom/pubnub/api/managers/ListenerManager;Ljava/util/concurrent/LinkedBlockingQueue;Lcom/pubnub/api/managers/DuplicationManager;)V", "getDuplicationManager", "()Lcom/pubnub/api/managers/DuplicationManager;", "formatFriendlyGetFileUrl", "", "getListenerManager", "()Lcom/pubnub/api/managers/ListenerManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPubnub", "()Lcom/pubnub/api/PubNub;", "getQueue", "()Ljava/util/concurrent/LinkedBlockingQueue;", "buildFileUrl", "channel", "fileId", "fileName", "generateSignature", "configuration", "Lcom/pubnub/api/PNConfiguration;", "url", "authKey", "timestamp", "", "getDelta", "", "delta", "Lcom/google/gson/JsonElement;", "processIncomingPayload", "", "message", "processMessage", "subscribeMessage", "run", "takeMessage", "Companion", "pubnub-kotlin"})
public final class SubscribeMessageWorker
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PubNub pubnub;
    @NotNull
    private final ListenerManager listenerManager;
    @NotNull
    private final LinkedBlockingQueue<SubscribeMessage> queue;
    @NotNull
    private final DuplicationManager duplicationManager;
    private final Logger log;
    @NotNull
    private final String formatFriendlyGetFileUrl;
    public static final int TYPE_MESSAGE = 0;
    public static final int TYPE_SIGNAL = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_MESSAGE_ACTION = 3;
    public static final int TYPE_FILES = 4;

    public SubscribeMessageWorker(@NotNull PubNub pubnub, @NotNull ListenerManager listenerManager, @NotNull LinkedBlockingQueue<SubscribeMessage> queue, @NotNull DuplicationManager duplicationManager) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)duplicationManager, (String)"duplicationManager");
        this.pubnub = pubnub;
        this.listenerManager = listenerManager;
        this.queue = queue;
        this.duplicationManager = duplicationManager;
        this.log = LoggerFactory.getLogger((String)"SubscribeMessageWorker");
        CharSequence charSequence = "/v1/files/{subKey}/channels/{channel}/files/{fileId}/{fileName}";
        String string = "\\{.*?\\}";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "%s";
        boolean bl2 = false;
        this.formatFriendlyGetFileUrl = Intrinsics.stringPlus((String)"%s", (Object)string.replace(charSequence, string2));
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    @NotNull
    public final ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    @NotNull
    public final LinkedBlockingQueue<SubscribeMessage> getQueue() {
        return this.queue;
    }

    @NotNull
    public final DuplicationManager getDuplicationManager() {
        return this.duplicationManager;
    }

    @Override
    public void run() {
        this.takeMessage();
    }

    private final void takeMessage() {
        while (!Thread.interrupted()) {
            try {
                SubscribeMessage subscribeMessage = this.queue.take();
                Intrinsics.checkNotNullExpressionValue((Object)subscribeMessage, (String)"queue.take()");
                this.processIncomingPayload(subscribeMessage);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.trace("take message interrupted!", (Throwable)e);
            }
        }
    }

    private final void processIncomingPayload(SubscribeMessage message) {
        if (message.getChannel$pubnub_kotlin() == null) {
            return;
        }
        String channel = message.getChannel$pubnub_kotlin();
        String subscriptionMatch = message.getSubscriptionMatch$pubnub_kotlin();
        PublishMetaData publishMetaData = message.getPublishMetaData$pubnub_kotlin();
        if (Intrinsics.areEqual((Object)channel, (Object)subscriptionMatch)) {
            subscriptionMatch = null;
        }
        if (this.pubnub.getConfiguration().getDedupOnSubscribe()) {
            if (this.duplicationManager.isDuplicate(message)) {
                return;
            }
            this.duplicationManager.addEntry(message);
        }
        if (StringsKt.endsWith$default((String)message.getChannel$pubnub_kotlin(), (String)"-pnpres", (boolean)false, (int)2, null)) {
            JsonObject jsonObject;
            JsonObject jsonObject2;
            JsonObject jsonObject3;
            JsonObject jsonObject4;
            Object object;
            String string;
            PresenceEnvelope presencePayload = this.pubnub.getMapper().convertValue(message.getPayload$pubnub_kotlin(), PresenceEnvelope.class);
            String strippedPresenceChannel = PubNubUtil.INSTANCE.replaceLast(channel, "-pnpres", "");
            String string2 = subscriptionMatch;
            if (string2 == null) {
                string = null;
            } else {
                object = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = object;
                boolean bl3 = false;
                string = PubNubUtil.INSTANCE.replaceLast(it, "-pnpres", "");
            }
            String strippedPresenceSubscription = string;
            object = message.getPayload$pubnub_kotlin();
            JsonElement isHereNowRefresh = object == null ? null : ((jsonObject4 = object.getAsJsonObject()) == null ? null : jsonObject4.get("here_now_refresh"));
            object = publishMetaData;
            Long l = object == null ? null : ((PublishMetaData)object).getPublishTimetoken$pubnub_kotlin();
            object = message.getPayload$pubnub_kotlin();
            List<String> list = this.getDelta(object == null ? null : ((jsonObject3 = object.getAsJsonObject()) == null ? null : jsonObject3.get("join")));
            object = message.getPayload$pubnub_kotlin();
            List<String> list2 = this.getDelta(object == null ? null : ((jsonObject2 = object.getAsJsonObject()) == null ? null : jsonObject2.get("leave")));
            object = message.getPayload$pubnub_kotlin();
            this.listenerManager.announce(new PNPresenceEventResult(presencePayload.getAction$pubnub_kotlin(), presencePayload.getUuid$pubnub_kotlin(), presencePayload.getTimestamp$pubnub_kotlin(), presencePayload.getOccupancy$pubnub_kotlin(), presencePayload.getData$pubnub_kotlin(), strippedPresenceChannel, strippedPresenceSubscription, l, list, list2, this.getDelta(object == null ? null : ((jsonObject = object.getAsJsonObject()) == null ? null : jsonObject.get("timeout"))), isHereNowRefresh != null && isHereNowRefresh.getAsBoolean(), null, 4096, null));
        } else {
            Object object;
            JsonElement extractedMessage = this.processMessage(message);
            if (extractedMessage == null) {
                this.log.debug("unable to parse payload on #processIncomingMessages");
            }
            BasePubSubResult result = new BasePubSubResult(channel, subscriptionMatch, (object = publishMetaData) == null ? null : ((PublishMetaData)object).getPublishTimetoken$pubnub_kotlin(), message.getUserMetadata$pubnub_kotlin(), message.getIssuingClientId$pubnub_kotlin());
            object = message.getType$pubnub_kotlin();
            if (object == null) {
                PubSubResult pubSubResult = result;
                JsonElement jsonElement = extractedMessage;
                Intrinsics.checkNotNull((Object)jsonElement);
                this.listenerManager.announce(new PNMessageResult(pubSubResult, jsonElement));
            } else {
                int isHereNowRefresh = 0;
                if ((Integer)object == 0) {
                    PubSubResult pubSubResult = result;
                    JsonElement jsonElement = extractedMessage;
                    Intrinsics.checkNotNull((Object)jsonElement);
                    this.listenerManager.announce(new PNMessageResult(pubSubResult, jsonElement));
                } else {
                    isHereNowRefresh = 1;
                    if ((Integer)object == isHereNowRefresh) {
                        PubSubResult pubSubResult = result;
                        JsonElement jsonElement = extractedMessage;
                        Intrinsics.checkNotNull((Object)jsonElement);
                        this.listenerManager.announce(new PNSignalResult(pubSubResult, jsonElement));
                    } else {
                        isHereNowRefresh = 2;
                        if ((Integer)object == isHereNowRefresh) {
                            this.listenerManager.announce(new PNObjectEventResult(result, this.pubnub.getMapper().convertValue(extractedMessage, PNObjectEventMessage.class)));
                        } else {
                            isHereNowRefresh = 3;
                            if ((Integer)object == isHereNowRefresh) {
                                ObjectPayload objectPayload = this.pubnub.getMapper().convertValue(extractedMessage, ObjectPayload.class);
                                JsonObject data = objectPayload.getData().getAsJsonObject();
                                if (!data.has("uuid")) {
                                    data.addProperty("uuid", result.getPublisher());
                                }
                                this.listenerManager.announce(new PNMessageActionResult(result, objectPayload.getEvent(), this.pubnub.getMapper().convertValue((JsonElement)data, PNMessageAction.class)));
                            } else {
                                int objectPayload = 4;
                                if ((Integer)object == objectPayload) {
                                    FileUploadNotification fileUploadNotification = this.pubnub.getMapper().convertValue(extractedMessage, FileUploadNotification.class);
                                    String string = message.getChannel$pubnub_kotlin();
                                    Object object2 = fileUploadNotification.getMessage();
                                    PNDownloadableFile pNDownloadableFile = new PNDownloadableFile(fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName(), this.buildFileUrl(message.getChannel$pubnub_kotlin(), fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName()));
                                    String string3 = message.getIssuingClientId$pubnub_kotlin();
                                    Long l = result.getTimetoken();
                                    this.listenerManager.announce(new PNFileEventResult(string, l, string3, object2, pNDownloadableFile));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private final String buildFileUrl(String channel, String fileId, String fileName) {
        String string;
        String authKey;
        Object[] objectArray = new Object[]{this.pubnub.baseUrl$pubnub_kotlin(), this.pubnub.getConfiguration().getSubscribeKey(), channel, fileId, fileName};
        String string2 = String.format(this.formatFriendlyGetFileUrl, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(\n            form\u2026       fileName\n        )");
        String basePath = string2;
        ArrayList<String> queryParams = new ArrayList<String>();
        String string3 = authKey = PNConfiguration.Companion.isValid$pubnub_kotlin(this.pubnub.getConfiguration().getAuthKey()) ? this.pubnub.getConfiguration().getAuthKey() : null;
        if (PubNubUtil.INSTANCE.shouldSignRequest(this.pubnub.getConfiguration())) {
            int timestamp = this.pubnub.timestamp$pubnub_kotlin();
            String signature = this.generateSignature(this.pubnub.getConfiguration(), basePath, authKey, timestamp);
            queryParams.add(Intrinsics.stringPlus((String)"timestamp=", (Object)timestamp));
            queryParams.add(Intrinsics.stringPlus((String)"signature=", (Object)signature));
        }
        if ((string = authKey) != null) {
            String string4 = string;
            boolean bl = false;
            boolean bl2 = false;
            String $this$buildFileUrl_u24lambda_u2d1 = string4;
            boolean bl3 = false;
            queryParams.add(Intrinsics.stringPlus((String)"auth=", (Object)authKey));
        }
        return queryParams.isEmpty() ? basePath : basePath + '?' + CollectionsKt.joinToString$default((Iterable)queryParams, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    private final String generateSignature(PNConfiguration configuration, String url, String authKey, int timestamp) {
        boolean bl = false;
        Map queryParams = new LinkedHashMap();
        if (authKey != null) {
            Map map = queryParams;
            String string = "auth";
            boolean bl2 = false;
            map.put(string, authKey);
        }
        return PubNubUtil.INSTANCE.generateSignature(configuration, url, queryParams, "get", null, timestamp);
    }

    private final JsonElement processMessage(SubscribeMessage subscribeMessage) {
        JsonElement e2;
        String string;
        JsonElement input = subscribeMessage.getPayload$pubnub_kotlin();
        if (!PNConfiguration.Companion.isValid$pubnub_kotlin(this.pubnub.getConfiguration().getCipherKey())) {
            return input;
        }
        if (!subscribeMessage.supportsEncryption()) {
            return input;
        }
        Crypto crypto = new Crypto(this.pubnub.getConfiguration().getCipherKey(), this.pubnub.getConfiguration().getUseRandomInitializationVector());
        MapperManager mapperManager = this.pubnub.getMapper();
        JsonElement jsonElement = input;
        Intrinsics.checkNotNull((Object)jsonElement);
        String inputText = mapperManager.isJsonObject(jsonElement) && this.pubnub.getMapper().hasField(input, "pn_other") ? this.pubnub.getMapper().elementToString(input, "pn_other") : this.pubnub.getMapper().elementToString(input);
        try {
            String string2 = inputText;
            Intrinsics.checkNotNull((Object)string2);
            string = crypto.decrypt(string2);
        }
        catch (PubNubException e2) {
            PNStatus pnStatus = new PNStatus(PNStatusCategory.PNMalformedResponseCategory, true, PNOperationType.PNSubscribeOperation.INSTANCE, e2, null, null, null, null, null, null, null, 2032, null);
            this.listenerManager.announce(pnStatus);
            return null;
        }
        String outputText = string;
        try {
            e2 = this.pubnub.getMapper().fromJson(outputText, JsonElement.class);
        }
        catch (PubNubException e3) {
            PNStatus pnStatus = new PNStatus(PNStatusCategory.PNMalformedResponseCategory, true, PNOperationType.PNSubscribeOperation.INSTANCE, e3, null, null, null, null, null, null, null, 2032, null);
            this.listenerManager.announce(pnStatus);
            return null;
        }
        JsonElement outputObject = e2;
        if (this.pubnub.getMapper().isJsonObject(input) && this.pubnub.getMapper().hasField(input, "pn_other")) {
            JsonObject objectNode = this.pubnub.getMapper().getAsObject(input);
            MapperManager mapperManager2 = this.pubnub.getMapper();
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"objectNode");
            mapperManager2.putOnObject(objectNode, "pn_other", outputObject);
            outputObject = (JsonElement)objectNode;
        }
        return outputObject;
    }

    private final List<String> getDelta(JsonElement delta) {
        boolean bl = false;
        List list = new ArrayList();
        JsonElement jsonElement = delta;
        if (jsonElement != null) {
            JsonElement jsonElement2 = jsonElement;
            boolean bl2 = false;
            boolean bl3 = false;
            JsonElement it = jsonElement2;
            boolean bl4 = false;
            JsonArray jsonArray = it.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"it.asJsonArray");
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement item = (JsonElement)element$iv;
                boolean bl5 = false;
                JsonElement jsonElement3 = item;
                if (jsonElement3 == null) continue;
                JsonElement jsonElement4 = jsonElement3;
                boolean bl6 = false;
                boolean bl7 = false;
                JsonElement it2 = jsonElement4;
                boolean bl8 = false;
                String string = it2.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.asString");
                list.add(string);
            }
        }
        return list;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pubnub/api/workers/SubscribeMessageWorker$Companion;", "", "()V", "TYPE_FILES", "", "TYPE_MESSAGE", "TYPE_MESSAGE_ACTION", "TYPE_OBJECT", "TYPE_SIGNAL", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

