/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.vendor;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.vendor.Crypto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J!\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0016J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J\u001d\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001aJ\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pubnub/api/vendor/FileEncryptionUtil;", "", "()V", "CIPHER_TRANSFORMATION", "", "ENCODING_UTF_8", "IV_SIZE_BYTES", "", "cipher", "Ljavax/crypto/Cipher;", "keyBytes", "", "ivBytes", "mode", "decrypt", "Ljava/io/InputStream;", "inputStream", "cipherKey", "decryptionCipher", "effectiveCipherKey", "pubNub", "Lcom/pubnub/api/PubNub;", "effectiveCipherKey$pubnub_kotlin", "encrypt", "encryptToBytes", "bytesToEncrypt", "encryptToBytes$pubnub_kotlin", "encryptionCipher", "loadIvAndDataFromInputStream", "Lkotlin/Pair;", "inputStreamToEncrypt", "randomIv", "pubnub-kotlin"})
public final class FileEncryptionUtil {
    @NotNull
    public static final FileEncryptionUtil INSTANCE = new FileEncryptionUtil();
    private static final int IV_SIZE_BYTES = 16;
    @NotNull
    public static final String ENCODING_UTF_8 = "UTF-8";
    @NotNull
    public static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";

    private FileEncryptionUtil() {
    }

    @NotNull
    public final InputStream encrypt(@NotNull InputStream inputStream, @NotNull String cipherKey) throws PubNubException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        byte[] byArray = this.encryptToBytes$pubnub_kotlin(ByteStreamsKt.readBytes((InputStream)inputStream), cipherKey);
        boolean bl = false;
        return new ByteArrayInputStream(byArray);
    }

    @NotNull
    public final InputStream decrypt(@NotNull InputStream inputStream, @NotNull String cipherKey) throws PubNubException {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        try {
            byte[] keyBytes = this.keyBytes(cipherKey);
            Pair<byte[], byte[]> pair = this.loadIvAndDataFromInputStream(inputStream);
            byte[] ivBytes = (byte[])pair.component1();
            byte[] dataToDecrypt = (byte[])pair.component2();
            Cipher decryptionCipher = this.decryptionCipher(keyBytes, ivBytes);
            byte[] decryptedBytes = decryptionCipher.doFinal(dataToDecrypt);
            inputStream2 = new ByteArrayInputStream(decryptedBytes);
        }
        catch (Exception e) {
            Exception exception = e;
            if ((((((exception instanceof NoSuchAlgorithmException ? true : exception instanceof InvalidAlgorithmParameterException) ? true : exception instanceof NoSuchPaddingException) ? true : exception instanceof InvalidKeyException) ? true : exception instanceof IOException) ? true : exception instanceof IllegalBlockSizeException) ? true : exception instanceof BadPaddingException) {
                throw new PubNubException(e.getMessage(), null, null, 0, null, 30, null);
            }
            throw e;
        }
        return inputStream2;
    }

    @Nullable
    public final String effectiveCipherKey$pubnub_kotlin(@NotNull PubNub pubNub, @Nullable String cipherKey) {
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        String string = cipherKey;
        return string == null ? (PNConfiguration.Companion.isValid$pubnub_kotlin(pubNub.getConfiguration().getCipherKey()) ? pubNub.getConfiguration().getCipherKey() : (String)null) : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] encryptToBytes$pubnub_kotlin(@NotNull byte[] bytesToEncrypt, @NotNull String cipherKey) throws PubNubException {
        Intrinsics.checkNotNullParameter((Object)bytesToEncrypt, (String)"bytesToEncrypt");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        try {
            Closeable closeable = new ByteArrayOutputStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
                boolean bl3 = false;
                byte[] randomIvBytes = INSTANCE.randomIv();
                byteArrayOutputStream.write(randomIvBytes);
                byte[] keyBytes = INSTANCE.keyBytes(cipherKey);
                Cipher encryptionCipher = INSTANCE.encryptionCipher(keyBytes, randomIvBytes);
                byteArrayOutputStream.write(encryptionCipher.doFinal(bytesToEncrypt));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Exception exception = e;
            if ((((((exception instanceof NoSuchAlgorithmException ? true : exception instanceof InvalidAlgorithmParameterException) ? true : exception instanceof NoSuchPaddingException) ? true : exception instanceof InvalidKeyException) ? true : exception instanceof IOException) ? true : exception instanceof BadPaddingException) ? true : exception instanceof IllegalBlockSizeException) {
                throw new PubNubException(e.getMessage(), null, null, 0, null, 30, null);
            }
            throw e;
        }
    }

    private final Pair<byte[], byte[]> loadIvAndDataFromInputStream(InputStream inputStreamToEncrypt) throws IOException {
        byte[] ivBytes = new byte[16];
        inputStreamToEncrypt.read(ivBytes, 0, 16);
        return TuplesKt.to((Object)ivBytes, (Object)ByteStreamsKt.readBytes((InputStream)inputStreamToEncrypt));
    }

    private final Cipher encryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.cipher(keyBytes, ivBytes, 1);
    }

    private final Cipher decryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.cipher(keyBytes, ivBytes, 2);
    }

    private final Cipher cipher(byte[] keyBytes, byte[] ivBytes, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        AlgorithmParameterSpec iv = new IvParameterSpec(ivBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        cipher.init(mode, (Key)key, iv);
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"cipher");
        return cipher;
    }

    private final byte[] keyBytes(String cipherKey) throws UnsupportedEncodingException, PubNubException {
        Object object = cipherKey;
        Object object2 = ENCODING_UTF_8;
        boolean bl = false;
        Charset charset = Charset.forName((String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
        object2 = charset;
        bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes((Charset)object2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Object object3 = Crypto.hexEncode(Crypto.sha256(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"hexEncode(Crypto.sha256(\u2026harset(ENCODING_UTF_8))))");
        object = ENCODING_UTF_8;
        int n = 0;
        Charset charset2 = Charset.forName((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"Charset.forName(charsetName)");
        object = charset2;
        n = 0;
        object3 = new String((byte[])object3, (Charset)object);
        int n2 = 0;
        n = 32;
        bl = false;
        String string2 = ((String)object3).substring(n2, n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        object3 = string2;
        n2 = 0;
        Object object4 = object3;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object4).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        object3 = string3;
        Object object5 = ENCODING_UTF_8;
        n = 0;
        Charset charset3 = Charset.forName((String)object5);
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"Charset.forName(charsetName)");
        object5 = charset3;
        n = 0;
        Object object6 = object3;
        if (object6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = ((String)object6).getBytes((Charset)object5);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray2;
    }

    private final byte[] randomIv() throws NoSuchAlgorithmException {
        byte[] randomIv = new byte[16];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(randomIv);
        return randomIv;
    }
}

