/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.vendor.Base64;
import com.pubnub.api.vendor.Crypto;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J!\u0010\u001c\u001a\u00020\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001fH\u0000\u00a2\u0006\u0002\b J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u001e\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0017\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u000e\u0010/\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rJ\u001e\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b6J\u0012\u00107\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/pubnub/api/PubNubUtil;", "", "()V", "AUTH_QUERY_PARAM_NAME", "", "CHARSET", "SIGNATURE_QUERY_PARAM_NAME", "TIMESTAMP_QUERY_PARAM_NAME", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generateSignature", "configuration", "Lcom/pubnub/api/PNConfiguration;", "requestURL", "queryParams", "", "method", "requestBody", "timestamp", "", "request", "Lokhttp3/Request;", "pamEncode", "stringToEncode", "alreadyPercentEncoded", "", "pamEncode$pubnub_kotlin", "preparePamArguments", "encodedQueryString", "pamArgs", "", "preparePamArguments$pubnub_kotlin", "removeTrailingEqualSigns", "signature", "replaceLast", "string", "toReplace", "replacement", "requestBodyToString", "requestBodyToString$pubnub_kotlin", "require", "", "value", "error", "Lcom/pubnub/api/PubNubError;", "require$pubnub_kotlin", "shouldSignRequest", "signRequest", "originalRequest", "pnConfiguration", "signSHA256", "key", "data", "signSHA256$pubnub_kotlin", "urlDecode", "pubnub-kotlin"})
public final class PubNubUtil {
    @NotNull
    public static final PubNubUtil INSTANCE = new PubNubUtil();
    private static final Logger log = LoggerFactory.getLogger((String)"PubNubUtil");
    @NotNull
    private static final String CHARSET = "UTF-8";
    @NotNull
    public static final String SIGNATURE_QUERY_PARAM_NAME = "signature";
    @NotNull
    public static final String TIMESTAMP_QUERY_PARAM_NAME = "timestamp";
    @NotNull
    public static final String AUTH_QUERY_PARAM_NAME = "auth";

    private PubNubUtil() {
    }

    @NotNull
    public final String replaceLast(@NotNull String string, @NotNull String toReplace, @NotNull String replacement) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        int pos = StringsKt.lastIndexOf$default((CharSequence)string, (String)toReplace, (int)0, (boolean)false, (int)6, null);
        if (pos > -1) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string;
            int n = 0;
            int n2 = 0;
            String string4 = string3.substring(n, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string4).append(replacement);
            string3 = string;
            n = pos + toReplace.length();
            n2 = string.length();
            boolean bl = false;
            String string5 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = stringBuilder2.append(string5).toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    @Nullable
    public final String urlDecode(@Nullable String stringToEncode) {
        String string;
        try {
            string = URLDecoder.decode(stringToEncode, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Request signRequest(@NotNull Request originalRequest, @NotNull PNConfiguration pnConfiguration, int timestamp) {
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkNotNullParameter((Object)pnConfiguration, (String)"pnConfiguration");
        if (!PNConfiguration.Companion.isValid$pubnub_kotlin(pnConfiguration.getSecretKey())) {
            return originalRequest;
        }
        String signature = this.generateSignature(pnConfiguration, originalRequest, timestamp);
        HttpUrl rebuiltUrl = originalRequest.url().newBuilder().addQueryParameter(TIMESTAMP_QUERY_PARAM_NAME, String.valueOf(timestamp)).addQueryParameter(SIGNATURE_QUERY_PARAM_NAME, signature).build();
        return originalRequest.newBuilder().url(rebuiltUrl).build();
    }

    public final boolean shouldSignRequest(@NotNull PNConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return PNConfiguration.Companion.isValid$pubnub_kotlin(configuration.getSecretKey());
    }

    @NotNull
    public final String generateSignature(@NotNull PNConfiguration configuration, @NotNull String requestURL, @NotNull Map<String, String> queryParams, @NotNull String method, @Nullable String requestBody, int timestamp) {
        boolean isV2Signature;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)requestURL, (String)"requestURL");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        StringBuilder signatureBuilder = new StringBuilder();
        Map<String, String> map = queryParams;
        String string = TIMESTAMP_QUERY_PARAM_NAME;
        String string2 = String.valueOf(timestamp);
        boolean bl = false;
        map.put(string, string2);
        boolean classic = true;
        String encodedQueryString = this.preparePamArguments$pubnub_kotlin(queryParams);
        boolean bl2 = isV2Signature = !StringsKt.startsWith$default((String)requestURL, (String)"/publish", (boolean)false, (int)2, null) || !StringsKt.equals((String)method, (String)"post", (boolean)true);
        if (!isV2Signature) {
            signatureBuilder.append(configuration.getSubscribeKey()).append("\n");
            signatureBuilder.append(configuration.getPublishKey()).append("\n");
            signatureBuilder.append(requestURL).append("\n");
            signatureBuilder.append(encodedQueryString);
        } else {
            String string3 = method;
            boolean bl3 = false;
            String string4 = string3.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            signatureBuilder.append(string4).append("\n");
            signatureBuilder.append(configuration.getPublishKey()).append("\n");
            signatureBuilder.append(requestURL).append("\n");
            signatureBuilder.append(encodedQueryString).append("\n");
            signatureBuilder.append(requestBody);
        }
        String signature = "";
        try {
            String string5 = configuration.getSecretKey();
            String string6 = signatureBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"signatureBuilder.toString()");
            signature = this.signSHA256$pubnub_kotlin(string5, string6);
            if (isV2Signature) {
                signature = this.removeTrailingEqualSigns(signature);
                signature = Intrinsics.stringPlus((String)"v2.", (Object)signature);
            }
        }
        catch (PubNubException e) {
            log.warn(Intrinsics.stringPlus((String)"signature failed on SignatureInterceptor: ", (Object)e));
        }
        catch (UnsupportedEncodingException e) {
            log.warn(Intrinsics.stringPlus((String)"signature failed on SignatureInterceptor: ", (Object)e));
        }
        return signature;
    }

    @NotNull
    public final String signSHA256$pubnub_kotlin(@NotNull String key, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object sha256HMAC = null;
        byte[] hmacData = null;
        Object object = key;
        Object object2 = CHARSET;
        boolean bl = false;
        Charset charset = Charset.forName((String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
        object2 = charset;
        bl = false;
        byte[] byArray = ((String)object).getBytes((Charset)object2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        SecretKeySpec secretKey = new SecretKeySpec(byArray, "HmacSHA256");
        try {
            object = Mac.getInstance("HmacSHA256");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Mac.getIns\u2026e(\"HmacSHA256\")\n        }");
        }
        catch (NoSuchAlgorithmException e) {
            PubNubException pubNubException = Crypto.newCryptoError(0, e);
            Intrinsics.checkNotNullExpressionValue((Object)pubNubException, (String)"newCryptoError(0, e)");
            throw (Throwable)pubNubException;
        }
        sha256HMAC = object;
        try {
            ((Mac)sha256HMAC).init(secretKey);
        }
        catch (InvalidKeyException e) {
            object2 = Crypto.newCryptoError(0, e);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"newCryptoError(0, e)");
            throw (Throwable)object2;
        }
        object2 = data;
        Object object3 = CHARSET;
        boolean bl2 = false;
        Charset charset2 = Charset.forName((String)object3);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"Charset.forName(charsetName)");
        object3 = charset2;
        bl2 = false;
        byte[] byArray2 = ((String)object2).getBytes((Charset)object3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] e = ((Mac)sha256HMAC).doFinal(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"sha256HMAC.doFinal(data.\u2026eArray(charset(CHARSET)))");
        hmacData = e;
        object2 = Base64.encode(hmacData, 2);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"encode(hmacData, Base64.NO_WRAP)");
        object3 = Charset.forName(CHARSET);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"forName(CHARSET)");
        bl2 = false;
        String signed = StringsKt.replace$default((String)StringsKt.replace$default((String)new String((byte[])object2, (Charset)object3), (char)'+', (char)'-', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null);
        return signed;
    }

    private final String generateSignature(PNConfiguration configuration, Request request, int timestamp) {
        boolean bl = false;
        Map queryParams = new LinkedHashMap();
        for (String queryKey : request.url().queryParameterNames()) {
            String value = request.url().queryParameter(queryKey);
            if (value == null) continue;
            Map map = queryParams;
            boolean bl2 = false;
            map.put(queryKey, value);
        }
        return this.generateSignature(configuration, request.url().encodedPath(), queryParams, request.method(), this.requestBodyToString$pubnub_kotlin(request), timestamp);
    }

    @NotNull
    public final String removeTrailingEqualSigns(@NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)SIGNATURE_QUERY_PARAM_NAME);
        String cleanSignature = signature;
        while (cleanSignature.charAt(cleanSignature.length() - 1) == '=') {
            String string = cleanSignature;
            int n = 0;
            int n2 = cleanSignature.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return cleanSignature;
    }

    @Nullable
    public final String requestBodyToString$pubnub_kotlin(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() == null) {
            return "";
        }
        try {
            Buffer buffer = new Buffer();
            RequestBody requestBody = request.body();
            Intrinsics.checkNotNull((Object)requestBody);
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @NotNull
    public final String preparePamArguments$pubnub_kotlin(@NotNull Map<String, String> pamArgs) {
        Intrinsics.checkNotNullParameter(pamArgs, (String)"pamArgs");
        Set pamKeys = new TreeSet(pamArgs.keySet());
        String stringifiedArguments = "";
        int i = 0;
        for (String pamKey : pamKeys) {
            if (i != 0) {
                stringifiedArguments = Intrinsics.stringPlus((String)stringifiedArguments, (Object)"&");
            }
            StringBuilder stringBuilder = new StringBuilder().append(stringifiedArguments).append((Object)pamKey).append('=');
            Map<String, String> map = pamArgs;
            boolean bl = false;
            String string = map.get(pamKey);
            Intrinsics.checkNotNull((Object)string);
            stringifiedArguments = stringBuilder.append(PubNubUtil.pamEncode$pubnub_kotlin$default(this, string, false, 2, null)).toString();
            ++i;
        }
        return stringifiedArguments;
    }

    /*
     * WARNING - void declaration
     */
    private final String preparePamArguments(String encodedQueryString) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"&"};
        Iterable $this$map$iv = CollectionsKt.toSortedSet((Iterable)StringsKt.split$default((CharSequence)encodedQueryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String string2 = INSTANCE.pamEncode$pubnub_kotlin((String)it, true);
            collection.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String pamEncode$pubnub_kotlin(@NotNull String stringToEncode, boolean alreadyPercentEncoded) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)stringToEncode, (String)"stringToEncode");
        if (alreadyPercentEncoded) {
            string2 = stringToEncode;
        } else {
            string = URLEncoder.encode(stringToEncode, CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(stringToEncode, \"UTF-8\")");
            string2 = StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        }
        string = string2;
        boolean bl = false;
        boolean bl2 = false;
        String $this$pamEncode_u24lambda_u2d1 = string;
        boolean bl3 = false;
        return StringsKt.replace$default((String)$this$pamEncode_u24lambda_u2d1, (String)"*", (String)"%2A", (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String pamEncode$pubnub_kotlin$default(PubNubUtil pubNubUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return pubNubUtil.pamEncode$pubnub_kotlin(string, bl);
    }

    public final void require$pubnub_kotlin(boolean value, @NotNull PubNubError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        if (!value) {
            throw new PubNubException(error);
        }
    }
}

