/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNDownloadFileResult;
import com.pubnub.api.vendor.FileEncryptionUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J2\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u0018H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/pubnub/api/endpoints/files/DownloadFile;", "Lcom/pubnub/api/Endpoint;", "Lokhttp3/ResponseBody;", "Lcom/pubnub/api/models/consumer/files/PNDownloadFileResult;", "channel", "", "fileName", "fileId", "cipherKey", "pubNub", "Lcom/pubnub/api/PubNub;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/PubNub;)V", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "pubnub-kotlin"})
public final class DownloadFile
extends Endpoint<ResponseBody, PNDownloadFileResult> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileId;
    @Nullable
    private final String cipherKey;

    public DownloadFile(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable String cipherKey, @NotNull PubNub pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
        this.cipherKey = cipherKey;
    }

    public /* synthetic */ DownloadFile(String string, String string2, String string3, String string4, PubNub pubNub, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        this(string, string2, string3, string4, pubNub);
    }

    @Override
    protected void validateParams() throws PubNubException {
        CharSequence charSequence = this.channel;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<ResponseBody> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getFilesService$pubnub_kotlin().downloadFile(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, this.fileId, this.fileName, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNDownloadFileResult createResponse(@NotNull Response<ResponseBody> input) throws PubNubException {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (!input.isSuccessful()) {
            throw new PubNubException(PubNubError.HTTP_ERROR);
        }
        if (input.body() == null) {
            throw new PubNubException(PubNubError.INTERNAL_ERROR);
        }
        String effectiveCipherKey = FileEncryptionUtil.INSTANCE.effectiveCipherKey$pubnub_kotlin(this.getPubnub(), this.cipherKey);
        if (effectiveCipherKey == null) {
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            inputStream = ((ResponseBody)object).byteStream();
        } else {
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            inputStream = FileEncryptionUtil.INSTANCE.decrypt(((ResponseBody)object).byteStream(), effectiveCipherKey);
        }
        InputStream byteStream = inputStream;
        return new PNDownloadFileResult(this.fileName, byteStream);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }
}

