/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.push;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushRemoveChannelResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BC\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0014J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001aH\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/pubnub/api/endpoints/push/RemoveChannelsFromPush;", "Lcom/pubnub/api/Endpoint;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/push/PNPushRemoveChannelResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "pushType", "Lcom/pubnub/api/enums/PNPushType;", "channels", "", "", "deviceId", "topic", "environment", "Lcom/pubnub/api/enums/PNPushEnvironment;", "(Lcom/pubnub/api/PubNub;Lcom/pubnub/api/enums/PNPushType;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/enums/PNPushEnvironment;)V", "getChannels", "()Ljava/util/List;", "getDeviceId", "()Ljava/lang/String;", "getEnvironment", "()Lcom/pubnub/api/enums/PNPushEnvironment;", "getPushType", "()Lcom/pubnub/api/enums/PNPushType;", "getTopic", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNRemovePushNotificationsFromChannelsOperation;", "validateParams", "pubnub-kotlin"})
public final class RemoveChannelsFromPush
extends Endpoint<Void, PNPushRemoveChannelResult> {
    @NotNull
    private final PNPushType pushType;
    @NotNull
    private final List<String> channels;
    @NotNull
    private final String deviceId;
    @Nullable
    private final String topic;
    @NotNull
    private final PNPushEnvironment environment;

    public RemoveChannelsFromPush(@NotNull PubNub pubnub, @NotNull PNPushType pushType, @NotNull List<String> channels, @NotNull String deviceId, @Nullable String topic, @NotNull PNPushEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)((Object)pushType), (String)"pushType");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        super(pubnub);
        this.pushType = pushType;
        this.channels = channels;
        this.deviceId = deviceId;
        this.topic = topic;
        this.environment = environment;
    }

    public /* synthetic */ RemoveChannelsFromPush(PubNub pubNub, PNPushType pNPushType, List list, String string, String string2, PNPushEnvironment pNPushEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            pNPushEnvironment = PNPushEnvironment.DEVELOPMENT;
        }
        this(pubNub, pNPushType, list, string, string2, pNPushEnvironment);
    }

    @NotNull
    public final PNPushType getPushType() {
        return this.pushType;
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    @Nullable
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final PNPushEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.deviceId)) {
            throw new PubNubException(PubNubError.DEVICE_ID_MISSING);
        }
        if (this.channels.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.pushType == PNPushType.APNS2) {
            CharSequence charSequence = this.topic;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new PubNubException(PubNubError.PUSH_TOPIC_MISSING);
            }
        }
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.pushType != PNPushType.APNS2 ? this.getPubnub().getRetrofitManager$pubnub_kotlin().getPushService$pubnub_kotlin().modifyChannelsForDevice(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, (Map<String, String>)queryParams) : this.getPubnub().getRetrofitManager$pubnub_kotlin().getPushService$pubnub_kotlin().modifyChannelsForDeviceApns2(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPushRemoveChannelResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNPushRemoveChannelResult();
    }

    @Override
    @NotNull
    public PNOperationType.PNRemovePushNotificationsFromChannelsOperation operationType() {
        return PNOperationType.PNRemovePushNotificationsFromChannelsOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        Object object = queryParams;
        Object object2 = "remove";
        String string = PubNubUtilKt.toCsv(this.channels);
        boolean bl = false;
        object.put((String)object2, (String)string);
        if (this.pushType != PNPushType.APNS2) {
            object = queryParams;
            object2 = "type";
            string = this.pushType.toParamString();
            bl = false;
            object.put((String)object2, (String)string);
            return;
        }
        object = queryParams;
        object2 = "environment";
        string = this.environment.name();
        bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        string = string3;
        bl = false;
        object.put((String)object2, (String)string);
        object = this.topic;
        if (object != null) {
            object2 = object;
            boolean bl2 = false;
            bl = false;
            Object $this$addQueryParams_u24lambda_u2d0 = object2;
            boolean bl3 = false;
            Map<String, String> map = queryParams;
            String string4 = "topic";
            boolean bl4 = false;
            map.put(string4, (String)$this$addQueryParams_u24lambda_u2d0);
        }
    }
}

