/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.files.GenerateUploadUrl;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.files.UploadFile;
import com.pubnub.api.endpoints.remoteaction.ComposableRemoteAction;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.endpoints.remoteaction.RetryingRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0083\u0001\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019JB\u0010\u001d\u001a\u00020\u001e28\u0010\u001f\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u001e0 H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001eH\u0016J.\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u001eH\u0016J\n\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u00103\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u00064"}, d2={"Lcom/pubnub/api/endpoints/files/SendFile;", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/consumer/files/PNFileUploadResult;", "channel", "", "fileName", "inputStream", "Ljava/io/InputStream;", "message", "", "meta", "ttl", "", "shouldStore", "", "cipherKey", "fileMessagePublishRetryLimit", "executorService", "Ljava/util/concurrent/ExecutorService;", "generateUploadUrlFactory", "Lcom/pubnub/api/endpoints/files/GenerateUploadUrl$Factory;", "publishFileMessageFactory", "Lcom/pubnub/api/endpoints/files/PublishFileMessage$Factory;", "sendFileToS3Factory", "Lcom/pubnub/api/endpoints/files/UploadFile$Factory;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;ILjava/util/concurrent/ExecutorService;Lcom/pubnub/api/endpoints/files/GenerateUploadUrl$Factory;Lcom/pubnub/api/endpoints/files/PublishFileMessage$Factory;Lcom/pubnub/api/endpoints/files/UploadFile$Factory;)V", "sendFileMultistepAction", "Ljava/lang/Boolean;", "Ljava/lang/Integer;", "async", "", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "mapPublishFileMessageToFileUpload", "requestDetails", "Lcom/pubnub/api/models/server/files/FileUploadRequestDetails;", "res", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "retry", "sendFileComposedActions", "content", "", "silentCancel", "sync", "validate", "pubnub-kotlin"})
public final class SendFile
implements ExtendedRemoteAction<PNFileUploadResult> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @Nullable
    private final Object message;
    @Nullable
    private final Object meta;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final Boolean shouldStore;
    @Nullable
    private final String cipherKey;
    private final int fileMessagePublishRetryLimit;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileMultistepAction;

    public SendFile(@NotNull String channel, @NotNull String fileName, @NotNull InputStream inputStream, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, @Nullable String cipherKey, int fileMessagePublishRetryLimit, @NotNull ExecutorService executorService, @NotNull GenerateUploadUrl.Factory generateUploadUrlFactory, @NotNull PublishFileMessage.Factory publishFileMessageFactory, @NotNull UploadFile.Factory sendFileToS3Factory) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)generateUploadUrlFactory, (String)"generateUploadUrlFactory");
        Intrinsics.checkNotNullParameter((Object)publishFileMessageFactory, (String)"publishFileMessageFactory");
        Intrinsics.checkNotNullParameter((Object)sendFileToS3Factory, (String)"sendFileToS3Factory");
        this.channel = channel;
        this.fileName = fileName;
        this.message = message;
        this.meta = meta;
        this.ttl = ttl;
        this.shouldStore = shouldStore;
        this.cipherKey = cipherKey;
        this.fileMessagePublishRetryLimit = fileMessagePublishRetryLimit;
        this.executorService = executorService;
        this.sendFileMultistepAction = this.sendFileComposedActions(generateUploadUrlFactory, publishFileMessageFactory, sendFileToS3Factory, ByteStreamsKt.readBytes((InputStream)inputStream));
    }

    public /* synthetic */ SendFile(String string, String string2, InputStream inputStream, Object object, Object object2, Integer n, Boolean bl, String string3, int n2, ExecutorService executorService, GenerateUploadUrl.Factory factory, PublishFileMessage.Factory factory2, UploadFile.Factory factory3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            object = null;
        }
        if ((n3 & 0x10) != 0) {
            object2 = null;
        }
        if ((n3 & 0x20) != 0) {
            n = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = null;
        }
        if ((n3 & 0x80) != 0) {
            string3 = null;
        }
        this(string, string2, inputStream, object, object2, n, bl, string3, n2, executorService, factory, factory2, factory3);
    }

    @Override
    @Nullable
    public PNFileUploadResult sync() throws PubNubException {
        this.validate();
        return (PNFileUploadResult)this.sendFileMultistepAction.sync();
    }

    @Override
    public void async(@NotNull Function2<? super PNFileUploadResult, ? super PNStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.executorService.execute(() -> SendFile.async$lambda$0(this, callback));
    }

    private final void validate() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (((CharSequence)this.fileName).length() == 0) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "File name cannot be null nor empty", null, null, 0, null, 30, null);
        }
    }

    private final ExtendedRemoteAction<PNFileUploadResult> sendFileComposedActions(GenerateUploadUrl.Factory generateUploadUrlFactory, PublishFileMessage.Factory publishFileMessageFactory, UploadFile.Factory sendFileToS3Factory, byte[] content) {
        AtomicReference<FileUploadRequestDetails> result = new AtomicReference<FileUploadRequestDetails>();
        return ComposableRemoteAction.Companion.firstDo(generateUploadUrlFactory.create(this.channel, this.fileName)).then((Function1)new Function1<FileUploadRequestDetails, ExtendedRemoteAction<Unit>>(result, sendFileToS3Factory, this, content){
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            final /* synthetic */ UploadFile.Factory $sendFileToS3Factory;
            final /* synthetic */ SendFile this$0;
            final /* synthetic */ byte[] $content;
            {
                this.$result = $result;
                this.$sendFileToS3Factory = $sendFileToS3Factory;
                this.this$0 = $receiver;
                this.$content = $content;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<Unit> invoke(@NotNull FileUploadRequestDetails res) {
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                this.$result.set(res);
                return this.$sendFileToS3Factory.create(SendFile.access$getFileName$p(this.this$0), this.$content, SendFile.access$getCipherKey$p(this.this$0), res);
            }
        }).checkpoint().then((Function1)new Function1<Unit, ExtendedRemoteAction<PNPublishFileMessageResult>>(result, publishFileMessageFactory, this){
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            final /* synthetic */ PublishFileMessage.Factory $publishFileMessageFactory;
            final /* synthetic */ SendFile this$0;
            {
                this.$result = $result;
                this.$publishFileMessageFactory = $publishFileMessageFactory;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<PNPublishFileMessageResult> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FileUploadRequestDetails details = this.$result.get();
                return RetryingRemoteAction.Companion.autoRetry(this.$publishFileMessageFactory.create(SendFile.access$getChannel$p(this.this$0), details.getData().getName(), details.getData().getId(), SendFile.access$getMessage$p(this.this$0), SendFile.access$getMeta$p(this.this$0), SendFile.access$getTtl$p(this.this$0), SendFile.access$getShouldStore$p(this.this$0)), SendFile.access$getFileMessagePublishRetryLimit$p(this.this$0), PNOperationType.FileOperation.INSTANCE, SendFile.access$getExecutorService$p(this.this$0));
            }
        }).then((Function1)new Function1<PNPublishFileMessageResult, ExtendedRemoteAction<PNFileUploadResult>>(this, result){
            final /* synthetic */ SendFile this$0;
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<PNFileUploadResult> invoke(@NotNull PNPublishFileMessageResult res) {
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                FileUploadRequestDetails fileUploadRequestDetails = this.$result.get();
                Intrinsics.checkNotNullExpressionValue((Object)fileUploadRequestDetails, (String)"result.get()");
                return SendFile.access$mapPublishFileMessageToFileUpload(this.this$0, fileUploadRequestDetails, res);
            }
        });
    }

    private final ExtendedRemoteAction<PNFileUploadResult> mapPublishFileMessageToFileUpload(FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return MappingRemoteAction.Companion.map(res, this.operationType(), (Function1)new Function1<PNPublishFileMessageResult, PNFileUploadResult>(requestDetails){
            final /* synthetic */ FileUploadRequestDetails $requestDetails;
            {
                this.$requestDetails = $requestDetails;
                super(1);
            }

            @NotNull
            public final PNFileUploadResult invoke(@NotNull PNPublishFileMessageResult pnPublishFileMessageResult) {
                Intrinsics.checkNotNullParameter((Object)pnPublishFileMessageResult, (String)"pnPublishFileMessageResult");
                return new PNFileUploadResult(pnPublishFileMessageResult.getTimetoken(), 200, new PNBaseFile(this.$requestDetails.getData().getId(), this.$requestDetails.getData().getName()));
            }
        });
    }

    @Override
    public void retry() {
        this.sendFileMultistepAction.retry();
    }

    @Override
    public void silentCancel() {
        this.sendFileMultistepAction.silentCancel();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    private static final void async$lambda$0(SendFile this$0, Function2 $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        try {
            this$0.validate();
            this$0.sendFileMultistepAction.async((Function2<PNFileUploadResult, PNStatus, Unit>)$callback);
        }
        catch (PubNubException ex) {
            $callback.invoke(null, (Object)new PNStatus(PNStatusCategory.PNBadRequestCategory, true, this$0.operationType(), ex, null, null, null, null, null, null, null, 2032, null));
        }
    }

    public static final /* synthetic */ String access$getFileName$p(SendFile $this) {
        return $this.fileName;
    }

    public static final /* synthetic */ String access$getCipherKey$p(SendFile $this) {
        return $this.cipherKey;
    }

    public static final /* synthetic */ String access$getChannel$p(SendFile $this) {
        return $this.channel;
    }

    public static final /* synthetic */ Object access$getMessage$p(SendFile $this) {
        return $this.message;
    }

    public static final /* synthetic */ Object access$getMeta$p(SendFile $this) {
        return $this.meta;
    }

    public static final /* synthetic */ Integer access$getTtl$p(SendFile $this) {
        return $this.ttl;
    }

    public static final /* synthetic */ Boolean access$getShouldStore$p(SendFile $this) {
        return $this.shouldStore;
    }

    public static final /* synthetic */ int access$getFileMessagePublishRetryLimit$p(SendFile $this) {
        return $this.fileMessagePublishRetryLimit;
    }

    public static final /* synthetic */ ExecutorService access$getExecutorService$p(SendFile $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ ExtendedRemoteAction access$mapPublishFileMessageToFileUpload(SendFile $this, FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return $this.mapPublishFileMessageToFileUpload(requestDetails, res);
    }
}

