/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.presence.PNHereNowChannelData;
import com.pubnub.api.models.consumer.presence.PNHereNowOccupantData;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.models.server.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001BC\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001bH\u0014J(\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001d2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001eH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010!\u001a\u00020\fH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0016\u0010%\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/pubnub/api/endpoints/presence/HereNow;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNHereNowResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "channelGroups", "includeState", "", "includeUUIDs", "(Lcom/pubnub/api/PubNub;Ljava/util/List;Ljava/util/List;ZZ)V", "getChannelGroups", "()Ljava/util/List;", "getChannels", "getIncludeState", "()Z", "getIncludeUUIDs", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "isGlobalHereNow", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHereNowOperation;", "parseMultipleChannelResponse", "parseSingleChannelResponse", "prepareOccupantData", "", "Lcom/pubnub/api/models/consumer/presence/PNHereNowOccupantData;", "pubnub-kotlin"})
public final class HereNow
extends Endpoint<Envelope<JsonElement>, PNHereNowResult> {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    private final boolean includeState;
    private final boolean includeUUIDs;

    public HereNow(@NotNull PubNub pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, boolean includeState, boolean includeUUIDs) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.includeState = includeState;
        this.includeUUIDs = includeUUIDs;
    }

    public /* synthetic */ HereNow(PubNub pubNub, List list, List list2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(pubNub, list, list2, bl, bl2);
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public final boolean getIncludeState() {
        return this.includeState;
    }

    public final boolean getIncludeUUIDs() {
        return this.includeUUIDs;
    }

    private final boolean isGlobalHereNow() {
        return this.channels.isEmpty() && this.channelGroups.isEmpty();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return !this.isGlobalHereNow() ? this.getPubnub().getRetrofitManager$pubnub_kotlin().getPresenceService$pubnub_kotlin().hereNow(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams) : this.getPubnub().getRetrofitManager$pubnub_kotlin().getPresenceService$pubnub_kotlin().globalHereNow(this.getPubnub().getConfiguration().getSubscribeKey(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHereNowResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        PNHereNowResult pNHereNowResult;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (this.isGlobalHereNow() || this.channels.size() > 1 || !((Collection)this.channelGroups).isEmpty()) {
            Envelope envelope = (Envelope)input.body();
            Object object = envelope != null ? (JsonElement)envelope.getPayload$pubnub_kotlin() : null;
            Intrinsics.checkNotNull((Object)object);
            pNHereNowResult = this.parseMultipleChannelResponse((JsonElement)object);
        } else {
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            pNHereNowResult = this.parseSingleChannelResponse((Envelope)object);
        }
        return pNHereNowResult;
    }

    @Override
    @NotNull
    public PNOperationType.PNHereNowOperation operationType() {
        return PNOperationType.PNHereNowOperation.INSTANCE;
    }

    private final PNHereNowResult parseSingleChannelResponse(Envelope<JsonElement> input) {
        PNHereNowResult pnHereNowResult = new PNHereNowResult(1, input.getOccupancy$pubnub_kotlin(), null, 4, null);
        PNHereNowChannelData pnHereNowChannelData = new PNHereNowChannelData(this.channels.get(0), input.getOccupancy$pubnub_kotlin(), null, 4, null);
        if (this.includeUUIDs) {
            JsonElement jsonElement = input.getUuids$pubnub_kotlin();
            Intrinsics.checkNotNull((Object)jsonElement);
            pnHereNowChannelData.setOccupants(this.prepareOccupantData(jsonElement));
            ((Map)pnHereNowResult.getChannels()).put(this.channels.get(0), pnHereNowChannelData);
        }
        return pnHereNowResult;
    }

    private final PNHereNowResult parseMultipleChannelResponse(JsonElement input) {
        PNHereNowResult pnHereNowResult = new PNHereNowResult(this.getPubnub().getMapper().elementToInt(input, "total_channels"), this.getPubnub().getMapper().elementToInt(input, "total_occupancy"), null, 4, null);
        Iterator<Map.Entry<String, JsonElement>> it = this.getPubnub().getMapper().getObjectIterator(input, "channels");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> entry = it.next();
            String string = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.key");
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonElement jsonElement = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"entry.value");
            PNHereNowChannelData pnHereNowChannelData = new PNHereNowChannelData(string, mapperManager.elementToInt(jsonElement, "occupancy"), null, 4, null);
            if (this.includeUUIDs) {
                JsonElement jsonElement2 = this.getPubnub().getMapper().getField(entry.getValue(), "uuids");
                Intrinsics.checkNotNull((Object)jsonElement2);
                pnHereNowChannelData.setOccupants(this.prepareOccupantData(jsonElement2));
            }
            Map map = pnHereNowResult.getChannels();
            String string2 = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.key");
            map.put(string2, pnHereNowChannelData);
        }
        return pnHereNowResult;
    }

    private final List<PNHereNowOccupantData> prepareOccupantData(JsonElement input) {
        List occupantsResults = new ArrayList();
        Iterator<JsonElement> it = this.getPubnub().getMapper().getArrayIterator(input);
        while (true) {
            PNHereNowOccupantData pNHereNowOccupantData;
            Iterator<JsonElement> iterator = it;
            Boolean bl = iterator != null ? Boolean.valueOf(iterator.hasNext()) : null;
            Intrinsics.checkNotNull((Object)bl);
            if (!bl.booleanValue()) break;
            JsonElement occupant = it.next();
            if (this.includeState) {
                String string = this.getPubnub().getMapper().elementToString(occupant, "uuid");
                Intrinsics.checkNotNull((Object)string);
                pNHereNowOccupantData = new PNHereNowOccupantData(string, this.getPubnub().getMapper().getField(occupant, "state"));
            } else {
                String string = this.getPubnub().getMapper().elementToString(occupant);
                Intrinsics.checkNotNull((Object)string);
                pNHereNowOccupantData = new PNHereNowOccupantData(string, null, 2, null);
            }
            occupantsResults.add(pNHereNowOccupantData);
        }
        return occupantsResults;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (this.includeState) {
            queryParams.put("state", "1");
        }
        if (!this.includeUUIDs) {
            queryParams.put("disable_uuids", "1");
        }
        if (!((Collection)this.channelGroups).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.channelGroups));
        }
    }
}

