/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.pubsub;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.vendor.Crypto;
import com.pubnub.extension.BooleanKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001BW\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0$H\u0002J\u001c\u0010%\u001a\u00020\u00042\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020'H\u0014J8\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020)2\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0*j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`+H\u0014J\u0010\u0010,\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0014J\u0018\u0010.\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0018\u0010/\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\fH\u0014J\b\u00101\u001a\u000202H\u0016J\"\u00103\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\f2\b\b\u0002\u00104\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020\"H\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018\u00a8\u00066"}, d2={"Lcom/pubnub/api/endpoints/pubsub/Publish;", "Lcom/pubnub/api/Endpoint;", "", "", "Lcom/pubnub/api/models/consumer/PNPublishResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "message", "channel", "", "meta", "shouldStore", "", "usePost", "replicate", "ttl", "", "(Lcom/pubnub/api/PubNub;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Boolean;ZZLjava/lang/Integer;)V", "getChannel", "()Ljava/lang/String;", "getMessage", "()Ljava/lang/Object;", "getMeta", "getReplicate", "()Z", "getShouldStore", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getTtl", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "useEncryption", "getUsePost", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "encryptMessage", "getAffectedChannels", "getBodyMessage", "getParamMessage", "isPubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNPublishOperation;", "prepareMessage", "wrapEncrypted", "validateParams", "pubnub-kotlin"})
public final class Publish
extends Endpoint<List<? extends Object>, PNPublishResult> {
    @NotNull
    private final Object message;
    @NotNull
    private final String channel;
    @Nullable
    private final Object meta;
    @Nullable
    private final Boolean shouldStore;
    private final boolean usePost;
    private final boolean replicate;
    @Nullable
    private final Integer ttl;
    private final boolean useEncryption;

    public Publish(@NotNull PubNub pubnub, @NotNull Object message, @NotNull String channel, @Nullable Object meta, @Nullable Boolean shouldStore, boolean usePost, boolean replicate, @Nullable Integer ttl) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.message = message;
        this.channel = channel;
        this.meta = meta;
        this.shouldStore = shouldStore;
        this.usePost = usePost;
        this.replicate = replicate;
        this.ttl = ttl;
        this.useEncryption = PNConfiguration.Companion.isValid$pubnub_kotlin(pubnub.getConfiguration().getCipherKey());
    }

    public /* synthetic */ Publish(PubNub pubNub, Object object, String string, Object object2, Boolean bl, boolean bl2, boolean bl3, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            object2 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x80) != 0) {
            n = null;
        }
        this(pubNub, object, string, object2, bl, bl2, bl3, n);
    }

    @NotNull
    public final Object getMessage() {
        return this.message;
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    @Nullable
    public final Object getMeta() {
        return this.meta;
    }

    @Nullable
    public final Boolean getShouldStore() {
        return this.shouldStore;
    }

    public final boolean getUsePost() {
        return this.usePost;
    }

    public final boolean getReplicate() {
        return this.replicate;
    }

    @Nullable
    public final Integer getTtl() {
        return this.ttl;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channel)) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) {
        Call<List<Object>> call;
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        if (this.usePost) {
            Object payload = this.getBodyMessage(this.message, this.useEncryption);
            call = this.getPubnub().getRetrofitManager$pubnub_kotlin().getPublishService$pubnub_kotlin().publishWithPost(this.getPubnub().getConfiguration().getPublishKey(), this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, payload, (Map<String, String>)queryParams);
        } else {
            String stringifiedMessage = this.getParamMessage(this.message, this.useEncryption);
            call = this.getPubnub().getRetrofitManager$pubnub_kotlin().getPublishService$pubnub_kotlin().publish(this.getPubnub().getConfiguration().getPublishKey(), this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, stringifiedMessage, (Map<String, String>)queryParams);
        }
        return call;
    }

    @Override
    @NotNull
    protected PNPublishResult createResponse(@NotNull Response<List<Object>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPublishResult(Long.parseLong(((List)object).get(2).toString()));
    }

    @Override
    @NotNull
    public PNOperationType.PNPublishOperation operationType() {
        return PNOperationType.PNPublishOperation.INSTANCE;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        Object object = this.meta;
        if (object != null) {
            Object $this$addQueryParams_u24lambda_u240 = object;
            boolean bl = false;
            queryParams.put("meta", this.getPubnub().getMapper().toJson($this$addQueryParams_u24lambda_u240));
        }
        Boolean bl = this.shouldStore;
        if (bl != null) {
            boolean $this$addQueryParams_u24lambda_u241 = bl;
            boolean bl2 = false;
            queryParams.put("store", BooleanKt.getNumericString($this$addQueryParams_u24lambda_u241));
        }
        Integer n = this.ttl;
        if (n != null) {
            int $this$addQueryParams_u24lambda_u242 = ((Number)n).intValue();
            boolean bl3 = false;
            queryParams.put("ttl", String.valueOf($this$addQueryParams_u24lambda_u242));
        }
        if (!this.replicate) {
            queryParams.put("norep", BooleanKt.getValueString(true));
        }
        queryParams.put("seqn", String.valueOf(this.getPubnub().getPublishSequenceManager$pubnub_kotlin().nextSequence$pubnub_kotlin()));
    }

    private final Object getBodyMessage(Object message, boolean useEncryption) {
        return useEncryption ? Publish.prepareMessage$default(this, message, useEncryption, false, 4, null) : message;
    }

    private final String getParamMessage(Object message, boolean useEncryption) {
        return this.prepareMessage(message, useEncryption, true);
    }

    private final String prepareMessage(Object message, boolean useEncryption, boolean wrapEncrypted) {
        String string;
        String json = string = this.getPubnub().getMapper().toJson(message);
        boolean bl = false;
        if (useEncryption) {
            String string2;
            String encrypted = string2 = this.encryptMessage(json);
            boolean bl2 = false;
            if (wrapEncrypted) {
                return '\"' + encrypted + '\"';
            }
            return string2;
        }
        return string;
    }

    static /* synthetic */ String prepareMessage$default(Publish publish, Object object, boolean bl, boolean bl2, int n, Object object2) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return publish.prepareMessage(object, bl, bl2);
    }

    private final String encryptMessage(String message) {
        String string = new Crypto(this.getPubnub().getConfiguration().getCipherKey(), this.getPubnub().getConfiguration().getUseRandomInitializationVector()).encrypt(message);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Crypto(pubnub.configurat\u2026        .encrypt(message)");
        return string;
    }
}

