/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.pubsub;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNPublishResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0011H\u0014J8\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00132\"\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0015j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u0016H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0002H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/pubnub/api/endpoints/pubsub/Signal;", "Lcom/pubnub/api/Endpoint;", "", "", "Lcom/pubnub/api/models/consumer/PNPublishResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channel", "", "message", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;Ljava/lang/Object;)V", "getChannel", "()Ljava/lang/String;", "getMessage", "()Ljava/lang/Object;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "isPubKeyRequired", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSignalOperation;", "validateParams", "", "pubnub-kotlin"})
public final class Signal
extends Endpoint<List<? extends Object>, PNPublishResult> {
    @NotNull
    private final String channel;
    @NotNull
    private final Object message;

    public Signal(@NotNull PubNub pubnub, @NotNull String channel, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(pubnub);
        this.channel = channel;
        this.message = message;
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    @NotNull
    public final Object getMessage() {
        return this.message;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channel)) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getSignalService$pubnub_kotlin().signal(this.getPubnub().getConfiguration().getPublishKey(), this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, this.getPubnub().getMapper().toJson(this.message), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPublishResult createResponse(@NotNull Response<List<Object>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPublishResult(Long.parseLong(((List)object).get(2).toString()));
    }

    @Override
    @NotNull
    public PNOperationType.PNSignalOperation operationType() {
        return PNOperationType.PNSignalOperation.INSTANCE;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }
}

