/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.crypto;

import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.vendor.Base64;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\bH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\bH\u0000\u001a(\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0006H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u00a8\u0006\u0011"}, d2={"checkMinSize", "", "Ljava/io/BufferedInputStream;", "size", "", "exceptionBlock", "Lkotlin/Function1;", "decryptString", "", "Lcom/pubnub/api/crypto/CryptoModule;", "inputString", "encryptString", "readExactlyNBytez", "", "readNBytez", "Ljava/io/InputStream;", "len", "pubnub-kotlin"})
public final class CryptoModuleKt {
    @NotNull
    public static final String encryptString(@NotNull CryptoModule $this$encryptString, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)$this$encryptString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        String string = inputString;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Base64.encode($this$encryptString.encrypt(byArray), 2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(encrypt(inputStri\u2026Array()), Base64.NO_WRAP)");
        byte[] byArray3 = byArray2;
        return new String(byArray3, Charsets.UTF_8);
    }

    @NotNull
    public static final String decryptString(@NotNull CryptoModule $this$decryptString, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)$this$decryptString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        byte[] byArray = Base64.decode(inputString, 2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(inputString, Base64.NO_WRAP)");
        byte[] byArray2 = $this$decryptString.decrypt(byArray);
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    public static final void checkMinSize(@NotNull BufferedInputStream $this$checkMinSize, int size, @NotNull Function1<? super Integer, Unit> exceptionBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$checkMinSize, (String)"<this>");
        Intrinsics.checkNotNullParameter(exceptionBlock, (String)"exceptionBlock");
        $this$checkMinSize.mark(size + 1);
        byte[] readBytes = CryptoModuleKt.readNBytez($this$checkMinSize, size);
        $this$checkMinSize.reset();
        if (readBytes.length < size) {
            exceptionBlock.invoke((Object)size);
        }
    }

    @NotNull
    public static final byte[] readExactlyNBytez(@NotNull BufferedInputStream $this$readExactlyNBytez, int size, @NotNull Function1<? super Integer, Unit> exceptionBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$readExactlyNBytez, (String)"<this>");
        Intrinsics.checkNotNullParameter(exceptionBlock, (String)"exceptionBlock");
        byte[] readBytes = CryptoModuleKt.readNBytez($this$readExactlyNBytez, size);
        if (readBytes.length < size) {
            exceptionBlock.invoke((Object)size);
        }
        return readBytes;
    }

    @NotNull
    public static final byte[] readNBytez(@NotNull InputStream $this$readNBytez, int len) {
        Intrinsics.checkNotNullParameter((Object)$this$readNBytez, (String)"<this>");
        int remaining = len;
        int n = 0;
        byte[] originalArray = new byte[remaining];
        int nread = 0;
        while (true) {
            int n2;
            int it = n2 = $this$readNBytez.read(originalArray, nread, Integer.min(originalArray.length - nread, remaining));
            boolean bl = false;
            n = it;
            if (n2 <= 0) break;
            nread += n;
            remaining -= n;
        }
        byte[] byArray = Arrays.copyOf(originalArray, nread);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        return byArray;
    }
}

