/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.cryptor.InputStreamSeparator;
import com.pubnub.api.endpoints.files.GenerateUploadUrl;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.files.UploadFile;
import com.pubnub.api.endpoints.remoteaction.ComposableRemoteAction;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteActionKt;
import com.pubnub.api.endpoints.remoteaction.RetryingRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0083\u0001\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJB\u0010\u001e\u001a\u00020\u001f28\u0010 \u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u001f0!H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J8\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u00100\u001a\u00020\u001fH\u0016J\n\u00101\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u00102\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u00063"}, d2={"Lcom/pubnub/api/endpoints/files/SendFile;", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/consumer/files/PNFileUploadResult;", "channel", "", "fileName", "inputStream", "Ljava/io/InputStream;", "message", "", "meta", "ttl", "", "shouldStore", "", "fileMessagePublishRetryLimit", "executorService", "Ljava/util/concurrent/ExecutorService;", "generateUploadUrlFactory", "Lcom/pubnub/api/endpoints/files/GenerateUploadUrl$Factory;", "publishFileMessageFactory", "Lcom/pubnub/api/endpoints/files/PublishFileMessage$Factory;", "sendFileToS3Factory", "Lcom/pubnub/api/endpoints/files/UploadFile$Factory;", "cryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;ILjava/util/concurrent/ExecutorService;Lcom/pubnub/api/endpoints/files/GenerateUploadUrl$Factory;Lcom/pubnub/api/endpoints/files/PublishFileMessage$Factory;Lcom/pubnub/api/endpoints/files/UploadFile$Factory;Lcom/pubnub/api/crypto/CryptoModule;)V", "sendFileMultistepAction", "Ljava/lang/Boolean;", "Ljava/lang/Integer;", "async", "", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "mapPublishFileMessageToFileUpload", "requestDetails", "Lcom/pubnub/api/models/server/files/FileUploadRequestDetails;", "res", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "retry", "sendFileComposedActions", "silentCancel", "sync", "validate", "pubnub-kotlin"})
public final class SendFile
implements ExtendedRemoteAction<PNFileUploadResult> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @Nullable
    private final Object message;
    @Nullable
    private final Object meta;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final Boolean shouldStore;
    private final int fileMessagePublishRetryLimit;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileMultistepAction;

    public SendFile(@NotNull String channel, @NotNull String fileName, @NotNull InputStream inputStream, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, int fileMessagePublishRetryLimit, @NotNull ExecutorService executorService, @NotNull GenerateUploadUrl.Factory generateUploadUrlFactory, @NotNull PublishFileMessage.Factory publishFileMessageFactory, @NotNull UploadFile.Factory sendFileToS3Factory, @Nullable CryptoModule cryptoModule) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)generateUploadUrlFactory, (String)"generateUploadUrlFactory");
        Intrinsics.checkNotNullParameter((Object)publishFileMessageFactory, (String)"publishFileMessageFactory");
        Intrinsics.checkNotNullParameter((Object)sendFileToS3Factory, (String)"sendFileToS3Factory");
        this.channel = channel;
        this.fileName = fileName;
        this.message = message;
        this.meta = meta;
        this.ttl = ttl;
        this.shouldStore = shouldStore;
        this.fileMessagePublishRetryLimit = fileMessagePublishRetryLimit;
        this.executorService = executorService;
        this.sendFileMultistepAction = this.sendFileComposedActions(generateUploadUrlFactory, publishFileMessageFactory, sendFileToS3Factory, inputStream, cryptoModule);
    }

    public /* synthetic */ SendFile(String string, String string2, InputStream inputStream, Object object, Object object2, Integer n, Boolean bl, int n2, ExecutorService executorService, GenerateUploadUrl.Factory factory, PublishFileMessage.Factory factory2, UploadFile.Factory factory3, CryptoModule cryptoModule, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            object = null;
        }
        if ((n3 & 0x10) != 0) {
            object2 = null;
        }
        if ((n3 & 0x20) != 0) {
            n = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = null;
        }
        if ((n3 & 0x1000) != 0) {
            cryptoModule = null;
        }
        this(string, string2, inputStream, object, object2, n, bl, n2, executorService, factory, factory2, factory3, cryptoModule);
    }

    @Override
    @Nullable
    public PNFileUploadResult sync() throws PubNubException {
        this.validate();
        return (PNFileUploadResult)this.sendFileMultistepAction.sync();
    }

    @Override
    public void async(@NotNull Function2<? super PNFileUploadResult, ? super PNStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.executorService.execute(() -> SendFile.async$lambda$0(this, callback));
    }

    private final void validate() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (((CharSequence)this.fileName).length() == 0) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "File name cannot be null nor empty", null, null, 0, null, 30, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileComposedActions(GenerateUploadUrl.Factory generateUploadUrlFactory, PublishFileMessage.Factory publishFileMessageFactory, UploadFile.Factory sendFileToS3Factory, InputStream inputStream, CryptoModule cryptoModule) {
        Object object;
        AtomicReference<FileUploadRequestDetails> result;
        block9: {
            block8: {
                byte[] byArray;
                result = new AtomicReference<FileUploadRequestDetails>();
                object = cryptoModule;
                if (object == null || (object = ((CryptoModule)object).encryptStream(new InputStreamSeparator(inputStream))) == null) break block8;
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes((InputStream)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = byArray;
                if (byArray != null) break block9;
            }
            object = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        Object content = object;
        return MappingRemoteActionKt.map(ComposableRemoteAction.Companion.firstDo(generateUploadUrlFactory.create(this.channel, this.fileName)).then((Function1)new Function1<FileUploadRequestDetails, ExtendedRemoteAction<Unit>>(result, sendFileToS3Factory, this, (byte[])content){
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            final /* synthetic */ UploadFile.Factory $sendFileToS3Factory;
            final /* synthetic */ SendFile this$0;
            final /* synthetic */ byte[] $content;
            {
                this.$result = $result;
                this.$sendFileToS3Factory = $sendFileToS3Factory;
                this.this$0 = $receiver;
                this.$content = $content;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<Unit> invoke(@NotNull FileUploadRequestDetails res) {
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                this.$result.set(res);
                return this.$sendFileToS3Factory.create(SendFile.access$getFileName$p(this.this$0), this.$content, res);
            }
        }).checkpoint().then((Function1)new Function1<Unit, ExtendedRemoteAction<PNPublishFileMessageResult>>(result, publishFileMessageFactory, this){
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            final /* synthetic */ PublishFileMessage.Factory $publishFileMessageFactory;
            final /* synthetic */ SendFile this$0;
            {
                this.$result = $result;
                this.$publishFileMessageFactory = $publishFileMessageFactory;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<PNPublishFileMessageResult> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FileUploadRequestDetails details = this.$result.get();
                return RetryingRemoteAction.Companion.autoRetry(this.$publishFileMessageFactory.create(SendFile.access$getChannel$p(this.this$0), details.getData().getName(), details.getData().getId(), SendFile.access$getMessage$p(this.this$0), SendFile.access$getMeta$p(this.this$0), SendFile.access$getTtl$p(this.this$0), SendFile.access$getShouldStore$p(this.this$0)), SendFile.access$getFileMessagePublishRetryLimit$p(this.this$0), PNOperationType.FileOperation.INSTANCE, SendFile.access$getExecutorService$p(this.this$0));
            }
        }), (Function1)new Function1<PNPublishFileMessageResult, PNFileUploadResult>(this, result){
            final /* synthetic */ SendFile this$0;
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final PNFileUploadResult invoke(@NotNull PNPublishFileMessageResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FileUploadRequestDetails fileUploadRequestDetails = this.$result.get();
                Intrinsics.checkNotNullExpressionValue((Object)fileUploadRequestDetails, (String)"result.get()");
                return SendFile.access$mapPublishFileMessageToFileUpload(this.this$0, fileUploadRequestDetails, it);
            }
        });
    }

    private final PNFileUploadResult mapPublishFileMessageToFileUpload(FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return new PNFileUploadResult(res.getTimetoken(), 200, new PNBaseFile(requestDetails.getData().getId(), requestDetails.getData().getName()));
    }

    @Override
    public void retry() {
        this.sendFileMultistepAction.retry();
    }

    @Override
    public void silentCancel() {
        this.sendFileMultistepAction.silentCancel();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    private static final void async$lambda$0(SendFile this$0, Function2 $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        try {
            this$0.validate();
            this$0.sendFileMultistepAction.async((Function2<PNFileUploadResult, PNStatus, Unit>)$callback);
        }
        catch (PubNubException ex) {
            $callback.invoke(null, (Object)new PNStatus(PNStatusCategory.PNBadRequestCategory, true, this$0.operationType(), ex, null, null, null, null, null, null, null, 2032, null));
        }
    }

    public static final /* synthetic */ String access$getFileName$p(SendFile $this) {
        return $this.fileName;
    }

    public static final /* synthetic */ String access$getChannel$p(SendFile $this) {
        return $this.channel;
    }

    public static final /* synthetic */ Object access$getMessage$p(SendFile $this) {
        return $this.message;
    }

    public static final /* synthetic */ Object access$getMeta$p(SendFile $this) {
        return $this.meta;
    }

    public static final /* synthetic */ Integer access$getTtl$p(SendFile $this) {
        return $this.ttl;
    }

    public static final /* synthetic */ Boolean access$getShouldStore$p(SendFile $this) {
        return $this.shouldStore;
    }

    public static final /* synthetic */ int access$getFileMessagePublishRetryLimit$p(SendFile $this) {
        return $this.fileMessagePublishRetryLimit;
    }

    public static final /* synthetic */ ExecutorService access$getExecutorService$p(SendFile $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ PNFileUploadResult access$mapPublishFileMessageToFileUpload(SendFile $this, FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return $this.mapPublishFileMessageToFileUpload(requestDetails, res);
    }
}

