/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.pubsub;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.server.SubscribeEnvelope;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0(H\u0002J\u0018\u0010)\u001a\u0004\u0018\u00010\u00022\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0014J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0(H\u0014J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020&H\u0014R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00063"}, d2={"Lcom/pubnub/api/endpoints/pubsub/Subscribe;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/SubscribeEnvelope;", "pubnub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "channelGroups", "", "", "getChannelGroups", "()Ljava/util/List;", "setChannelGroups", "(Ljava/util/List;)V", "channels", "getChannels", "setChannels", "filterExpression", "getFilterExpression", "()Ljava/lang/String;", "setFilterExpression", "(Ljava/lang/String;)V", "region", "getRegion", "setRegion", "state", "", "getState", "()Ljava/lang/Object;", "setState", "(Ljava/lang/Object;)V", "timetoken", "", "getTimetoken", "()Ljava/lang/Long;", "setTimetoken", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "addQueryParams", "", "queryParams", "Ljava/util/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "getAffectedChannelGroups", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSubscribeOperation;", "validateParams", "pubnub-kotlin"})
public final class Subscribe
extends Endpoint<SubscribeEnvelope, SubscribeEnvelope> {
    @NotNull
    private List<String> channels;
    @NotNull
    private List<String> channelGroups;
    @Nullable
    private Long timetoken;
    @Nullable
    private String region;
    @Nullable
    private Object state;
    @Nullable
    private String filterExpression;

    public Subscribe(@NotNull PubNub pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        super(pubnub);
        this.channels = CollectionsKt.emptyList();
        this.channelGroups = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    public final void setChannels(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channels = list;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public final void setChannelGroups(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channelGroups = list;
    }

    @Nullable
    public final Long getTimetoken() {
        return this.timetoken;
    }

    public final void setTimetoken(@Nullable Long l) {
        this.timetoken = l;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    public final void setRegion(@Nullable String string) {
        this.region = string;
    }

    @Nullable
    public final Object getState() {
        return this.state;
    }

    public final void setState(@Nullable Object object) {
        this.state = object;
    }

    @Nullable
    public final String getFilterExpression() {
        return this.filterExpression;
    }

    public final void setFilterExpression(@Nullable String string) {
        this.filterExpression = string;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty() && this.channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    protected Call<SubscribeEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams(queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getSubscribeService$pubnub_kotlin().subscribe(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams);
    }

    private final void addQueryParams(HashMap<String, String> queryParams) {
        CharSequence charSequence;
        if (!((Collection)this.channelGroups).isEmpty()) {
            ((Map)queryParams).put("channel-group", CollectionsKt.joinToString$default((Iterable)this.channelGroups, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((charSequence = (CharSequence)this.filterExpression) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Map map = queryParams;
            String string = this.filterExpression;
            Intrinsics.checkNotNull((Object)string);
            map.put("filter-expr", string);
        }
        Long l = this.timetoken;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            ((Map)queryParams).put("tt", String.valueOf(it));
        }
        String string = this.region;
        if (string != null) {
            String it = string;
            boolean bl = false;
            ((Map)queryParams).put("tr", it);
        }
        ((Map)queryParams).put("heartbeat", String.valueOf(this.getPubnub().getConfiguration().getPresenceTimeout()));
        Object object = this.state;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            ((Map)queryParams).put("state", this.getPubnub().getMapper().toJson(it));
        }
        PubNubUtil.INSTANCE.maybeAddEeQueryParam$pubnub_kotlin(this.getPubnub().getConfiguration(), (Map<String, String>)queryParams);
    }

    @Override
    @Nullable
    protected SubscribeEnvelope createResponse(@NotNull Response<SubscribeEnvelope> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return (SubscribeEnvelope)object;
    }

    @Override
    @NotNull
    public PNOperationType.PNSubscribeOperation operationType() {
        return PNOperationType.PNSubscribeOperation.INSTANCE;
    }
}

