/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.eventengine;

import com.pubnub.api.eventengine.Cancel;
import com.pubnub.api.eventengine.Effect;
import com.pubnub.api.eventengine.EffectFactory;
import com.pubnub.api.eventengine.EffectInvocation;
import com.pubnub.api.eventengine.EffectInvocationType;
import com.pubnub.api.eventengine.Managed;
import com.pubnub.api.eventengine.ManagedEffect;
import com.pubnub.api.eventengine.NonManaged;
import com.pubnub.api.eventengine.Source;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BA\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pubnub/api/eventengine/EffectDispatcher;", "T", "Lcom/pubnub/api/eventengine/EffectInvocation;", "", "effectFactory", "Lcom/pubnub/api/eventengine/EffectFactory;", "effectSource", "Lcom/pubnub/api/eventengine/Source;", "managedEffects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/pubnub/api/eventengine/ManagedEffect;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/pubnub/api/eventengine/EffectFactory;Lcom/pubnub/api/eventengine/Source;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/ExecutorService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "dispatch", "", "effectInvocation", "dispatch$pubnub_kotlin", "(Lcom/pubnub/api/eventengine/EffectInvocation;)V", "start", "stop", "pubnub-kotlin"})
public final class EffectDispatcher<T extends EffectInvocation> {
    @NotNull
    private final EffectFactory<T> effectFactory;
    @NotNull
    private final Source<T> effectSource;
    @NotNull
    private final ConcurrentHashMap<String, ManagedEffect> managedEffects;
    @NotNull
    private final ExecutorService executorService;
    private final Logger log;

    public EffectDispatcher(@NotNull EffectFactory<T> effectFactory, @NotNull Source<T> effectSource, @NotNull ConcurrentHashMap<String, ManagedEffect> managedEffects, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(effectFactory, (String)"effectFactory");
        Intrinsics.checkNotNullParameter(effectSource, (String)"effectSource");
        Intrinsics.checkNotNullParameter(managedEffects, (String)"managedEffects");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.effectFactory = effectFactory;
        this.effectSource = effectSource;
        this.managedEffects = managedEffects;
        this.executorService = executorService;
        this.log = LoggerFactory.getLogger(EffectDispatcher.class);
    }

    public /* synthetic */ EffectDispatcher(EffectFactory effectFactory, Source source, ConcurrentHashMap concurrentHashMap, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            concurrentHashMap = new ConcurrentHashMap<String, ManagedEffect>();
        }
        if ((n & 8) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(effectFactory, source, concurrentHashMap, executorService);
    }

    public final void start() {
        this.executorService.submit(() -> EffectDispatcher.start$lambda$0(this));
    }

    public final void stop() {
        this.executorService.shutdownNow();
    }

    public final void dispatch$pubnub_kotlin(@NotNull T effectInvocation) {
        block4: {
            EffectInvocationType type;
            block5: {
                block3: {
                    Intrinsics.checkNotNullParameter(effectInvocation, (String)"effectInvocation");
                    this.log.trace("Dispatching effect: " + effectInvocation);
                    type = effectInvocation.getType();
                    if (!(type instanceof Cancel)) break block3;
                    ManagedEffect managedEffect = this.managedEffects.remove(((Cancel)type).getIdToCancel());
                    if (managedEffect == null) break block4;
                    managedEffect.cancel();
                    break block4;
                }
                if (!(type instanceof Managed)) break block5;
                ManagedEffect managedEffect = this.managedEffects.remove(effectInvocation.getId());
                if (managedEffect != null) {
                    managedEffect.cancel();
                }
                Effect effect = this.effectFactory.create(effectInvocation);
                ManagedEffect managedEffect2 = effect instanceof ManagedEffect ? (ManagedEffect)effect : null;
                if (managedEffect2 == null) {
                    return;
                }
                ManagedEffect managedEffect3 = managedEffect2;
                ((Map)this.managedEffects).put(effectInvocation.getId(), managedEffect3);
                managedEffect3.runEffect();
                break block4;
            }
            if (!(type instanceof NonManaged)) break block4;
            Effect effect = this.effectFactory.create(effectInvocation);
            if (effect != null) {
                effect.runEffect();
            }
        }
    }

    private static final void start$lambda$0(EffectDispatcher this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            while (true) {
                EffectInvocation invocation = (EffectInvocation)this$0.effectSource.take();
                this$0.dispatch$pubnub_kotlin(invocation);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

