/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.presence.eventengine.effect;

import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.eventengine.Effect;
import com.pubnub.api.eventengine.EffectFactory;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.presence.eventengine.effect.DelayedHeartbeatEffect;
import com.pubnub.api.presence.eventengine.effect.HeartbeatEffect;
import com.pubnub.api.presence.eventengine.effect.LeaveEffect;
import com.pubnub.api.presence.eventengine.effect.PresenceEffectInvocation;
import com.pubnub.api.presence.eventengine.effect.WaitEffect;
import com.pubnub.api.presence.eventengine.effect.effectprovider.HeartbeatProvider;
import com.pubnub.api.presence.eventengine.effect.effectprovider.LeaveProvider;
import com.pubnub.api.presence.eventengine.event.PresenceEvent;
import com.pubnub.api.subscribe.eventengine.effect.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pubnub/api/presence/eventengine/effect/PresenceEffectFactory;", "Lcom/pubnub/api/eventengine/EffectFactory;", "Lcom/pubnub/api/presence/eventengine/effect/PresenceEffectInvocation;", "heartbeatProvider", "Lcom/pubnub/api/presence/eventengine/effect/effectprovider/HeartbeatProvider;", "leaveProvider", "Lcom/pubnub/api/presence/eventengine/effect/effectprovider/LeaveProvider;", "presenceEventSink", "Lcom/pubnub/api/eventengine/Sink;", "Lcom/pubnub/api/presence/eventengine/event/PresenceEvent;", "policy", "Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "heartbeatInterval", "Ljava/time/Duration;", "(Lcom/pubnub/api/presence/eventengine/effect/effectprovider/HeartbeatProvider;Lcom/pubnub/api/presence/eventengine/effect/effectprovider/LeaveProvider;Lcom/pubnub/api/eventengine/Sink;Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;Ljava/util/concurrent/ScheduledExecutorService;Ljava/time/Duration;)V", "create", "Lcom/pubnub/api/eventengine/Effect;", "effectInvocation", "pubnub-kotlin"})
public final class PresenceEffectFactory
implements EffectFactory<PresenceEffectInvocation> {
    @NotNull
    private final HeartbeatProvider heartbeatProvider;
    @NotNull
    private final LeaveProvider leaveProvider;
    @NotNull
    private final Sink<PresenceEvent> presenceEventSink;
    @NotNull
    private final RetryPolicy policy;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final Duration heartbeatInterval;

    public PresenceEffectFactory(@NotNull HeartbeatProvider heartbeatProvider, @NotNull LeaveProvider leaveProvider, @NotNull Sink<PresenceEvent> presenceEventSink, @NotNull RetryPolicy policy, @NotNull ScheduledExecutorService executorService, @NotNull Duration heartbeatInterval) {
        Intrinsics.checkNotNullParameter((Object)heartbeatProvider, (String)"heartbeatProvider");
        Intrinsics.checkNotNullParameter((Object)leaveProvider, (String)"leaveProvider");
        Intrinsics.checkNotNullParameter(presenceEventSink, (String)"presenceEventSink");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)heartbeatInterval, (String)"heartbeatInterval");
        this.heartbeatProvider = heartbeatProvider;
        this.leaveProvider = leaveProvider;
        this.presenceEventSink = presenceEventSink;
        this.policy = policy;
        this.executorService = executorService;
        this.heartbeatInterval = heartbeatInterval;
    }

    @Override
    @Nullable
    public Effect create(@NotNull PresenceEffectInvocation effectInvocation) {
        Effect effect;
        Intrinsics.checkNotNullParameter((Object)effectInvocation, (String)"effectInvocation");
        PresenceEffectInvocation presenceEffectInvocation = effectInvocation;
        if (presenceEffectInvocation instanceof PresenceEffectInvocation.Heartbeat) {
            RemoteAction<Boolean> heartbeatRemoteAction = this.heartbeatProvider.getHeartbeatRemoteAction(((PresenceEffectInvocation.Heartbeat)effectInvocation).getChannels(), ((PresenceEffectInvocation.Heartbeat)effectInvocation).getChannelGroups());
            effect = new HeartbeatEffect(heartbeatRemoteAction, this.presenceEventSink);
        } else if (presenceEffectInvocation instanceof PresenceEffectInvocation.DelayedHeartbeat) {
            RemoteAction<Boolean> heartbeatRemoteAction = this.heartbeatProvider.getHeartbeatRemoteAction(((PresenceEffectInvocation.DelayedHeartbeat)effectInvocation).getChannels(), ((PresenceEffectInvocation.DelayedHeartbeat)effectInvocation).getChannelGroups());
            effect = new DelayedHeartbeatEffect(heartbeatRemoteAction, this.presenceEventSink, this.policy, this.executorService, (PresenceEffectInvocation.DelayedHeartbeat)effectInvocation);
        } else if (presenceEffectInvocation instanceof PresenceEffectInvocation.Leave) {
            RemoteAction<Boolean> leaveRemoteAction = this.leaveProvider.getLeaveRemoteAction(((PresenceEffectInvocation.Leave)effectInvocation).getChannels(), ((PresenceEffectInvocation.Leave)effectInvocation).getChannelGroups());
            effect = new LeaveEffect(leaveRemoteAction);
        } else if (presenceEffectInvocation instanceof PresenceEffectInvocation.Wait) {
            effect = new WaitEffect(this.heartbeatInterval, this.presenceEventSink, null, 4, null);
        } else if (Intrinsics.areEqual((Object)presenceEffectInvocation, (Object)PresenceEffectInvocation.CancelDelayedHeartbeat.INSTANCE) ? true : Intrinsics.areEqual((Object)presenceEffectInvocation, (Object)PresenceEffectInvocation.CancelWait.INSTANCE)) {
            effect = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return effect;
    }
}

