/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.subscribe;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.eventengine.EffectDispatcher;
import com.pubnub.api.eventengine.Event;
import com.pubnub.api.eventengine.EventEngine;
import com.pubnub.api.eventengine.EventEngineManager;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.subscribe.eventengine.SubscribeEventEngineKt;
import com.pubnub.api.subscribe.eventengine.configuration.EventEnginesConf;
import com.pubnub.api.subscribe.eventengine.data.SubscriptionData;
import com.pubnub.api.subscribe.eventengine.effect.RetryPolicy;
import com.pubnub.api.subscribe.eventengine.effect.SubscribeEffectFactory;
import com.pubnub.api.subscribe.eventengine.effect.SubscribeEffectInvocation;
import com.pubnub.api.subscribe.eventengine.effect.effectprovider.HandshakeProvider;
import com.pubnub.api.subscribe.eventengine.effect.effectprovider.HandshakeProviderImpl;
import com.pubnub.api.subscribe.eventengine.effect.effectprovider.ReceiveMessagesProvider;
import com.pubnub.api.subscribe.eventengine.effect.effectprovider.ReceiveMessagesProviderImpl;
import com.pubnub.api.subscribe.eventengine.event.SubscribeEvent;
import com.pubnub.api.subscribe.eventengine.event.SubscriptionCursor;
import com.pubnub.api.subscribe.eventengine.state.SubscribeState;
import com.pubnub.api.workers.SubscribeMessageProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&BI\u00128\u0010\u0002\u001a4\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0007j\u0002`\b0\u0003j\u0002`\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u000eJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019J\u0006\u0010\u001b\u001a\u00020\u000eJ\b\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\u0016\u0010\u001e\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u001f\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J4\u0010 \u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010!\u001a\u00020\"J$\u0010#\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J&\u0010$\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0006\u0010%\u001a\u00020\u000eR@\u0010\u0002\u001a4\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0007j\u0002`\b0\u0003j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pubnub/api/subscribe/Subscribe;", "", "subscribeEventEngineManager", "Lcom/pubnub/api/eventengine/EventEngineManager;", "Lcom/pubnub/api/subscribe/eventengine/effect/SubscribeEffectInvocation;", "Lcom/pubnub/api/subscribe/eventengine/event/SubscribeEvent;", "Lcom/pubnub/api/subscribe/eventengine/state/SubscribeState;", "Lcom/pubnub/api/eventengine/EventEngine;", "Lcom/pubnub/api/subscribe/eventengine/SubscribeEventEngine;", "Lcom/pubnub/api/managers/SubscribeEventEngineManager;", "subscriptionData", "Lcom/pubnub/api/subscribe/eventengine/data/SubscriptionData;", "(Lcom/pubnub/api/eventengine/EventEngineManager;Lcom/pubnub/api/subscribe/eventengine/data/SubscriptionData;)V", "addChannelGroupsToSubscriptionData", "", "channelGroups", "", "", "withPresence", "", "addChannelsToSubscriptionData", "channels", "destroy", "disconnect", "getSubscribedChannelGroups", "", "getSubscribedChannels", "reconnect", "removeAllChannelGroupsFromLocalStorage", "removeAllChannelsFromLocalStorage", "removeChannelGroupsFromSubscriptionData", "removeChannelsFromSubscriptionData", "subscribe", "withTimetoken", "", "throwExceptionIfChannelAndChannelGroupIsMissing", "unsubscribe", "unsubscribeAll", "Companion", "pubnub-kotlin"})
public final class Subscribe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager;
    @NotNull
    private final SubscriptionData subscriptionData;

    public Subscribe(@NotNull EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager, @NotNull SubscriptionData subscriptionData) {
        Intrinsics.checkNotNullParameter(subscribeEventEngineManager, (String)"subscribeEventEngineManager");
        Intrinsics.checkNotNullParameter((Object)subscriptionData, (String)"subscriptionData");
        this.subscribeEventEngineManager = subscribeEventEngineManager;
        this.subscriptionData = subscriptionData;
    }

    public /* synthetic */ Subscribe(EventEngineManager eventEngineManager, SubscriptionData subscriptionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            subscriptionData = new SubscriptionData();
        }
        this(eventEngineManager, subscriptionData);
    }

    public final synchronized void subscribe(@NotNull Set<String> channels, @NotNull Set<String> channelGroups, boolean withPresence, long withTimetoken) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        this.throwExceptionIfChannelAndChannelGroupIsMissing(channels, channelGroups);
        this.addChannelsToSubscriptionData(channels, withPresence);
        this.addChannelGroupsToSubscriptionData(channelGroups, withPresence);
        Set<String> channelsInLocalStorage = this.subscriptionData.getChannels$pubnub_kotlin();
        Set<String> channelGroupsInLocalStorage = this.subscriptionData.getChannelGroups$pubnub_kotlin();
        if (withTimetoken != 0L) {
            SubscribeEvent.SubscriptionRestored subscriptionRestoredEvent = new SubscribeEvent.SubscriptionRestored(channelsInLocalStorage, channelGroupsInLocalStorage, new SubscriptionCursor(withTimetoken, "42"));
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)subscriptionRestoredEvent));
        } else {
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)new SubscribeEvent.SubscriptionChanged(channelsInLocalStorage, channelGroupsInLocalStorage)));
        }
    }

    public static /* synthetic */ void subscribe$default(Subscribe subscribe, Set set, Set set2, boolean bl, long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = 0L;
        }
        subscribe.subscribe(set, set2, bl, l);
    }

    public final synchronized void unsubscribe(@NotNull Set<String> channels, @NotNull Set<String> channelGroups) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        this.throwExceptionIfChannelAndChannelGroupIsMissing(channels, channelGroups);
        this.removeChannelsFromSubscriptionData(channels);
        this.removeChannelGroupsFromSubscriptionData(channelGroups);
        if (this.subscriptionData.getChannels$pubnub_kotlin().size() > 0 || this.subscriptionData.getChannelGroups$pubnub_kotlin().size() > 0) {
            Set<String> channelsInLocalStorage = this.subscriptionData.getChannels$pubnub_kotlin();
            Set<String> channelGroupsInLocalStorage = this.subscriptionData.getChannelGroups$pubnub_kotlin();
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)new SubscribeEvent.SubscriptionChanged(channelsInLocalStorage, channelGroupsInLocalStorage)));
        } else {
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.UnsubscribeAll.INSTANCE));
        }
    }

    public static /* synthetic */ void unsubscribe$default(Subscribe subscribe, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        subscribe.unsubscribe(set, set2);
    }

    public final synchronized void unsubscribeAll() {
        this.removeAllChannelsFromLocalStorage();
        this.removeAllChannelGroupsFromLocalStorage();
        this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.UnsubscribeAll.INSTANCE));
    }

    @NotNull
    public final synchronized List<String> getSubscribedChannels() {
        return CollectionsKt.toList((Iterable)this.subscriptionData.getChannels$pubnub_kotlin());
    }

    @NotNull
    public final synchronized List<String> getSubscribedChannelGroups() {
        return CollectionsKt.toList((Iterable)this.subscriptionData.getChannelGroups$pubnub_kotlin());
    }

    public final void disconnect() {
        this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.Disconnect.INSTANCE));
    }

    public final void reconnect() {
        this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.Reconnect.INSTANCE));
    }

    public final synchronized void destroy() {
        this.disconnect();
        this.subscribeEventEngineManager.stop();
    }

    private final void throwExceptionIfChannelAndChannelGroupIsMissing(Set<String> channels, Set<String> channelGroups) {
        if (channels.isEmpty() && channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_OR_CHANNEL_GROUP_MISSING);
        }
    }

    private final void addChannelsToSubscriptionData(Set<String> channels, boolean withPresence) {
        this.subscriptionData.getChannels$pubnub_kotlin().addAll((Collection<String>)channels);
        if (withPresence) {
            Iterable $this$forEach$iv = channels;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String presenceChannel = it + "-pnpres";
                this.subscriptionData.getChannels$pubnub_kotlin().add(presenceChannel);
            }
        }
    }

    private final void addChannelGroupsToSubscriptionData(Set<String> channelGroups, boolean withPresence) {
        this.subscriptionData.getChannelGroups$pubnub_kotlin().addAll((Collection<String>)channelGroups);
        if (withPresence) {
            Iterable $this$forEach$iv = channelGroups;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String presenceChannelGroup = it + "-pnpres";
                this.subscriptionData.getChannelGroups$pubnub_kotlin().add(presenceChannelGroup);
            }
        }
    }

    private final void removeChannelGroupsFromSubscriptionData(Set<String> channelGroups) {
        Iterable $this$forEach$iv = channelGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.subscriptionData.getChannelGroups$pubnub_kotlin().remove(it);
            String presenceChannelGroup = it + "-pnpres";
            this.subscriptionData.getChannels$pubnub_kotlin().remove(presenceChannelGroup);
        }
    }

    private final void removeChannelsFromSubscriptionData(Set<String> channels) {
        Iterable $this$forEach$iv = channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.subscriptionData.getChannels$pubnub_kotlin().remove(it);
            String presenceChannel = it + "-pnpres";
            this.subscriptionData.getChannels$pubnub_kotlin().remove(presenceChannel);
        }
    }

    private final void removeAllChannelsFromLocalStorage() {
        this.subscriptionData.getChannels$pubnub_kotlin().clear();
    }

    private final void removeAllChannelGroupsFromLocalStorage() {
        this.subscriptionData.getChannelGroups$pubnub_kotlin().clear();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJb\u0010\u0010\u001a4\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0015j\u0002`\u00160\u0011j\u0002`\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/pubnub/api/subscribe/Subscribe$Companion;", "", "()V", "create", "Lcom/pubnub/api/subscribe/Subscribe;", "pubNub", "Lcom/pubnub/api/PubNub;", "listenerManager", "Lcom/pubnub/api/managers/ListenerManager;", "retryPolicy", "Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;", "eventEnginesConf", "Lcom/pubnub/api/subscribe/eventengine/configuration/EventEnginesConf;", "messageProcessor", "Lcom/pubnub/api/workers/SubscribeMessageProcessor;", "create$pubnub_kotlin", "createAndStartSubscribeEventEngineManager", "Lcom/pubnub/api/eventengine/EventEngineManager;", "Lcom/pubnub/api/subscribe/eventengine/effect/SubscribeEffectInvocation;", "Lcom/pubnub/api/subscribe/eventengine/event/SubscribeEvent;", "Lcom/pubnub/api/subscribe/eventengine/state/SubscribeState;", "Lcom/pubnub/api/eventengine/EventEngine;", "Lcom/pubnub/api/subscribe/eventengine/SubscribeEventEngine;", "Lcom/pubnub/api/managers/SubscribeEventEngineManager;", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Subscribe create$pubnub_kotlin(@NotNull PubNub pubNub, @NotNull ListenerManager listenerManager, @NotNull RetryPolicy retryPolicy2, @NotNull EventEnginesConf eventEnginesConf, @NotNull SubscribeMessageProcessor messageProcessor) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
            Intrinsics.checkNotNullParameter((Object)retryPolicy2, (String)"retryPolicy");
            Intrinsics.checkNotNullParameter((Object)eventEnginesConf, (String)"eventEnginesConf");
            Intrinsics.checkNotNullParameter((Object)messageProcessor, (String)"messageProcessor");
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager = this.createAndStartSubscribeEventEngineManager(pubNub, messageProcessor, eventEnginesConf, retryPolicy2, listenerManager);
            return new Subscribe(subscribeEventEngineManager, null, 2, null);
        }

        private final EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> createAndStartSubscribeEventEngineManager(PubNub pubNub, SubscribeMessageProcessor messageProcessor, EventEnginesConf eventEnginesConf, RetryPolicy retryPolicy2, ListenerManager listenerManager) {
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> eventEngineManager;
            HandshakeProvider handshakeProvider = new HandshakeProviderImpl(pubNub);
            ReceiveMessagesProvider receiveMessagesProvider = new ReceiveMessagesProviderImpl(pubNub, messageProcessor);
            Sink<SubscribeEvent> sink = eventEnginesConf.getSubscribe().getEventSink();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
            SubscribeEffectFactory subscribeEffectFactory = new SubscribeEffectFactory(handshakeProvider, receiveMessagesProvider, sink, retryPolicy2, scheduledExecutorService, listenerManager, listenerManager);
            EventEngine subscribeEventEngine = SubscribeEventEngineKt.SubscribeEventEngine$default(eventEnginesConf.getSubscribe().getEffectSink(), eventEnginesConf.getSubscribe().getEventSource(), null, 4, null);
            EffectDispatcher subscribeEffectDispatcher = new EffectDispatcher(subscribeEffectFactory, eventEnginesConf.getSubscribe().getEffectSource(), null, null, 12, null);
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> $this$createAndStartSubscribeEventEngineManager_u24lambda_u240 = eventEngineManager = new EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>>(subscribeEventEngine, subscribeEffectDispatcher, eventEnginesConf.getSubscribe().getEventSink());
            boolean bl = false;
            if (pubNub.getConfiguration().getEnableEventEngine()) {
                $this$createAndStartSubscribeEventEngineManager_u24lambda_u240.start();
            }
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager = eventEngineManager;
            return subscribeEventEngineManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

