/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.subscribe.eventengine.effect;

import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.eventengine.Effect;
import com.pubnub.api.eventengine.EffectFactory;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.subscribe.eventengine.effect.EmitMessagesEffect;
import com.pubnub.api.subscribe.eventengine.effect.EmitStatusEffect;
import com.pubnub.api.subscribe.eventengine.effect.HandshakeEffect;
import com.pubnub.api.subscribe.eventengine.effect.HandshakeReconnectEffect;
import com.pubnub.api.subscribe.eventengine.effect.MessagesConsumer;
import com.pubnub.api.subscribe.eventengine.effect.ReceiveMessagesEffect;
import com.pubnub.api.subscribe.eventengine.effect.ReceiveMessagesResult;
import com.pubnub.api.subscribe.eventengine.effect.ReceiveReconnectEffect;
import com.pubnub.api.subscribe.eventengine.effect.RetryPolicy;
import com.pubnub.api.subscribe.eventengine.effect.StatusConsumer;
import com.pubnub.api.subscribe.eventengine.effect.SubscribeEffectInvocation;
import com.pubnub.api.subscribe.eventengine.effect.effectprovider.HandshakeProvider;
import com.pubnub.api.subscribe.eventengine.effect.effectprovider.ReceiveMessagesProvider;
import com.pubnub.api.subscribe.eventengine.event.SubscribeEvent;
import com.pubnub.api.subscribe.eventengine.event.SubscriptionCursor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pubnub/api/subscribe/eventengine/effect/SubscribeEffectFactory;", "Lcom/pubnub/api/eventengine/EffectFactory;", "Lcom/pubnub/api/subscribe/eventengine/effect/SubscribeEffectInvocation;", "handshakeProvider", "Lcom/pubnub/api/subscribe/eventengine/effect/effectprovider/HandshakeProvider;", "receiveMessagesProvider", "Lcom/pubnub/api/subscribe/eventengine/effect/effectprovider/ReceiveMessagesProvider;", "subscribeEventSink", "Lcom/pubnub/api/eventengine/Sink;", "Lcom/pubnub/api/subscribe/eventengine/event/SubscribeEvent;", "policy", "Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "messagesConsumer", "Lcom/pubnub/api/subscribe/eventengine/effect/MessagesConsumer;", "statusConsumer", "Lcom/pubnub/api/subscribe/eventengine/effect/StatusConsumer;", "(Lcom/pubnub/api/subscribe/eventengine/effect/effectprovider/HandshakeProvider;Lcom/pubnub/api/subscribe/eventengine/effect/effectprovider/ReceiveMessagesProvider;Lcom/pubnub/api/eventengine/Sink;Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;Ljava/util/concurrent/ScheduledExecutorService;Lcom/pubnub/api/subscribe/eventengine/effect/MessagesConsumer;Lcom/pubnub/api/subscribe/eventengine/effect/StatusConsumer;)V", "create", "Lcom/pubnub/api/eventengine/Effect;", "effectInvocation", "pubnub-kotlin"})
public final class SubscribeEffectFactory
implements EffectFactory<SubscribeEffectInvocation> {
    @NotNull
    private final HandshakeProvider handshakeProvider;
    @NotNull
    private final ReceiveMessagesProvider receiveMessagesProvider;
    @NotNull
    private final Sink<SubscribeEvent> subscribeEventSink;
    @NotNull
    private final RetryPolicy policy;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final MessagesConsumer messagesConsumer;
    @NotNull
    private final StatusConsumer statusConsumer;

    public SubscribeEffectFactory(@NotNull HandshakeProvider handshakeProvider, @NotNull ReceiveMessagesProvider receiveMessagesProvider, @NotNull Sink<SubscribeEvent> subscribeEventSink, @NotNull RetryPolicy policy, @NotNull ScheduledExecutorService executorService, @NotNull MessagesConsumer messagesConsumer, @NotNull StatusConsumer statusConsumer) {
        Intrinsics.checkNotNullParameter((Object)handshakeProvider, (String)"handshakeProvider");
        Intrinsics.checkNotNullParameter((Object)receiveMessagesProvider, (String)"receiveMessagesProvider");
        Intrinsics.checkNotNullParameter(subscribeEventSink, (String)"subscribeEventSink");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)messagesConsumer, (String)"messagesConsumer");
        Intrinsics.checkNotNullParameter((Object)statusConsumer, (String)"statusConsumer");
        this.handshakeProvider = handshakeProvider;
        this.receiveMessagesProvider = receiveMessagesProvider;
        this.subscribeEventSink = subscribeEventSink;
        this.policy = policy;
        this.executorService = executorService;
        this.messagesConsumer = messagesConsumer;
        this.statusConsumer = statusConsumer;
    }

    public /* synthetic */ SubscribeEffectFactory(HandshakeProvider handshakeProvider, ReceiveMessagesProvider receiveMessagesProvider, Sink sink, RetryPolicy retryPolicy2, ScheduledExecutorService scheduledExecutorService, MessagesConsumer messagesConsumer, StatusConsumer statusConsumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(handshakeProvider, receiveMessagesProvider, sink, retryPolicy2, scheduledExecutorService, messagesConsumer, statusConsumer);
    }

    @Override
    @Nullable
    public Effect create(@NotNull SubscribeEffectInvocation effectInvocation) {
        Effect effect;
        Intrinsics.checkNotNullParameter((Object)effectInvocation, (String)"effectInvocation");
        SubscribeEffectInvocation subscribeEffectInvocation = effectInvocation;
        if (subscribeEffectInvocation instanceof SubscribeEffectInvocation.EmitMessages) {
            effect = new EmitMessagesEffect(this.messagesConsumer, ((SubscribeEffectInvocation.EmitMessages)effectInvocation).getMessages());
        } else if (subscribeEffectInvocation instanceof SubscribeEffectInvocation.EmitStatus) {
            effect = new EmitStatusEffect(this.statusConsumer, ((SubscribeEffectInvocation.EmitStatus)effectInvocation).getStatus());
        } else if (subscribeEffectInvocation instanceof SubscribeEffectInvocation.Handshake) {
            RemoteAction<SubscriptionCursor> handshakeRemoteAction = this.handshakeProvider.getHandshakeRemoteAction(((SubscribeEffectInvocation.Handshake)effectInvocation).getChannels(), ((SubscribeEffectInvocation.Handshake)effectInvocation).getChannelGroups());
            effect = new HandshakeEffect(handshakeRemoteAction, this.subscribeEventSink);
        } else if (subscribeEffectInvocation instanceof SubscribeEffectInvocation.HandshakeReconnect) {
            RemoteAction<SubscriptionCursor> handshakeRemoteAction = this.handshakeProvider.getHandshakeRemoteAction(((SubscribeEffectInvocation.HandshakeReconnect)effectInvocation).getChannels(), ((SubscribeEffectInvocation.HandshakeReconnect)effectInvocation).getChannelGroups());
            effect = new HandshakeReconnectEffect(handshakeRemoteAction, this.subscribeEventSink, this.policy, this.executorService, (SubscribeEffectInvocation.HandshakeReconnect)effectInvocation);
        } else if (subscribeEffectInvocation instanceof SubscribeEffectInvocation.ReceiveMessages) {
            RemoteAction<ReceiveMessagesResult> receiveMessagesRemoteAction = this.receiveMessagesProvider.getReceiveMessagesRemoteAction(((SubscribeEffectInvocation.ReceiveMessages)effectInvocation).getChannels(), ((SubscribeEffectInvocation.ReceiveMessages)effectInvocation).getChannelGroups(), ((SubscribeEffectInvocation.ReceiveMessages)effectInvocation).getSubscriptionCursor());
            effect = new ReceiveMessagesEffect(receiveMessagesRemoteAction, this.subscribeEventSink);
        } else if (subscribeEffectInvocation instanceof SubscribeEffectInvocation.ReceiveReconnect) {
            RemoteAction<ReceiveMessagesResult> receiveMessagesRemoteAction = this.receiveMessagesProvider.getReceiveMessagesRemoteAction(((SubscribeEffectInvocation.ReceiveReconnect)effectInvocation).getChannels(), ((SubscribeEffectInvocation.ReceiveReconnect)effectInvocation).getChannelGroups(), ((SubscribeEffectInvocation.ReceiveReconnect)effectInvocation).getSubscriptionCursor());
            effect = new ReceiveReconnectEffect(receiveMessagesRemoteAction, this.subscribeEventSink, this.policy, this.executorService, ((SubscribeEffectInvocation.ReceiveReconnect)effectInvocation).getAttempts(), ((SubscribeEffectInvocation.ReceiveReconnect)effectInvocation).getReason());
        } else if (((Intrinsics.areEqual((Object)subscribeEffectInvocation, (Object)SubscribeEffectInvocation.CancelHandshake.INSTANCE) ? true : Intrinsics.areEqual((Object)subscribeEffectInvocation, (Object)SubscribeEffectInvocation.CancelHandshakeReconnect.INSTANCE)) ? true : Intrinsics.areEqual((Object)subscribeEffectInvocation, (Object)SubscribeEffectInvocation.CancelReceiveMessages.INSTANCE)) ? true : Intrinsics.areEqual((Object)subscribeEffectInvocation, (Object)SubscribeEffectInvocation.CancelReceiveReconnect.INSTANCE)) {
            effect = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return effect;
    }
}

