/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.vendor;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.vendor.Base64;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private final boolean dynamicIV;
    byte[] keyBytes = null;
    byte[] ivBytes = null;
    String initializationVector = "0123456789012345";
    String cipherKey;
    boolean INIT = false;

    public Crypto(String cipherKey) {
        this(cipherKey, false);
    }

    public Crypto(String cipherKey, String customInitializationVector) {
        this(cipherKey, false);
        if (customInitializationVector != null) {
            this.initializationVector = customInitializationVector;
        }
    }

    public Crypto(String cipherKey, boolean dynamicIV) {
        this.cipherKey = cipherKey;
        this.dynamicIV = dynamicIV;
    }

    public void initCiphers() throws PubNubException {
        if (this.INIT && !this.dynamicIV) {
            return;
        }
        try {
            this.keyBytes = new String(Crypto.hexEncode(Crypto.sha256(this.cipherKey.getBytes(ENCODING_UTF_8))), ENCODING_UTF_8).substring(0, 32).toLowerCase().getBytes(ENCODING_UTF_8);
            if (this.dynamicIV) {
                this.ivBytes = new byte[16];
                new Random().nextBytes(this.ivBytes);
            } else {
                this.ivBytes = this.initializationVector.getBytes(ENCODING_UTF_8);
                this.INIT = true;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw Crypto.newCryptoError(11, e);
        }
    }

    public static byte[] hexEncode(byte[] input) throws PubNubException {
        StringBuffer result = new StringBuffer();
        for (byte byt : input) {
            result.append(Integer.toString((byt & 0xFF) + 256, 16).substring(1));
        }
        try {
            return result.toString().getBytes(ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw Crypto.newCryptoError(12, e);
        }
    }

    public static PubNubException newCryptoError(int code, Exception exception) {
        return new PubNubException(exception.getClass().getSimpleName() + " " + exception.getMessage() + " " + code, PubNubError.CRYPTO_ERROR, null, 0, null);
    }

    public String encrypt(String input) throws PubNubException {
        return this.encrypt(input, 2);
    }

    public String encrypt(String input, Integer flags) throws PubNubException {
        try {
            this.initCiphers();
            IvParameterSpec ivSpec = new IvParameterSpec(this.ivBytes);
            SecretKeySpec newKey = new SecretKeySpec(this.keyBytes, "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(1, (Key)newKey, ivSpec);
            if (this.dynamicIV) {
                byte[] encrypted = cipher.doFinal(input.getBytes(ENCODING_UTF_8));
                byte[] encryptedWithIV = new byte[this.ivBytes.length + encrypted.length];
                System.arraycopy(this.ivBytes, 0, encryptedWithIV, 0, this.ivBytes.length);
                System.arraycopy(encrypted, 0, encryptedWithIV, this.ivBytes.length, encrypted.length);
                return new String(Base64.encode(encryptedWithIV, flags), ENCODING_UTF_8);
            }
            return new String(Base64.encode(cipher.doFinal(input.getBytes(ENCODING_UTF_8)), flags), ENCODING_UTF_8);
        }
        catch (Exception e) {
            throw Crypto.newCryptoError(0, e);
        }
    }

    public String decrypt(String cipher_text) throws PubNubException {
        return this.decrypt(cipher_text, 2);
    }

    public String decrypt(String cipher_text, Integer flags) throws PubNubException {
        try {
            byte[] dataBytes;
            this.initCiphers();
            if (this.dynamicIV) {
                dataBytes = Base64.decode(cipher_text, (int)flags);
                System.arraycopy(dataBytes, 0, this.ivBytes, 0, 16);
                byte[] receivedCipherBytes = new byte[dataBytes.length - 16];
                System.arraycopy(dataBytes, 16, receivedCipherBytes, 0, dataBytes.length - 16);
                dataBytes = receivedCipherBytes;
            } else {
                dataBytes = Base64.decode(cipher_text, (int)flags);
            }
            IvParameterSpec ivSpec = new IvParameterSpec(this.ivBytes);
            SecretKeySpec newKey = new SecretKeySpec(this.keyBytes, "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(2, (Key)newKey, ivSpec);
            return new String(cipher.doFinal(dataBytes), ENCODING_UTF_8);
        }
        catch (Exception e) {
            throw Crypto.newCryptoError(0, e);
        }
    }

    public static byte[] sha256(byte[] input) throws PubNubException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashedBytes = digest.digest(input);
            return hashedBytes;
        }
        catch (Exception e) {
            throw Crypto.newCryptoError(0, e);
        }
    }
}

