/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNDownloadFileResult;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0014J2\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0013j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pubnub/api/endpoints/files/DownloadFile;", "Lcom/pubnub/api/Endpoint;", "Lokhttp3/ResponseBody;", "Lcom/pubnub/api/models/consumer/files/PNDownloadFileResult;", "channel", "", "fileName", "fileId", "cryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "pubNub", "Lcom/pubnub/api/PubNub;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/crypto/CryptoModule;Lcom/pubnub/api/PubNub;)V", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "pubnub-kotlin"})
public final class DownloadFile
extends Endpoint<ResponseBody, PNDownloadFileResult> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileId;
    @Nullable
    private final CryptoModule cryptoModule;

    public DownloadFile(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable CryptoModule cryptoModule, @NotNull PubNub pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
        this.cryptoModule = cryptoModule;
    }

    public /* synthetic */ DownloadFile(String string, String string2, String string3, CryptoModule cryptoModule, PubNub pubNub, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            cryptoModule = null;
        }
        this(string, string2, string3, cryptoModule, pubNub);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<ResponseBody> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getFilesService$pubnub_kotlin().downloadFile(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, this.fileId, this.fileName, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNDownloadFileResult createResponse(@NotNull Response<ResponseBody> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (!input.isSuccessful()) {
            throw new PubNubException(PubNubError.HTTP_ERROR);
        }
        if (input.body() == null) {
            throw new PubNubException(PubNubError.INTERNAL_ERROR);
        }
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        InputStream bodyStream = ((ResponseBody)object).byteStream();
        Object object2 = this.cryptoModule;
        if (object2 == null || (object2 = ((CryptoModule)object2).decryptStream(bodyStream)) == null) {
            object2 = bodyStream;
        }
        Object byteStream = object2;
        return new PNDownloadFileResult(this.fileName, (InputStream)byteStream);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }
}

