/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.builder.StateOperation;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.models.server.Envelope;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B=\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u00042\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001cH\u0014J(\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001fH\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0017H\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/pubnub/api/endpoints/presence/SetState;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNSetStateResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "channelGroups", "state", "", "uuid", "(Lcom/pubnub/api/PubNub;Ljava/util/List;Ljava/util/List;Ljava/lang/Object;Ljava/lang/String;)V", "getChannelGroups", "()Ljava/util/List;", "getChannels", "getState", "()Ljava/lang/Object;", "getUuid", "()Ljava/lang/String;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSetStateOperation;", "validateParams", "pubnub-kotlin"})
public final class SetState
extends Endpoint<Envelope<JsonElement>, PNSetStateResult> {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final Object state;
    @NotNull
    private final String uuid;

    public SetState(@NotNull PubNub pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull Object state, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.state = state;
        this.uuid = uuid;
    }

    public /* synthetic */ SetState(PubNub pubNub, List list, List list2, Object object, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = pubNub.getConfiguration().getUserId().getValue();
        }
        this(pubNub, list, list2, object, string);
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @NotNull
    public final Object getState() {
        return this.state;
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty() && this.channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        if (Intrinsics.areEqual((Object)this.uuid, (Object)this.getPubnub().getConfiguration().getUserId().getValue())) {
            Object object = this.state;
            List<String> list = this.channels;
            List<String> list2 = this.channelGroups;
            this.getPubnub().getSubscriptionManager$pubnub_kotlin().adaptStateBuilder$pubnub_kotlin(new StateOperation(list, list2, object));
        }
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getPresenceService$pubnub_kotlin().setState(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), this.uuid, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNSetStateResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object t = ((Envelope)object).getPayload$pubnub_kotlin();
        Intrinsics.checkNotNull(t);
        if (t instanceof JsonNull) {
            throw new PubNubException(PubNubError.PARSING_ERROR);
        }
        Object object2 = input.body();
        Intrinsics.checkNotNull((Object)object2);
        Object t2 = ((Envelope)object2).getPayload$pubnub_kotlin();
        Intrinsics.checkNotNull(t2);
        return new PNSetStateResult((JsonElement)t2);
    }

    @Override
    @NotNull
    public PNOperationType.PNSetStateOperation operationType() {
        return PNOperationType.PNSetStateOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.channelGroups).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.channelGroups));
        }
        queryParams.put("state", this.getPubnub().getMapper().toJson(this.state));
    }
}

